/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.handlers.proxy;

import io.undertow.UndertowLogger;
import io.undertow.UndertowMessages;
import io.undertow.attribute.ExchangeAttribute;
import io.undertow.attribute.ExchangeAttributes;
import io.undertow.client.ClientCallback;
import io.undertow.client.ClientConnection;
import io.undertow.client.ClientExchange;
import io.undertow.client.ClientRequest;
import io.undertow.client.ClientResponse;
import io.undertow.client.ContinueNotification;
import io.undertow.client.ProxiedRequestAttachments;
import io.undertow.client.PushCallback;
import io.undertow.io.IoCallback;
import io.undertow.io.Sender;
import io.undertow.predicate.IdempotentPredicate;
import io.undertow.predicate.Predicate;
import io.undertow.server.ExchangeCompletionListener;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.HttpUpgradeListener;
import io.undertow.server.RenegotiationRequiredException;
import io.undertow.server.SSLSessionInfo;
import io.undertow.server.handlers.ResponseCodeHandler;
import io.undertow.server.handlers.proxy.ProxyCallback;
import io.undertow.server.handlers.proxy.ProxyClient;
import io.undertow.server.handlers.proxy.ProxyConnection;
import io.undertow.server.protocol.http.HttpAttachments;
import io.undertow.server.protocol.http.HttpContinue;
import io.undertow.util.Attachable;
import io.undertow.util.AttachmentKey;
import io.undertow.util.Certificates;
import io.undertow.util.CopyOnWriteMap;
import io.undertow.util.HeaderMap;
import io.undertow.util.HeaderValues;
import io.undertow.util.Headers;
import io.undertow.util.HttpString;
import io.undertow.util.NetworkUtils;
import io.undertow.util.SameThreadExecutor;
import io.undertow.util.Transfer;
import io.undertow.util.WorkerUtils;
import java.io.Closeable;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.channels.Channel;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.security.cert.CertificateEncodingException;
import javax.security.cert.X509Certificate;
import org.jboss.logging.Logger;
import org.xnio.ChannelExceptionHandler;
import org.xnio.ChannelListener;
import org.xnio.ChannelListeners;
import org.xnio.IoUtils;
import org.xnio.StreamConnection;
import org.xnio.XnioExecutor;
import org.xnio.channels.StreamSinkChannel;

public final class ProxyHandler
implements HttpHandler {
    private static final int DEFAULT_MAX_RETRY_ATTEMPTS = Integer.getInteger("io.undertow.server.handlers.proxy.maxRetries", 1);
    private static final Logger log = Logger.getLogger(ProxyHandler.class.getPackage().getName());
    public static final String UTF_8 = StandardCharsets.UTF_8.name();
    private static final AttachmentKey<ProxyConnection> CONNECTION = AttachmentKey.create(ProxyConnection.class);
    private static final AttachmentKey<HttpServerExchange> EXCHANGE = AttachmentKey.create(HttpServerExchange.class);
    private static final AttachmentKey<XnioExecutor.Key> TIMEOUT_KEY = AttachmentKey.create(XnioExecutor.Key.class);
    private final ProxyClient proxyClient;
    private final int maxRequestTime;
    private final Map<HttpString, ExchangeAttribute> requestHeaders = new CopyOnWriteMap<HttpString, ExchangeAttribute>();
    private final HttpHandler next;
    private volatile boolean rewriteHostHeader;
    private volatile boolean reuseXForwarded;
    private volatile int maxConnectionRetries;
    private final Predicate idempotentRequestPredicate;

    @Deprecated
    public ProxyHandler(ProxyClient proxyClient, int maxRequestTime, HttpHandler next) {
        this(proxyClient, maxRequestTime, next, false, false);
    }

    @Deprecated
    public ProxyHandler(ProxyClient proxyClient, int maxRequestTime, HttpHandler next, boolean rewriteHostHeader, boolean reuseXForwarded) {
        this(proxyClient, maxRequestTime, next, rewriteHostHeader, reuseXForwarded, DEFAULT_MAX_RETRY_ATTEMPTS);
    }

    @Deprecated
    public ProxyHandler(ProxyClient proxyClient, int maxRequestTime, HttpHandler next, boolean rewriteHostHeader, boolean reuseXForwarded, int maxConnectionRetries) {
        this.proxyClient = proxyClient;
        this.maxRequestTime = maxRequestTime;
        this.next = next;
        this.rewriteHostHeader = rewriteHostHeader;
        this.reuseXForwarded = reuseXForwarded;
        this.maxConnectionRetries = maxConnectionRetries;
        this.idempotentRequestPredicate = IdempotentPredicate.INSTANCE;
    }

    @Deprecated
    public ProxyHandler(ProxyClient proxyClient, HttpHandler next) {
        this(proxyClient, -1, next);
    }

    ProxyHandler(Builder builder) {
        this.proxyClient = builder.proxyClient;
        this.maxRequestTime = builder.maxRequestTime;
        this.next = builder.next;
        this.rewriteHostHeader = builder.rewriteHostHeader;
        this.reuseXForwarded = builder.reuseXForwarded;
        this.maxConnectionRetries = builder.maxConnectionRetries;
        this.idempotentRequestPredicate = builder.idempotentRequestPredicate;
        for (Map.Entry e : builder.requestHeaders.entrySet()) {
            this.requestHeaders.put((HttpString)e.getKey(), (ExchangeAttribute)e.getValue());
        }
    }

    @Override
    public void handleRequest(final HttpServerExchange exchange) throws Exception {
        ProxyClient.ProxyTarget target = this.proxyClient.findTarget(exchange);
        if (target == null) {
            log.debugf("No proxy target for request to %s", (Object)exchange.getRequestURL());
            this.next.handleRequest(exchange);
            return;
        }
        if (exchange.isResponseStarted()) {
            UndertowLogger.REQUEST_LOGGER.cannotProxyStartedRequest(exchange);
            exchange.setStatusCode(500);
            exchange.endExchange();
            return;
        }
        long timeout = this.maxRequestTime > 0 ? System.currentTimeMillis() + (long)this.maxRequestTime : 0L;
        int maxRetries = this.maxConnectionRetries;
        if (target instanceof ProxyClient.MaxRetriesProxyTarget) {
            maxRetries = Math.max(maxRetries, ((ProxyClient.MaxRetriesProxyTarget)target).getMaxRetries());
        }
        final ProxyClientHandler clientHandler = new ProxyClientHandler(exchange, target, timeout, maxRetries, this.idempotentRequestPredicate);
        if (timeout > 0L) {
            final XnioExecutor.Key key = WorkerUtils.executeAfter(exchange.getIoThread(), new Runnable(){

                @Override
                public void run() {
                    clientHandler.cancel(exchange);
                }
            }, this.maxRequestTime, TimeUnit.MILLISECONDS);
            exchange.putAttachment(TIMEOUT_KEY, key);
            exchange.addExchangeCompleteListener(new ExchangeCompletionListener(){

                @Override
                public void exchangeEvent(HttpServerExchange exchange, ExchangeCompletionListener.NextListener nextListener) {
                    key.remove();
                    nextListener.proceed();
                }
            });
        }
        exchange.dispatch(exchange.isInIoThread() ? SameThreadExecutor.INSTANCE : exchange.getIoThread(), clientHandler);
    }

    @Deprecated
    public ProxyHandler addRequestHeader(HttpString header, ExchangeAttribute attribute) {
        this.requestHeaders.put(header, attribute);
        return this;
    }

    @Deprecated
    public ProxyHandler addRequestHeader(HttpString header, String value) {
        this.requestHeaders.put(header, ExchangeAttributes.constant(value));
        return this;
    }

    @Deprecated
    public ProxyHandler addRequestHeader(HttpString header, String attribute, ClassLoader classLoader) {
        this.requestHeaders.put(header, ExchangeAttributes.parser(classLoader).parse(attribute));
        return this;
    }

    @Deprecated
    public ProxyHandler removeRequestHeader(HttpString header) {
        this.requestHeaders.remove(header);
        return this;
    }

    static void copyHeaders(HeaderMap to, HeaderMap from) {
        long f = from.fastIterateNonEmpty();
        while (f != -1L) {
            HeaderValues values = from.fiCurrent(f);
            if (!to.contains(values.getHeaderName())) {
                to.putAll(values.getHeaderName(), values);
            }
            f = from.fiNextNonEmpty(f);
        }
    }

    public ProxyClient getProxyClient() {
        return this.proxyClient;
    }

    static void handleFailure(HttpServerExchange exchange, ProxyClientHandler proxyClientHandler, Predicate idempotentRequestPredicate, IOException e) {
        UndertowLogger.PROXY_REQUEST_LOGGER.proxyRequestFailed(exchange.getRequestURI(), e);
        if (exchange.isResponseStarted()) {
            IoUtils.safeClose((Closeable)exchange.getConnection());
        } else if (idempotentRequestPredicate.resolve(exchange) && proxyClientHandler != null) {
            proxyClientHandler.failed(exchange);
        } else {
            exchange.setStatusCode(503);
            exchange.endExchange();
        }
    }

    @Deprecated
    public ProxyHandler setMaxConnectionRetries(int maxConnectionRetries) {
        this.maxConnectionRetries = maxConnectionRetries;
        return this;
    }

    public boolean isRewriteHostHeader() {
        return this.rewriteHostHeader;
    }

    @Deprecated
    public ProxyHandler setRewriteHostHeader(boolean rewriteHostHeader) {
        this.rewriteHostHeader = rewriteHostHeader;
        return this;
    }

    public boolean isReuseXForwarded() {
        return this.reuseXForwarded;
    }

    @Deprecated
    public ProxyHandler setReuseXForwarded(boolean reuseXForwarded) {
        this.reuseXForwarded = reuseXForwarded;
        return this;
    }

    public int getMaxConnectionRetries() {
        return this.maxConnectionRetries;
    }

    public Predicate getIdempotentRequestPredicate() {
        return this.idempotentRequestPredicate;
    }

    public static Builder builder() {
        return new Builder();
    }

    static /* synthetic */ int access$2600() {
        return DEFAULT_MAX_RETRY_ATTEMPTS;
    }

    public static class Builder {
        private ProxyClient proxyClient;
        private int maxRequestTime = -1;
        private final Map<HttpString, ExchangeAttribute> requestHeaders = new CopyOnWriteMap<HttpString, ExchangeAttribute>();
        private HttpHandler next = ResponseCodeHandler.HANDLE_404;
        private boolean rewriteHostHeader;
        private boolean reuseXForwarded;
        private int maxConnectionRetries = ProxyHandler.access$2600();
        private Predicate idempotentRequestPredicate = IdempotentPredicate.INSTANCE;

        Builder() {
        }

        public ProxyClient getProxyClient() {
            return this.proxyClient;
        }

        public Builder setProxyClient(ProxyClient proxyClient) {
            if (proxyClient == null) {
                throw UndertowMessages.MESSAGES.argumentCannotBeNull("proxyClient");
            }
            this.proxyClient = proxyClient;
            return this;
        }

        public int getMaxRequestTime() {
            return this.maxRequestTime;
        }

        public Builder setMaxRequestTime(int maxRequestTime) {
            this.maxRequestTime = maxRequestTime;
            return this;
        }

        public Map<HttpString, ExchangeAttribute> getRequestHeaders() {
            return Collections.unmodifiableMap(this.requestHeaders);
        }

        public Builder addRequestHeader(HttpString header, ExchangeAttribute value) {
            this.requestHeaders.put(header, value);
            return this;
        }

        public HttpHandler getNext() {
            return this.next;
        }

        public Builder setNext(HttpHandler next) {
            this.next = next;
            return this;
        }

        public boolean isRewriteHostHeader() {
            return this.rewriteHostHeader;
        }

        public Builder setRewriteHostHeader(boolean rewriteHostHeader) {
            this.rewriteHostHeader = rewriteHostHeader;
            return this;
        }

        public boolean isReuseXForwarded() {
            return this.reuseXForwarded;
        }

        public Builder setReuseXForwarded(boolean reuseXForwarded) {
            this.reuseXForwarded = reuseXForwarded;
            return this;
        }

        public int getMaxConnectionRetries() {
            return this.maxConnectionRetries;
        }

        public Builder setMaxConnectionRetries(int maxConnectionRetries) {
            this.maxConnectionRetries = maxConnectionRetries;
            return this;
        }

        public Predicate getIdempotentRequestPredicate() {
            return this.idempotentRequestPredicate;
        }

        public Builder setIdempotentRequestPredicate(Predicate idempotentRequestPredicate) {
            if (idempotentRequestPredicate == null) {
                throw UndertowMessages.MESSAGES.argumentCannotBeNull("idempotentRequestPredicate");
            }
            this.idempotentRequestPredicate = idempotentRequestPredicate;
            return this;
        }

        public ProxyHandler build() {
            return new ProxyHandler(this);
        }
    }

    private static final class ClosingExceptionHandler
    implements ChannelExceptionHandler<Channel> {
        private final Closeable[] toClose;

        private ClosingExceptionHandler(Closeable ... toClose) {
            this.toClose = toClose;
        }

        @Override
        public void handleException(Channel channel, IOException exception) {
            IoUtils.safeClose((Closeable)channel);
            IoUtils.safeClose(this.toClose);
        }
    }

    private static final class IoExceptionHandler
    implements ChannelExceptionHandler<Channel> {
        private final HttpServerExchange exchange;
        private final ClientConnection clientConnection;

        private IoExceptionHandler(HttpServerExchange exchange, ClientConnection clientConnection) {
            this.exchange = exchange;
            this.clientConnection = clientConnection;
        }

        @Override
        public void handleException(Channel channel, IOException exception) {
            IoUtils.safeClose((Closeable)channel);
            IoUtils.safeClose((Closeable)this.clientConnection);
            if (this.exchange.isResponseStarted()) {
                UndertowLogger.REQUEST_IO_LOGGER.debug("Exception reading from target server", exception);
                if (!this.exchange.isResponseStarted()) {
                    this.exchange.setStatusCode(500);
                    this.exchange.endExchange();
                } else {
                    IoUtils.safeClose((Closeable)this.exchange.getConnection());
                }
            } else {
                UndertowLogger.REQUEST_IO_LOGGER.ioException(exception);
                this.exchange.setStatusCode(500);
                this.exchange.endExchange();
            }
        }
    }

    private static final class HTTPTrailerChannelListener
    implements ChannelListener<StreamSinkChannel> {
        private final Attachable source;
        private final Attachable target;
        private final HttpServerExchange exchange;
        private final ProxyClientHandler proxyClientHandler;
        private final Predicate idempotentPredicate;

        private HTTPTrailerChannelListener(Attachable source, Attachable target, HttpServerExchange exchange, ProxyClientHandler proxyClientHandler, Predicate idempotentPredicate) {
            this.source = source;
            this.target = target;
            this.exchange = exchange;
            this.proxyClientHandler = proxyClientHandler;
            this.idempotentPredicate = idempotentPredicate;
        }

        @Override
        public void handleEvent(StreamSinkChannel channel) {
            HeaderMap trailers = this.source.getAttachment(HttpAttachments.REQUEST_TRAILERS);
            if (trailers != null) {
                this.target.putAttachment(HttpAttachments.RESPONSE_TRAILERS, trailers);
            }
            try {
                channel.shutdownWrites();
                if (!channel.flush()) {
                    channel.getWriteSetter().set(ChannelListeners.flushingChannelListener(new ChannelListener<StreamSinkChannel>(){

                        @Override
                        public void handleEvent(StreamSinkChannel channel) {
                            channel.suspendWrites();
                            channel.getWriteSetter().set(null);
                        }
                    }, ChannelListeners.closingChannelExceptionHandler()));
                    channel.resumeWrites();
                } else {
                    channel.getWriteSetter().set(null);
                    channel.shutdownWrites();
                }
            }
            catch (IOException e) {
                ProxyHandler.handleFailure(this.exchange, this.proxyClientHandler, this.idempotentPredicate, e);
            }
            catch (Exception e) {
                ProxyHandler.handleFailure(this.exchange, this.proxyClientHandler, this.idempotentPredicate, new IOException(e));
            }
        }
    }

    private static final class ResponseCallback
    implements ClientCallback<ClientExchange> {
        private final HttpServerExchange exchange;
        private final ProxyClientHandler proxyClientHandler;
        private final Predicate idempotentPredicate;

        private ResponseCallback(HttpServerExchange exchange, ProxyClientHandler proxyClientHandler, Predicate idempotentPredicate) {
            this.exchange = exchange;
            this.proxyClientHandler = proxyClientHandler;
            this.idempotentPredicate = idempotentPredicate;
        }

        @Override
        public void completed(final ClientExchange result) {
            ClientResponse response = result.getResponse();
            if (log.isDebugEnabled()) {
                log.debugf("Received response %s for request %s for exchange %s", (Object)response, (Object)result.getRequest(), (Object)this.exchange);
            }
            HeaderMap inboundResponseHeaders = response.getResponseHeaders();
            HeaderMap outboundResponseHeaders = this.exchange.getResponseHeaders();
            this.exchange.setStatusCode(response.getResponseCode());
            ProxyHandler.copyHeaders(outboundResponseHeaders, inboundResponseHeaders);
            if (this.exchange.isUpgrade()) {
                this.exchange.upgradeChannel(new HttpUpgradeListener(){

                    @Override
                    public void handleUpgrade(StreamConnection streamConnection, HttpServerExchange exchange) {
                        if (log.isDebugEnabled()) {
                            log.debugf("Upgraded request %s to for exchange %s", (Object)result.getRequest(), (Object)exchange);
                        }
                        StreamConnection clientChannel = null;
                        try {
                            clientChannel = result.getConnection().performUpgrade();
                            ClosingExceptionHandler handler = new ClosingExceptionHandler(new Closeable[]{streamConnection, clientChannel});
                            Transfer.initiateTransfer(clientChannel.getSourceChannel(), streamConnection.getSinkChannel(), ChannelListeners.closingChannelListener(), ChannelListeners.writeShutdownChannelListener(ChannelListeners.flushingChannelListener(ChannelListeners.closingChannelListener(), ChannelListeners.closingChannelExceptionHandler()), ChannelListeners.closingChannelExceptionHandler()), handler, handler, result.getConnection().getBufferPool());
                            Transfer.initiateTransfer(streamConnection.getSourceChannel(), clientChannel.getSinkChannel(), ChannelListeners.closingChannelListener(), ChannelListeners.writeShutdownChannelListener(ChannelListeners.flushingChannelListener(ChannelListeners.closingChannelListener(), ChannelListeners.closingChannelExceptionHandler()), ChannelListeners.closingChannelExceptionHandler()), handler, handler, result.getConnection().getBufferPool());
                        }
                        catch (IOException e) {
                            IoUtils.safeClose(streamConnection, clientChannel);
                        }
                    }
                });
            }
            IoExceptionHandler handler = new IoExceptionHandler(this.exchange, result.getConnection());
            Transfer.initiateTransfer(result.getResponseChannel(), this.exchange.getResponseChannel(), ChannelListeners.closingChannelListener(), new HTTPTrailerChannelListener(result, this.exchange, this.exchange, this.proxyClientHandler, this.idempotentPredicate), handler, handler, this.exchange.getConnection().getByteBufferPool());
        }

        @Override
        public void failed(IOException e) {
            ProxyHandler.handleFailure(this.exchange, this.proxyClientHandler, this.idempotentPredicate, e);
        }
    }

    private static class ProxyAction
    implements Runnable {
        private final ProxyConnection clientConnection;
        private final HttpServerExchange exchange;
        private final Map<HttpString, ExchangeAttribute> requestHeaders;
        private final boolean rewriteHostHeader;
        private final boolean reuseXForwarded;
        private final ProxyClientHandler proxyClientHandler;
        private final Predicate idempotentPredicate;

        ProxyAction(ProxyConnection clientConnection, HttpServerExchange exchange, Map<HttpString, ExchangeAttribute> requestHeaders, boolean rewriteHostHeader, boolean reuseXForwarded, ProxyClientHandler proxyClientHandler, Predicate idempotentPredicate) {
            this.clientConnection = clientConnection;
            this.exchange = exchange;
            this.requestHeaders = requestHeaders;
            this.rewriteHostHeader = rewriteHostHeader;
            this.reuseXForwarded = reuseXForwarded;
            this.proxyClientHandler = proxyClientHandler;
            this.idempotentPredicate = idempotentPredicate;
        }

        @Override
        public void run() {
            String hostName;
            String proto;
            String remoteHost;
            int uriPart;
            final ClientRequest request = new ClientRequest();
            String targetURI = this.exchange.getRequestURI();
            if (this.exchange.isHostIncludedInRequestURI() && (uriPart = targetURI.indexOf("//")) != -1 && (uriPart = targetURI.indexOf("/", uriPart + 2)) != -1) {
                targetURI = targetURI.substring(uriPart);
            }
            if (!this.exchange.getResolvedPath().isEmpty() && targetURI.startsWith(this.exchange.getResolvedPath())) {
                targetURI = targetURI.substring(this.exchange.getResolvedPath().length());
            }
            StringBuilder requestURI = new StringBuilder();
            if (!(this.clientConnection.getTargetPath().isEmpty() || this.clientConnection.getTargetPath().equals("/") && !targetURI.isEmpty())) {
                requestURI.append(this.clientConnection.getTargetPath());
            }
            requestURI.append(targetURI);
            String qs = this.exchange.getQueryString();
            if (qs != null && !qs.isEmpty()) {
                requestURI.append('?');
                requestURI.append(qs);
            }
            request.setPath(requestURI.toString()).setMethod(this.exchange.getRequestMethod());
            HeaderMap inboundRequestHeaders = this.exchange.getRequestHeaders();
            HeaderMap outboundRequestHeaders = request.getRequestHeaders();
            ProxyHandler.copyHeaders(outboundRequestHeaders, inboundRequestHeaders);
            if (!this.exchange.isPersistent()) {
                outboundRequestHeaders.put(Headers.CONNECTION, "keep-alive");
            }
            if ("h2c".equals(this.exchange.getRequestHeaders().getFirst(Headers.UPGRADE))) {
                this.exchange.getRequestHeaders().remove(Headers.UPGRADE);
                outboundRequestHeaders.put(Headers.CONNECTION, "keep-alive");
            }
            for (Map.Entry<HttpString, ExchangeAttribute> entry : this.requestHeaders.entrySet()) {
                String headerValue = entry.getValue().readAttribute(this.exchange);
                if (headerValue == null || headerValue.isEmpty()) {
                    outboundRequestHeaders.remove(entry.getKey());
                    continue;
                }
                outboundRequestHeaders.put(entry.getKey(), headerValue.replace('\n', ' '));
            }
            SocketAddress address = this.exchange.getConnection().getPeerAddress();
            if (address != null && address instanceof InetSocketAddress) {
                remoteHost = ((InetSocketAddress)address).getHostString();
                if (!((InetSocketAddress)address).isUnresolved()) {
                    request.putAttachment(ProxiedRequestAttachments.REMOTE_ADDRESS, ((InetSocketAddress)address).getAddress().getHostAddress());
                }
            } else {
                remoteHost = "localhost";
            }
            request.putAttachment(ProxiedRequestAttachments.REMOTE_HOST, remoteHost);
            if (this.reuseXForwarded && request.getRequestHeaders().contains(Headers.X_FORWARDED_FOR)) {
                String current = request.getRequestHeaders().getFirst(Headers.X_FORWARDED_FOR);
                if (current == null || current.isEmpty()) {
                    request.getRequestHeaders().put(Headers.X_FORWARDED_FOR, remoteHost);
                } else {
                    request.getRequestHeaders().put(Headers.X_FORWARDED_FOR, current + "," + remoteHost);
                }
            } else {
                request.getRequestHeaders().put(Headers.X_FORWARDED_FOR, remoteHost);
            }
            if (!this.exchange.getConnection().isPushSupported() && this.clientConnection.getConnection().isPushSupported()) {
                request.getRequestHeaders().put(Headers.X_DISABLE_PUSH, "true");
            }
            if (this.reuseXForwarded && this.exchange.getRequestHeaders().contains(Headers.X_FORWARDED_PROTO)) {
                proto = this.exchange.getRequestHeaders().getFirst(Headers.X_FORWARDED_PROTO);
                request.putAttachment(ProxiedRequestAttachments.IS_SSL, proto.equals("https"));
            } else {
                proto = this.exchange.getRequestScheme().equals("https") ? "https" : "http";
                request.getRequestHeaders().put(Headers.X_FORWARDED_PROTO, proto);
                request.putAttachment(ProxiedRequestAttachments.IS_SSL, proto.equals("https"));
            }
            if (this.reuseXForwarded && this.exchange.getRequestHeaders().contains(Headers.X_FORWARDED_SERVER)) {
                hostName = this.exchange.getRequestHeaders().getFirst(Headers.X_FORWARDED_SERVER);
                request.putAttachment(ProxiedRequestAttachments.SERVER_NAME, hostName);
            } else {
                hostName = this.exchange.getHostName();
                request.getRequestHeaders().put(Headers.X_FORWARDED_SERVER, hostName);
                request.putAttachment(ProxiedRequestAttachments.SERVER_NAME, hostName);
            }
            if (!this.exchange.getRequestHeaders().contains(Headers.X_FORWARDED_HOST) && (hostName = this.exchange.getHostName()) != null) {
                request.getRequestHeaders().put(Headers.X_FORWARDED_HOST, NetworkUtils.formatPossibleIpv6Address(hostName));
            }
            if (this.reuseXForwarded && this.exchange.getRequestHeaders().contains(Headers.X_FORWARDED_PORT)) {
                try {
                    int port = Integer.parseInt(this.exchange.getRequestHeaders().getFirst(Headers.X_FORWARDED_PORT));
                    request.putAttachment(ProxiedRequestAttachments.SERVER_PORT, port);
                }
                catch (NumberFormatException e) {
                    int port = this.exchange.getConnection().getLocalAddress(InetSocketAddress.class).getPort();
                    request.getRequestHeaders().put(Headers.X_FORWARDED_PORT, port);
                    request.putAttachment(ProxiedRequestAttachments.SERVER_PORT, port);
                }
            } else {
                int port = this.exchange.getHostPort();
                request.getRequestHeaders().put(Headers.X_FORWARDED_PORT, port);
                request.putAttachment(ProxiedRequestAttachments.SERVER_PORT, port);
            }
            SSLSessionInfo sslSessionInfo = this.exchange.getConnection().getSslSessionInfo();
            if (sslSessionInfo != null) {
                try {
                    X509Certificate[] peerCertificates = sslSessionInfo.getPeerCertificateChain();
                    if (peerCertificates.length > 0) {
                        request.putAttachment(ProxiedRequestAttachments.SSL_CERT, Certificates.toPem(peerCertificates[0]));
                    }
                }
                catch (RenegotiationRequiredException | SSLPeerUnverifiedException | CertificateEncodingException exception) {
                    // empty catch block
                }
                request.putAttachment(ProxiedRequestAttachments.SSL_CYPHER, sslSessionInfo.getCipherSuite());
                request.putAttachment(ProxiedRequestAttachments.SSL_SESSION_ID, sslSessionInfo.getSessionId());
            }
            if (this.rewriteHostHeader) {
                InetSocketAddress targetAddress = this.clientConnection.getConnection().getPeerAddress(InetSocketAddress.class);
                request.getRequestHeaders().put(Headers.HOST, targetAddress.getHostString() + ":" + targetAddress.getPort());
                request.getRequestHeaders().put(Headers.X_FORWARDED_HOST, this.exchange.getRequestHeaders().getFirst(Headers.HOST));
            }
            if (log.isDebugEnabled()) {
                log.debugf("Sending request %s to target %s for exchange %s", (Object)request, (Object)this.clientConnection.getConnection().getPeerAddress(), (Object)this.exchange);
            }
            if (!(request.getRequestHeaders().contains(Headers.TRANSFER_ENCODING) || request.getRequestHeaders().contains(Headers.CONTENT_LENGTH) || this.exchange.isRequestComplete())) {
                request.getRequestHeaders().put(Headers.TRANSFER_ENCODING, Headers.CHUNKED.toString());
            }
            this.clientConnection.getConnection().sendRequest(request, new ClientCallback<ClientExchange>(){

                @Override
                public void completed(final ClientExchange result) {
                    if (log.isDebugEnabled()) {
                        log.debugf("Sent request %s to target %s for exchange %s", (Object)request, (Object)remoteHost, (Object)ProxyAction.this.exchange);
                    }
                    result.putAttachment(EXCHANGE, ProxyAction.this.exchange);
                    boolean requiresContinueResponse = HttpContinue.requiresContinueResponse(ProxyAction.this.exchange);
                    if (requiresContinueResponse) {
                        result.setContinueHandler(new ContinueNotification(){

                            @Override
                            public void handleContinue(ClientExchange clientExchange) {
                                if (log.isDebugEnabled()) {
                                    log.debugf("Received continue response to request %s to target %s for exchange %s", (Object)request, (Object)ProxyAction.this.clientConnection.getConnection().getPeerAddress(), (Object)ProxyAction.this.exchange);
                                }
                                HttpContinue.sendContinueResponse(ProxyAction.this.exchange, new IoCallback(){

                                    @Override
                                    public void onComplete(HttpServerExchange exchange, Sender sender) {
                                    }

                                    @Override
                                    public void onException(HttpServerExchange exchange, Sender sender, IOException exception) {
                                        IoUtils.safeClose((Closeable)ProxyAction.this.clientConnection.getConnection());
                                        exchange.endExchange();
                                        UndertowLogger.REQUEST_IO_LOGGER.ioException(exception);
                                    }
                                });
                            }
                        });
                    }
                    if (ProxyAction.this.exchange.getConnection().isPushSupported() && result.getConnection().isPushSupported()) {
                        result.setPushHandler(new PushCallback(){

                            @Override
                            public boolean handlePush(ClientExchange originalRequest, final ClientExchange pushedRequest) {
                                if (log.isDebugEnabled()) {
                                    log.debugf("Sending push request %s received from %s to target %s for exchange %s", pushedRequest.getRequest(), request, remoteHost, ProxyAction.this.exchange);
                                }
                                final ClientRequest request = pushedRequest.getRequest();
                                ProxyAction.this.exchange.getConnection().pushResource(request.getPath(), request.getMethod(), request.getRequestHeaders(), new HttpHandler(){

                                    @Override
                                    public void handleRequest(HttpServerExchange exchange) throws Exception {
                                        String path = request.getPath();
                                        int i = path.indexOf("?");
                                        if (i > 0) {
                                            path = path.substring(0, i);
                                        }
                                        exchange.dispatch(SameThreadExecutor.INSTANCE, new ProxyAction(new ProxyConnection(pushedRequest.getConnection(), path), exchange, ProxyAction.this.requestHeaders, ProxyAction.this.rewriteHostHeader, ProxyAction.this.reuseXForwarded, null, ProxyAction.this.idempotentPredicate));
                                    }
                                });
                                return true;
                            }
                        });
                    }
                    result.setResponseListener(new ResponseCallback(ProxyAction.this.exchange, ProxyAction.this.proxyClientHandler, ProxyAction.this.idempotentPredicate));
                    final IoExceptionHandler handler = new IoExceptionHandler(ProxyAction.this.exchange, ProxyAction.this.clientConnection.getConnection());
                    if (requiresContinueResponse) {
                        try {
                            if (!result.getRequestChannel().flush()) {
                                result.getRequestChannel().getWriteSetter().set(ChannelListeners.flushingChannelListener(new ChannelListener<StreamSinkChannel>(){

                                    @Override
                                    public void handleEvent(StreamSinkChannel channel) {
                                        Transfer.initiateTransfer(ProxyAction.this.exchange.getRequestChannel(), result.getRequestChannel(), ChannelListeners.closingChannelListener(), new HTTPTrailerChannelListener(ProxyAction.this.exchange, result, ProxyAction.this.exchange, ProxyAction.this.proxyClientHandler, ProxyAction.this.idempotentPredicate), handler, handler, ProxyAction.this.exchange.getConnection().getByteBufferPool());
                                    }
                                }, handler));
                                result.getRequestChannel().resumeWrites();
                                return;
                            }
                        }
                        catch (IOException e) {
                            handler.handleException(result.getRequestChannel(), e);
                        }
                    }
                    HTTPTrailerChannelListener trailerListener = new HTTPTrailerChannelListener(ProxyAction.this.exchange, result, ProxyAction.this.exchange, ProxyAction.this.proxyClientHandler, ProxyAction.this.idempotentPredicate);
                    if (!ProxyAction.this.exchange.isRequestComplete()) {
                        Transfer.initiateTransfer(ProxyAction.this.exchange.getRequestChannel(), result.getRequestChannel(), ChannelListeners.closingChannelListener(), trailerListener, handler, handler, ProxyAction.this.exchange.getConnection().getByteBufferPool());
                    } else {
                        trailerListener.handleEvent(result.getRequestChannel());
                    }
                }

                @Override
                public void failed(IOException e) {
                    ProxyHandler.handleFailure(ProxyAction.this.exchange, ProxyAction.this.proxyClientHandler, ProxyAction.this.idempotentPredicate, e);
                }
            });
        }
    }

    private final class ProxyClientHandler
    implements ProxyCallback<ProxyConnection>,
    Runnable {
        private int tries;
        private final long timeout;
        private final int maxRetryAttempts;
        private final HttpServerExchange exchange;
        private final Predicate idempotentPredicate;
        private ProxyClient.ProxyTarget target;

        ProxyClientHandler(HttpServerExchange exchange, ProxyClient.ProxyTarget target, long timeout, int maxRetryAttempts, Predicate idempotentPredicate) {
            this.exchange = exchange;
            this.timeout = timeout;
            this.maxRetryAttempts = maxRetryAttempts;
            this.target = target;
            this.idempotentPredicate = idempotentPredicate;
        }

        @Override
        public void run() {
            ProxyHandler.this.proxyClient.getConnection(this.target, this.exchange, this, -1L, TimeUnit.MILLISECONDS);
        }

        @Override
        public void completed(HttpServerExchange exchange, ProxyConnection connection) {
            exchange.putAttachment(CONNECTION, connection);
            exchange.dispatch(SameThreadExecutor.INSTANCE, new ProxyAction(connection, exchange, ProxyHandler.this.requestHeaders, ProxyHandler.this.rewriteHostHeader, ProxyHandler.this.reuseXForwarded, exchange.isRequestComplete() ? this : null, this.idempotentPredicate));
        }

        @Override
        public void failed(HttpServerExchange exchange) {
            long time = System.currentTimeMillis();
            if (this.tries++ < this.maxRetryAttempts) {
                if (this.timeout > 0L && time > this.timeout) {
                    this.cancel(exchange);
                } else {
                    this.target = ProxyHandler.this.proxyClient.findTarget(exchange);
                    if (this.target != null) {
                        long remaining = this.timeout > 0L ? this.timeout - time : -1L;
                        ProxyHandler.this.proxyClient.getConnection(this.target, exchange, this, remaining, TimeUnit.MILLISECONDS);
                    } else {
                        this.couldNotResolveBackend(exchange);
                    }
                }
            } else {
                this.couldNotResolveBackend(exchange);
            }
        }

        @Override
        public void queuedRequestFailed(HttpServerExchange exchange) {
            this.failed(exchange);
        }

        @Override
        public void couldNotResolveBackend(HttpServerExchange exchange) {
            if (exchange.isResponseStarted()) {
                IoUtils.safeClose((Closeable)exchange.getConnection());
            } else {
                exchange.setStatusCode(503);
                exchange.endExchange();
            }
        }

        void cancel(HttpServerExchange exchange) {
            ProxyConnection connectionAttachment = (ProxyConnection)exchange.getAttachment(CONNECTION);
            if (connectionAttachment != null) {
                ClientConnection clientConnection = connectionAttachment.getConnection();
                UndertowLogger.PROXY_REQUEST_LOGGER.timingOutRequest(clientConnection.getPeerAddress() + "" + exchange.getRequestURI());
                IoUtils.safeClose((Closeable)clientConnection);
            } else {
                UndertowLogger.PROXY_REQUEST_LOGGER.timingOutRequest(exchange.getRequestURI());
            }
            if (exchange.isResponseStarted()) {
                IoUtils.safeClose((Closeable)exchange.getConnection());
            } else {
                exchange.setStatusCode(503);
                exchange.endExchange();
            }
        }
    }
}

