/*
 * Decompiled with CFR 0.152.
 */
package org.spincast.plugins.jacksonjson;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.core.util.DefaultIndenter;
import com.fasterxml.jackson.core.util.DefaultPrettyPrinter;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Provider;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spincast.core.config.SpincastConfig;
import org.spincast.core.json.JsonArray;
import org.spincast.core.json.JsonManager;
import org.spincast.core.json.JsonObject;
import org.spincast.core.json.JsonObjectFactory;
import org.spincast.core.json.JsonObjectOrArray;
import org.spincast.core.json.JsonPathUtils;
import org.spincast.core.request.Form;
import org.spincast.core.request.FormFactory;
import org.spincast.core.utils.SpincastStatics;
import org.spincast.core.utils.SpincastUtils;
import org.spincast.plugins.jacksonjson.JsonMixinInfo;
import org.spincast.plugins.jacksonjson.SpincastJsonManagerConfig;
import org.spincast.shaded.org.apache.commons.lang3.StringUtils;

public class SpincastJsonManager
implements JsonManager {
    protected final Logger logger = LoggerFactory.getLogger(SpincastJsonManager.class);
    public static final String ENUM_SERIALIZER_FIELD_NAME_NAME = "name";
    public static final String ENUM_SERIALIZER_FIELD_NAME_LABEL = "label";
    private final JsonObjectFactory jsonObjectFactory;
    private final Provider<Injector> guiceProvider;
    private final Set<JsonMixinInfo> jsonMixinInfos;
    private final SpincastConfig spincastConfig;
    private final SpincastJsonManagerConfig spincastJsonManagerConfig;
    private final JsonPathUtils jsonPathUtils;
    private final SpincastUtils spincastUtils;
    private final FormFactory formFactory;
    private ObjectMapper objectMapper;
    private JsonSerializer<JsonObject> jsonObjectSerializer;
    private JsonDeserializer<JsonObject> jsonObjectDeserializer;
    private JsonSerializer<JsonArray> jsonArraySerializer;
    private JsonDeserializer<JsonArray> jsonArrayDeserializer;
    private JsonSerializer<Date> dateSerializer;
    private JsonSerializer<BigDecimal> bigDecimalSerializer;
    private DefaultPrettyPrinter jacksonPrettyPrinter;
    private JsonSerializer<Enum<?>> enumSerializer;

    @Inject
    public SpincastJsonManager(Provider<Injector> guiceProvider, JsonObjectFactory jsonObjectFactory, @Nullable Set<JsonMixinInfo> jsonMixinInfos, SpincastJsonManagerConfig spincastJsonManagerConfig, SpincastConfig spincastConfig, JsonPathUtils jsonPathUtils, SpincastUtils spincastUtils, FormFactory formFactory) {
        this.guiceProvider = guiceProvider;
        this.jsonObjectFactory = jsonObjectFactory;
        if (jsonMixinInfos == null) {
            jsonMixinInfos = new HashSet<JsonMixinInfo>();
        }
        this.jsonMixinInfos = jsonMixinInfos;
        this.spincastJsonManagerConfig = spincastJsonManagerConfig;
        this.spincastConfig = spincastConfig;
        this.jsonPathUtils = jsonPathUtils;
        this.spincastUtils = spincastUtils;
        this.formFactory = formFactory;
    }

    protected Injector getGuice() {
        return this.guiceProvider.get();
    }

    protected JsonObjectFactory getJsonObjectFactory() {
        return this.jsonObjectFactory;
    }

    protected Set<JsonMixinInfo> getJsonMixinInfos() {
        return this.jsonMixinInfos;
    }

    protected SpincastJsonManagerConfig getSpincastJsonManagerConfig() {
        return this.spincastJsonManagerConfig;
    }

    protected SpincastConfig getSpincastConfig() {
        return this.spincastConfig;
    }

    protected JsonPathUtils getJsonPathUtils() {
        return this.jsonPathUtils;
    }

    protected SpincastUtils getSpincastUtils() {
        return this.spincastUtils;
    }

    protected FormFactory getFormFactory() {
        return this.formFactory;
    }

    protected DefaultPrettyPrinter getJacksonPrettyPrinter() {
        if (this.jacksonPrettyPrinter == null) {
            this.jacksonPrettyPrinter = new DefaultPrettyPrinter();
            DefaultIndenter indenter = new DefaultIndenter(this.getJacksonPrettyPrinterIndentation(), this.getJacksonPrettyPrinterNewline());
            this.jacksonPrettyPrinter.indentObjectsWith(indenter);
            this.jacksonPrettyPrinter.indentArraysWith(indenter);
        }
        return this.jacksonPrettyPrinter;
    }

    protected String getJacksonPrettyPrinterNewline() {
        return this.getSpincastJsonManagerConfig().getPrettyPrinterNewlineChars();
    }

    protected String getJacksonPrettyPrinterIndentation() {
        return StringUtils.repeat(" ", this.getSpincastJsonManagerConfig().getPrettyPrinterIndentationSpaceNumber());
    }

    protected ObjectMapper getObjectMapper() {
        if (this.objectMapper == null) {
            ObjectMapper objectMapper = this.createObjectManager();
            this.registerCustomModules(objectMapper);
            this.objectMapper = objectMapper;
        }
        return this.objectMapper;
    }

    protected ObjectMapper createObjectManager() {
        ObjectMapper objectMapper = new ObjectMapper();
        this.configureObjectMapper(objectMapper);
        return objectMapper;
    }

    protected void configureObjectMapper(ObjectMapper objectMapper) {
        objectMapper.configure(JsonParser.Feature.ALLOW_COMMENTS, this.isAllowCommentsInJson());
        this.configureEmptyBeans(objectMapper);
        this.configureMixins(objectMapper);
    }

    protected boolean isAllowCommentsInJson() {
        return true;
    }

    protected void configureEmptyBeans(ObjectMapper objectMapper) {
        objectMapper.disable(SerializationFeature.FAIL_ON_EMPTY_BEANS);
    }

    protected void configureMixins(ObjectMapper objectMapper) {
        for (JsonMixinInfo jsonMixinInfo : this.getJsonMixinInfos()) {
            objectMapper.addMixIn(jsonMixinInfo.getTargetClass(), jsonMixinInfo.getMixinClass());
        }
    }

    protected JsonSerializer<JsonObject> getJsonObjectSerializer() {
        if (this.jsonObjectSerializer == null) {
            this.jsonObjectSerializer = new JsonSerializer<JsonObject>(){

                @Override
                public void serialize(JsonObject jsonObject, JsonGenerator gen, SerializerProvider serializers) throws IOException, JsonProcessingException {
                    if (jsonObject == null) {
                        return;
                    }
                    Map<String, Object> asMap = jsonObject.convertToPlainMap();
                    gen.writeObject(asMap);
                }
            };
        }
        return this.jsonObjectSerializer;
    }

    protected JsonSerializer<Enum<?>> getEnumSerializer() {
        if (this.enumSerializer == null) {
            this.enumSerializer = new JsonSerializer<Enum<?>>(){

                @Override
                public void serialize(Enum<?> enumValue, JsonGenerator gen, SerializerProvider serializers) throws IOException, JsonProcessingException {
                    if (enumValue == null) {
                        return;
                    }
                    HashMap<String, String> enumObj = new HashMap<String, String>();
                    enumObj.put(SpincastJsonManager.ENUM_SERIALIZER_FIELD_NAME_NAME, enumValue.name());
                    enumObj.put(SpincastJsonManager.ENUM_SERIALIZER_FIELD_NAME_LABEL, enumValue.toString());
                    gen.writeObject(enumObj);
                }
            };
        }
        return this.enumSerializer;
    }

    protected JsonSerializer<JsonArray> getJsonArraySerializer() {
        if (this.jsonArraySerializer == null) {
            this.jsonArraySerializer = new JsonSerializer<JsonArray>(){

                @Override
                public void serialize(JsonArray jsonArray, JsonGenerator gen, SerializerProvider serializers) throws IOException, JsonProcessingException {
                    if (jsonArray == null) {
                        return;
                    }
                    List<Object> asList = jsonArray.convertToPlainList();
                    gen.writeObject(asList);
                }
            };
        }
        return this.jsonArraySerializer;
    }

    protected JsonSerializer<Date> getDateSerializer() {
        if (this.dateSerializer == null) {
            this.dateSerializer = new JsonSerializer<Date>(){

                @Override
                public void serialize(Date date, JsonGenerator gen, SerializerProvider serializers) throws IOException, JsonProcessingException {
                    if (date == null) {
                        return;
                    }
                    String dateStr = SpincastStatics.getIso8601DateParserDefault().format(date);
                    gen.writeObject(dateStr);
                }
            };
        }
        return this.dateSerializer;
    }

    protected JsonSerializer<BigDecimal> getBigDecimalSerializer() {
        if (this.bigDecimalSerializer == null) {
            this.bigDecimalSerializer = new JsonSerializer<BigDecimal>(){

                @Override
                public void serialize(BigDecimal bigDecimal, JsonGenerator gen, SerializerProvider serializers) throws IOException, JsonProcessingException {
                    if (bigDecimal == null) {
                        return;
                    }
                    gen.writeObject(bigDecimal.toPlainString());
                }
            };
        }
        return this.bigDecimalSerializer;
    }

    protected JsonDeserializer<JsonObject> getJsonObjectDeserializer() {
        if (this.jsonObjectDeserializer == null) {
            this.jsonObjectDeserializer = new JsonDeserializer<JsonObject>(){

                @Override
                public JsonObject deserialize(JsonParser jsonParser, DeserializationContext context) throws IOException, JsonProcessingException {
                    JsonObject jsonObject = SpincastJsonManager.this.getJsonObjectFactory().create();
                    JsonToken jsonToken = jsonParser.getCurrentToken();
                    if (jsonToken == JsonToken.START_OBJECT) {
                        jsonToken = jsonParser.nextToken();
                    } else {
                        throw new RuntimeException("Invalid json object");
                    }
                    while (jsonToken != null && jsonToken == JsonToken.FIELD_NAME) {
                        String name = jsonParser.getCurrentName();
                        jsonToken = jsonParser.nextToken();
                        if (jsonToken == JsonToken.START_OBJECT) {
                            jsonObject.put(name, this.deserialize(jsonParser, context));
                        } else if (jsonToken == JsonToken.START_ARRAY) {
                            jsonObject.put(name, SpincastJsonManager.this.getJsonArrayDeserializer().deserialize(jsonParser, context));
                        } else if (jsonToken == JsonToken.VALUE_EMBEDDED_OBJECT) {
                            jsonObject.put(name, jsonParser.getEmbeddedObject());
                        } else if (jsonToken == JsonToken.VALUE_NULL) {
                            jsonObject.put(name, null);
                        } else if (jsonToken == JsonToken.VALUE_STRING) {
                            jsonObject.put(name, jsonParser.getText());
                        } else if (jsonToken == JsonToken.VALUE_TRUE) {
                            jsonObject.put(name, true);
                        } else if (jsonToken == JsonToken.VALUE_FALSE) {
                            jsonObject.put(name, false);
                        } else if (jsonToken == JsonToken.VALUE_NUMBER_INT || jsonToken == JsonToken.VALUE_NUMBER_FLOAT) {
                            jsonObject.put(name, jsonParser.getNumberValue());
                        } else {
                            throw new RuntimeException("Unmanaged json token type : " + (Object)((Object)jsonToken));
                        }
                        jsonToken = jsonParser.nextToken();
                    }
                    return jsonObject;
                }
            };
        }
        return this.jsonObjectDeserializer;
    }

    protected JsonDeserializer<JsonArray> getJsonArrayDeserializer() {
        if (this.jsonArrayDeserializer == null) {
            this.jsonArrayDeserializer = new JsonDeserializer<JsonArray>(){

                @Override
                public JsonArray deserialize(JsonParser jsonParser, DeserializationContext context) throws IOException, JsonProcessingException {
                    JsonArray jsonArray = SpincastJsonManager.this.getJsonObjectFactory().createArray();
                    JsonToken jsonToken = jsonParser.getCurrentToken();
                    if (jsonToken == JsonToken.START_ARRAY) {
                        jsonToken = jsonParser.nextToken();
                    } else {
                        throw new RuntimeException("Invalid json array");
                    }
                    while (jsonToken != null && jsonToken != JsonToken.END_ARRAY) {
                        if (jsonToken == JsonToken.START_OBJECT) {
                            jsonArray.add(SpincastJsonManager.this.getJsonObjectDeserializer().deserialize(jsonParser, context));
                        } else if (jsonToken == JsonToken.START_ARRAY) {
                            jsonArray.add(this.deserialize(jsonParser, context));
                        } else if (jsonToken == JsonToken.VALUE_EMBEDDED_OBJECT) {
                            jsonArray.add(jsonParser.getEmbeddedObject());
                        } else if (jsonToken == JsonToken.VALUE_NULL) {
                            jsonArray.add(null);
                        } else if (jsonToken == JsonToken.VALUE_STRING) {
                            jsonArray.add(jsonParser.getText());
                        } else if (jsonToken == JsonToken.VALUE_TRUE) {
                            jsonArray.add(true);
                        } else if (jsonToken == JsonToken.VALUE_FALSE) {
                            jsonArray.add(false);
                        } else if (jsonToken == JsonToken.VALUE_NUMBER_INT || jsonToken == JsonToken.VALUE_NUMBER_FLOAT) {
                            jsonArray.add(jsonParser.getNumberValue());
                        } else {
                            throw new RuntimeException("Unmanaged json token type : " + (Object)((Object)jsonToken));
                        }
                        jsonToken = jsonParser.nextToken();
                    }
                    return jsonArray;
                }
            };
        }
        return this.jsonArrayDeserializer;
    }

    protected void registerCustomModules(ObjectMapper objectMapper) {
        this.registerJsonObjectModule(objectMapper);
        this.registerCustomTypeSerializerModule(objectMapper);
    }

    protected void registerJsonObjectModule(ObjectMapper objectMapper) {
        SimpleModule module = new SimpleModule();
        module.addSerializer(JsonObject.class, this.getJsonObjectSerializer());
        module.addDeserializer(JsonObject.class, this.getJsonObjectDeserializer());
        module.addSerializer(JsonArray.class, this.getJsonArraySerializer());
        module.addDeserializer(JsonArray.class, this.getJsonArrayDeserializer());
        if (this.getSpincastJsonManagerConfig().isSerializeEnumsToNameAndLabelObjects()) {
            module.addSerializer(Enum.class, this.getEnumSerializer());
        }
        objectMapper.registerModule(module);
    }

    protected void registerCustomTypeSerializerModule(ObjectMapper objectMapper) {
        SimpleModule module = new SimpleModule();
        module.addSerializer(Date.class, this.getDateSerializer());
        module.addSerializer(BigDecimal.class, this.getBigDecimalSerializer());
        objectMapper.registerModule(module);
    }

    @Override
    public String toJsonString(Object obj) {
        return this.toJsonString(obj, false);
    }

    @Override
    public String toJsonString(Object obj, boolean pretty) {
        try {
            if (pretty) {
                return this.getObjectMapper().writer(this.getJacksonPrettyPrinter()).writeValueAsString(obj);
            }
            return this.getObjectMapper().writeValueAsString(obj);
        }
        catch (Exception ex) {
            throw SpincastStatics.runtimize(ex);
        }
    }

    protected void injectDependencies(Object obj) {
        if (obj != null) {
            this.getGuice().injectMembers(obj);
        }
    }

    @Override
    public <T> T fromString(String jsonString, Class<T> clazz) {
        try {
            T jsonObj = this.getObjectMapper().readValue(jsonString, clazz);
            this.injectDependencies(jsonObj);
            return jsonObj;
        }
        catch (Exception ex) {
            throw SpincastStatics.runtimize(ex);
        }
    }

    @Override
    public <T> T fromInputStream(InputStream inputStream, Class<T> clazz) {
        try {
            T jsonObj = this.getObjectMapper().readValue(inputStream, clazz);
            this.injectDependencies(jsonObj);
            return jsonObj;
        }
        catch (Exception ex) {
            throw SpincastStatics.runtimize(ex);
        }
    }

    @Override
    public Map<String, Object> fromStringToMap(String jsonString) {
        try {
            Map map = (Map)this.getObjectMapper().readValue(jsonString, (TypeReference)new TypeReference<Map<String, Object>>(){});
            return map;
        }
        catch (Exception ex) {
            throw SpincastStatics.runtimize(ex);
        }
    }

    @Override
    public Map<String, Object> fromInputStreamToMap(InputStream inputStream) {
        try {
            Map map = (Map)this.getObjectMapper().readValue(inputStream, (TypeReference)new TypeReference<Map<String, Object>>(){});
            return map;
        }
        catch (Exception ex) {
            throw SpincastStatics.runtimize(ex);
        }
    }

    @Override
    public JsonObject create() {
        return this.getJsonObjectFactory().create();
    }

    @Override
    public JsonObject fromString(String jsonString) {
        try {
            JsonObject obj = this.getObjectMapper().readValue(jsonString, JsonObject.class);
            return obj;
        }
        catch (Exception ex) {
            throw SpincastStatics.runtimize(ex);
        }
    }

    @Override
    public JsonObject fromMap(Map<String, ?> params) {
        return this.fromMap(params, false);
    }

    @Override
    public JsonObject fromMap(Map<String, ?> params, boolean parseKeysAsJsonPaths) {
        JsonObject root = this.getJsonObjectFactory().create();
        if (params == null || params.size() == 0) {
            return root;
        }
        if (parseKeysAsJsonPaths && params.size() > this.getMaxNumberOfKeysWhenConvertingMapToJsonObject()) {
            throw new RuntimeException("Too many keys to parse : " + params.size() + " as JsonPaths. The maximum is currently set to " + this.getMaxNumberOfKeysWhenConvertingMapToJsonObject());
        }
        for (Map.Entry<String, ?> entry : params.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            if (parseKeysAsJsonPaths) {
                this.putElementAtJsonPath(root, key, value, true);
                continue;
            }
            root.putNoKeyParsing(key, value);
        }
        return root;
    }

    protected int getMaxNumberOfKeysWhenConvertingMapToJsonObject() {
        return this.getSpincastConfig().getMaxNumberOfKeysWhenConvertingMapToJsonObject();
    }

    @Override
    public Object getElementAtJsonPath(JsonObject obj, String jsonPath) {
        return this.getJsonPathUtils().getElementAtJsonPath(obj, jsonPath);
    }

    @Override
    public Object getElementAtJsonPath(JsonObject obj, String jsonPath, Object defaultValue) {
        return this.getJsonPathUtils().getElementAtJsonPath(obj, jsonPath, defaultValue);
    }

    @Override
    public Object getElementAtJsonPath(JsonArray array, String jsonPath) {
        return this.getJsonPathUtils().getElementAtJsonPath(array, jsonPath);
    }

    @Override
    public Object getElementAtJsonPath(JsonArray array, String jsonPath, Object defaultValue) {
        return this.getJsonPathUtils().getElementAtJsonPath(array, jsonPath, defaultValue);
    }

    @Override
    public void putElementAtJsonPath(JsonObjectOrArray objOrArray, String jsonPath, Object value) {
        this.putElementAtJsonPath(objOrArray, jsonPath, value, false);
    }

    @Override
    public void putElementAtJsonPath(JsonObjectOrArray objOrArray, String jsonPath, Object value, boolean clone) {
        if (clone) {
            value = this.clone(value);
        }
        this.getJsonPathUtils().putElementAtJsonPath(objOrArray, jsonPath, value);
    }

    @Override
    public JsonObject fromInputStream(InputStream inputStream) {
        try {
            JsonObject obj = this.getObjectMapper().readValue(inputStream, JsonObject.class);
            return obj;
        }
        catch (Exception ex) {
            throw SpincastStatics.runtimize(ex);
        }
    }

    @Override
    public JsonObject fromFile(File jsonFile) {
        try {
            JsonObject obj = this.getObjectMapper().readValue(jsonFile, JsonObject.class);
            return obj;
        }
        catch (Exception ex) {
            throw SpincastStatics.runtimize(ex);
        }
    }

    @Override
    public JsonObject fromFile(String jsonFilePath) {
        File file = new File(jsonFilePath);
        return this.fromFile(file);
    }

    @Override
    public JsonObject fromClasspathFile(String path) {
        String content = this.getSpincastUtils().readClasspathFile(path);
        return this.fromString(content);
    }

    @Override
    public JsonArray createArray() {
        return this.getJsonObjectFactory().createArray();
    }

    @Override
    public JsonArray fromStringArray(String jsonString) {
        try {
            JsonArray obj = this.getObjectMapper().readValue(jsonString, JsonArray.class);
            return obj;
        }
        catch (Exception ex) {
            throw SpincastStatics.runtimize(ex);
        }
    }

    @Override
    public JsonArray fromListArray(List<?> elements) {
        JsonArray array = this.createArray();
        if (elements != null) {
            for (Object element : elements) {
                array.add(element);
            }
        }
        return array;
    }

    @Override
    public JsonArray fromInputStreamArray(InputStream inputStream) {
        try {
            JsonArray obj = this.getObjectMapper().readValue(inputStream, JsonArray.class);
            return obj;
        }
        catch (Exception ex) {
            throw SpincastStatics.runtimize(ex);
        }
    }

    @Override
    public Form createForm(String formName) {
        return this.getFormFactory().createForm(formName, null);
    }

    @Override
    public String convertToJsonDate(Date date) {
        return SpincastStatics.getIso8601DateParserDefault().format(date);
    }

    @Override
    public Date parseDateFromJson(String str) {
        return SpincastStatics.parseISO8601date(str);
    }

    @Override
    public Object convertToNativeType(Object originalObject) {
        if (originalObject == null) {
            return null;
        }
        if (originalObject instanceof String || originalObject instanceof Integer || originalObject instanceof Long || originalObject instanceof Float || originalObject instanceof Double || originalObject instanceof Boolean || originalObject instanceof BigDecimal || originalObject instanceof byte[] || originalObject instanceof Date || originalObject instanceof JsonObject || originalObject instanceof JsonArray) {
            return originalObject;
        }
        if (originalObject instanceof Collection) {
            JsonArray array = this.createArray();
            for (Object element : (Collection)originalObject) {
                array.add(element);
            }
            return array;
        }
        if (originalObject instanceof Object[]) {
            JsonArray array = this.createArray();
            for (Object element : (Object[])originalObject) {
                array.add(element);
            }
            return array;
        }
        if (originalObject instanceof Map) {
            JsonObject obj = this.create();
            Map map = (Map)originalObject;
            for (Map.Entry entry : map.entrySet()) {
                if (entry.getKey() == null) {
                    throw new RuntimeException("Cannot convert a Map to a JsonObject when a key is NULL.");
                }
                obj.putNoKeyParsing(String.valueOf(entry.getKey()), entry.getValue());
            }
            return obj;
        }
        if (originalObject instanceof Enum) {
            return ((Enum)originalObject).name();
        }
        String jsonStr = this.toJsonString(originalObject);
        JsonObject jsonObject = this.fromString(jsonStr);
        return jsonObject;
    }

    @Override
    public JsonObject cloneJsonObject(JsonObject jsonObject, boolean mutable) {
        return (JsonObject)this.clone(jsonObject, mutable);
    }

    @Override
    public JsonArray cloneJsonArray(JsonArray jsonArray, boolean mutable) {
        return (JsonArray)this.clone(jsonArray, mutable);
    }

    @Override
    public Object clone(Object originalObject) {
        return this.clone(originalObject, true);
    }

    @Override
    public Object clone(Object originalObject, boolean mutable) {
        if (originalObject == null) {
            return null;
        }
        if (originalObject instanceof String || originalObject instanceof Integer || originalObject instanceof Long || originalObject instanceof Float || originalObject instanceof Double || originalObject instanceof Boolean || originalObject instanceof BigDecimal || originalObject instanceof byte[] || originalObject instanceof Date) {
            return originalObject;
        }
        if (originalObject instanceof JsonObject) {
            JsonObject jsonObj = (JsonObject)originalObject;
            if (!mutable && !jsonObj.isMutable()) {
                return jsonObj;
            }
            HashMap<String, Object> map = new HashMap<String, Object>();
            for (Map.Entry entry : jsonObj) {
                Object elementClone = this.clone(entry.getValue(), mutable);
                map.put((String)entry.getKey(), elementClone);
            }
            return this.getJsonObjectFactory().create(map, mutable);
        }
        if (originalObject instanceof JsonArray) {
            JsonArray array = (JsonArray)originalObject;
            if (!mutable && !array.isMutable()) {
                return array;
            }
            ArrayList<Object> elements = new ArrayList<Object>();
            for (Object element : array) {
                Object elementClone = this.clone(element, mutable);
                elements.add(elementClone);
            }
            return this.getJsonObjectFactory().createArray(elements, mutable);
        }
        return this.convertToNativeType(originalObject);
    }

    @Override
    public void removeElementAtJsonPath(JsonObject obj, String jsonPath) {
        this.getJsonPathUtils().removeElementAtJsonPath(obj, jsonPath);
    }

    @Override
    public void removeElementAtJsonPath(JsonArray array, String jsonPath) {
        this.getJsonPathUtils().removeElementAtJsonPath(array, jsonPath);
    }

    @Override
    public boolean isElementExists(JsonObject obj, String jsonPath) {
        return this.getJsonPathUtils().isElementExists(obj, jsonPath);
    }

    @Override
    public boolean isElementExists(JsonArray array, String jsonPath) {
        return this.getJsonPathUtils().isElementExists(array, jsonPath);
    }
}

