/*
 * Decompiled with CFR 0.152.
 */
package org.spincast.core.session;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.spincast.core.session.FlashMessage;
import org.spincast.core.session.FlashMessagesHolder;

public class FlashMessagesHolderDefault
implements FlashMessagesHolder {
    private Cache<String, FlashMessage> flashMessagesCache;

    protected Cache<String, FlashMessage> getCache() {
        if (this.flashMessagesCache == null) {
            this.flashMessagesCache = CacheBuilder.newBuilder().maximumSize(this.getMaxCacheItems()).expireAfterAccess(this.getCacheExpirationInSeconds(), TimeUnit.SECONDS).build();
        }
        return this.flashMessagesCache;
    }

    protected int getMaxCacheItems() {
        return 1000;
    }

    protected int getCacheExpirationInSeconds() {
        return 60;
    }

    @Override
    public String saveFlashMessage(FlashMessage flashMessage) {
        String uuid = UUID.randomUUID().toString();
        this.getCache().put(uuid, flashMessage);
        return uuid;
    }

    @Override
    public FlashMessage getFlashMessage(String uuid, boolean removeIt) {
        if (uuid == null) {
            return null;
        }
        FlashMessage message = this.getCache().getIfPresent(uuid);
        if (removeIt) {
            this.getCache().invalidate(uuid);
        }
        return message;
    }
}

