/*
 * Decompiled with CFR 0.152.
 */
package org.spincast.plugins.dictionary;

import com.google.inject.Module;
import com.google.inject.util.Modules;
import java.util.Set;
import org.spincast.core.dictionary.Dictionary;
import org.spincast.core.guice.GuiceModuleUtils;
import org.spincast.core.guice.SpincastPluginBase;
import org.spincast.plugins.dictionary.SpincastDictionaryPluginModule;

public class SpincastDictionaryPlugin
extends SpincastPluginBase {
    public static final String PLUGIN_ID = SpincastDictionaryPlugin.class.getName();
    private Class<? extends Dictionary> dictionaryImplClass;

    public SpincastDictionaryPlugin() {
    }

    public SpincastDictionaryPlugin(Class<? extends Dictionary> dictionaryImplClass) {
        this.dictionaryImplClass = dictionaryImplClass;
    }

    @Override
    public String getId() {
        return PLUGIN_ID;
    }

    protected Class<? extends Dictionary> getDictionaryImplClass() {
        return this.dictionaryImplClass;
    }

    @Override
    public Module apply(Module module) {
        GuiceModuleUtils guiceModuleUtils;
        Set<Class<Dictionary>> classes;
        Class<? extends Dictionary> dictionaryImplClass = this.getDictionaryImplClass();
        if (dictionaryImplClass == null && (classes = (guiceModuleUtils = new GuiceModuleUtils(module)).getBoundClassesExtending(Dictionary.class)).size() > 0) {
            if (classes.size() > 1) {
                String msg = "More than one custom implementations of " + Dictionary.class.getName() + " has been found. You'll have to pass the implementation to use the constructor of this plugin to remove the ambiguity about which one to use. Bindings found :\n";
                for (Class<Dictionary> clazz : classes) {
                    msg = msg + "- " + clazz.getName() + "\n";
                }
                throw new RuntimeException(msg);
            }
            Class<Dictionary> temp = classes.iterator().next();
            dictionaryImplClass = temp;
        }
        Module pluginModule = this.getPluginModule(dictionaryImplClass);
        this.setContextTypes(pluginModule);
        module = Modules.override(module).with(pluginModule);
        return module;
    }

    protected Module getPluginModule(Class<? extends Dictionary> dictionaryImplClass) {
        return new SpincastDictionaryPluginModule(dictionaryImplClass);
    }
}

