/*
 * Decompiled with CFR 0.152.
 */
package org.spincast.plugins.routing;

import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import org.spincast.core.exchange.RequestContext;
import org.spincast.core.routing.Handler;
import org.spincast.core.routing.HttpMethod;
import org.spincast.core.routing.Route;
import org.spincast.core.routing.RoutingType;

public class RouteDefault<R extends RequestContext<?>>
implements Route<R> {
    private final String id;
    private final String path;
    private final Set<HttpMethod> httpMethods;
    private final Set<String> acceptedContentTypes;
    private final Set<RoutingType> routingTypes;
    private final List<Handler<R>> beforeFilters;
    private final Handler<R> mainHandler;
    private final List<Handler<R>> afterFilters;
    private final int position;
    private final Set<String> filterIdsToSkip;

    @AssistedInject
    public RouteDefault(@Assisted(value="id") @Nullable String id, @Assisted(value="httpMethods") Set<HttpMethod> httpMethods, @Assisted(value="path") String path, @Assisted(value="routingTypes") Set<RoutingType> routingTypes, @Assisted(value="before") @Nullable List<Handler<R>> beforeFilters, @Assisted(value="main") Handler<R> mainHandler, @Assisted(value="after") @Nullable List<Handler<R>> afterFilters, @Assisted(value="position") int position, @Assisted(value="acceptedContentTypes") @Nullable Set<String> acceptedContentTypes, @Assisted(value="filterIdsToSkip") @Nullable Set<String> filterIdsToSkip) {
        this.id = id;
        this.position = position;
        this.httpMethods = httpMethods;
        this.path = path;
        this.routingTypes = routingTypes;
        if (beforeFilters == null) {
            beforeFilters = new ArrayList<Handler<R>>();
        }
        this.beforeFilters = beforeFilters;
        this.mainHandler = mainHandler;
        if (afterFilters == null) {
            afterFilters = new ArrayList<Handler<R>>();
        }
        this.afterFilters = afterFilters;
        if (acceptedContentTypes == null) {
            acceptedContentTypes = new HashSet<String>();
        }
        this.acceptedContentTypes = new HashSet<String>();
        for (String acceptedContentType : acceptedContentTypes) {
            if (acceptedContentType == null) continue;
            this.acceptedContentTypes.add(acceptedContentType.toLowerCase());
        }
        if (filterIdsToSkip == null) {
            filterIdsToSkip = new HashSet<String>();
        }
        this.filterIdsToSkip = filterIdsToSkip;
    }

    @Override
    public Set<HttpMethod> getHttpMethods() {
        return this.httpMethods;
    }

    @Override
    public Set<String> getAcceptedContentTypes() {
        return this.acceptedContentTypes;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public Set<RoutingType> getRoutingTypes() {
        return this.routingTypes;
    }

    @Override
    public List<Handler<R>> getBeforeFilters() {
        return this.beforeFilters;
    }

    @Override
    public Handler<R> getMainHandler() {
        return this.mainHandler;
    }

    @Override
    public List<Handler<R>> getAfterFilters() {
        return this.afterFilters;
    }

    @Override
    public int getPosition() {
        return this.position;
    }

    @Override
    public Set<String> getFilterIdsToSkip() {
        return this.filterIdsToSkip;
    }

    public String toString() {
        return "[" + this.getPosition() + "] " + this.getPath();
    }
}

