/*
 * Decompiled with CFR 0.152.
 */
package org.spincast.testing.core.utils;

import java.io.File;
import java.io.InputStream;
import java.net.ServerSocket;
import java.util.UUID;
import org.spincast.core.exchange.IDefaultRequestContext;
import org.spincast.core.routing.IHandler;
import org.spincast.core.utils.SpincastStatics;
import org.spincast.shaded.org.apache.commons.io.FileUtils;
import org.spincast.shaded.org.apache.commons.io.IOUtils;

public class SpincastTestUtils {
    public static final String TEST_STRING = "\u201b'\u00ef\u0153\ud84c\udfb4\ud840\udc0b\u16a1\u0160\u0161\u00c8\u00c6\u00e6\u00d0\u00f0\ud834\udd58\ud834\udd65\ud834\udd6f\u2019";
    public static final String TEST_STRING_LONG = "\u201b'\u00ef\u0153\ud84c\udfb4\ud840\udc0b\u16a1\u0160\u0161\u00c8\u00c6\u00e6\u00d0\u00f0\ud834\udd58\ud834\udd65\ud834\udd6f\u20190123456789asasdnalfh23uio4y4213ralksfan394u2348902ursdfjsdfj2534tuuegjdfgjdfgdgjmelfj234i2jsdjfsdjgdlkgjdlkfgjdgj9dgh09fgdhfdgksdjfasdfkasdf858656";
    public static final IHandler<IDefaultRequestContext> dummyRouteHandler = new IHandler<IDefaultRequestContext>(){

        @Override
        public void handle(IDefaultRequestContext exchange) {
        }
    };

    protected static InputStream getThisClassFileInputStream() {
        String s = SpincastTestUtils.class.getName();
        int i = s.lastIndexOf(".");
        if (i > -1) {
            s = s.substring(i + 1);
        }
        s = s + ".class";
        return SpincastTestUtils.class.getResourceAsStream(s);
    }

    public static File generateTempClassFile(File writableDir) {
        InputStream fileOriInputStream = null;
        try {
            File dir = new File(writableDir + "/TestUtils");
            fileOriInputStream = SpincastTestUtils.getThisClassFileInputStream();
            File fileTarget = new File(dir.getAbsolutePath() + "/file" + UUID.randomUUID().toString() + ".class");
            FileUtils.copyInputStreamToFile(fileOriInputStream, fileTarget);
            return fileTarget;
        }
        catch (Exception ex) {
            IOUtils.closeQuietly(fileOriInputStream);
            throw SpincastStatics.runtimize(ex);
        }
    }

    public static int findFreePort() {
        int port = -1;
        try {
            try (ServerSocket s = null;){
                s = new ServerSocket(0);
                port = s.getLocalPort();
            }
            return port;
        }
        catch (Exception ex) {
            throw SpincastStatics.runtimize(ex);
        }
    }
}

