/*
 * Decompiled with CFR 0.152.
 */
package com.rometools.rome.feed.impl;

import com.rometools.rome.feed.impl.BeanIntrospector;
import com.rometools.rome.feed.impl.PropertyDescriptor;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ToStringBean
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(ToStringBean.class);
    private static final ThreadLocal<Stack<String[]>> PREFIX_TL = new ThreadLocal();
    private static final Object[] NO_PARAMS = new Object[0];
    private final Class<?> beanClass;
    private final Object obj;

    protected ToStringBean(Class<?> beanClass) {
        this.beanClass = beanClass;
        this.obj = this;
    }

    public ToStringBean(Class<?> beanClass, Object obj) {
        this.beanClass = beanClass;
        this.obj = obj;
    }

    public String toString() {
        String prefix;
        String[] tsInfo;
        Stack<Object> stack = PREFIX_TL.get();
        boolean needStackCleanup = false;
        if (stack == null) {
            stack = new Stack();
            PREFIX_TL.set(stack);
            needStackCleanup = true;
        }
        if ((tsInfo = stack.isEmpty() ? null : (String[])stack.peek()) == null) {
            String className = this.obj.getClass().getName();
            prefix = className.substring(className.lastIndexOf(".") + 1);
        } else {
            tsInfo[1] = prefix = tsInfo[0];
        }
        String result = this.toString(prefix);
        if (needStackCleanup) {
            PREFIX_TL.remove();
        }
        return result;
    }

    private String toString(String prefix) {
        StringBuffer sb = new StringBuffer(128);
        try {
            List<PropertyDescriptor> propertyDescriptors = BeanIntrospector.getPropertyDescriptorsWithGetters(this.beanClass);
            for (PropertyDescriptor propertyDescriptor : propertyDescriptors) {
                String propertyName = propertyDescriptor.getName();
                Method getter = propertyDescriptor.getReadMethod();
                Object value = getter.invoke(this.obj, NO_PARAMS);
                this.printProperty(sb, prefix + "." + propertyName, value);
            }
        }
        catch (Exception e) {
            LOG.error("Error while generating toString", e);
            Class<?> clazz = this.obj.getClass();
            String errorMessage = e.getMessage();
            sb.append(String.format("\n\nEXCEPTION: Could not complete %s.toString(): %s\n", clazz, errorMessage));
        }
        return sb.toString();
    }

    private void printProperty(StringBuffer sb, String prefix, Object value) {
        if (value == null) {
            sb.append(prefix).append("=null\n");
        } else if (value.getClass().isArray()) {
            this.printArrayProperty(sb, prefix, value);
        } else if (value instanceof Map) {
            Map map = (Map)value;
            Set entries = map.entrySet();
            if (entries.isEmpty()) {
                sb.append(prefix).append("=[]\n");
            } else {
                for (Map.Entry entry : entries) {
                    Object eKey = entry.getKey();
                    Object eValue = entry.getValue();
                    String ePrefix = String.format("%s[%s]", prefix, eKey);
                    String[] tsInfo = new String[2];
                    tsInfo[0] = ePrefix;
                    Stack<String[]> stack = PREFIX_TL.get();
                    stack.push(tsInfo);
                    String s2 = eValue == null ? "null" : eValue.toString();
                    stack.pop();
                    if (tsInfo[1] == null) {
                        sb.append(ePrefix).append("=").append(s2).append("\n");
                        continue;
                    }
                    sb.append(s2);
                }
            }
        } else if (value instanceof Collection) {
            Collection collection = (Collection)value;
            if (collection.isEmpty()) {
                sb.append(prefix).append("=[]\n");
            } else {
                int c = 0;
                for (Object cValue : collection) {
                    String cPrefix = String.format("%s[%s]", prefix, c++);
                    String[] tsInfo = new String[2];
                    tsInfo[0] = cPrefix;
                    Stack<String[]> stack = PREFIX_TL.get();
                    stack.push(tsInfo);
                    String s3 = cValue == null ? "null" : cValue.toString();
                    stack.pop();
                    if (tsInfo[1] == null) {
                        sb.append(cPrefix).append("=").append(s3).append("\n");
                        continue;
                    }
                    sb.append(s3);
                }
            }
        } else {
            String[] tsInfo = new String[2];
            tsInfo[0] = prefix;
            Stack<String[]> stack = PREFIX_TL.get();
            stack.push(tsInfo);
            String s4 = value.toString();
            stack.pop();
            if (tsInfo[1] == null) {
                sb.append(prefix).append("=").append(s4).append("\n");
            } else {
                sb.append(s4);
            }
        }
    }

    private void printArrayProperty(StringBuffer sb, String prefix, Object array) {
        int length = Array.getLength(array);
        for (int i = 0; i < length; ++i) {
            Object obj = Array.get(array, i);
            this.printProperty(sb, String.format("%s[%s]", prefix, i), obj);
        }
    }
}

