/*
 * Decompiled with CFR 0.152.
 */
package com.google.inject.throwingproviders;

import com.google.common.base.Optional;
import com.google.inject.TypeLiteral;
import com.google.inject.throwingproviders.CheckedProvider;
import com.google.inject.throwingproviders.ProviderChecker;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;

public final class CheckedProviders {
    private CheckedProviders() {
    }

    private static <T, P extends CheckedProvider<? super T>> P generateProvider(Class<P> providerType, Optional<T> value, InvocationHandler handler) {
        ProviderChecker.checkInterface(providerType, CheckedProviders.getClassOptional(value));
        Object proxy = Proxy.newProxyInstance(providerType.getClassLoader(), new Class[]{providerType}, handler);
        CheckedProvider proxyP = (CheckedProvider)proxy;
        return (P)proxyP;
    }

    private static <T, P extends CheckedProvider<? super T>> P generateProvider(TypeLiteral<P> providerType, Optional<T> value, InvocationHandler handler) {
        Class<P> providerRaw = providerType.getRawType();
        return CheckedProviders.generateProvider(providerRaw, value, handler);
    }

    private static Optional<Class<?>> getClassOptional(Optional<?> value) {
        if (!value.isPresent()) {
            return Optional.absent();
        }
        return Optional.of(value.get().getClass());
    }

    public static <T, P extends CheckedProvider<? super T>> P of(TypeLiteral<P> providerType, @Nullable T instance) {
        return CheckedProviders.generateProvider(providerType, Optional.fromNullable(instance), new ReturningHandler<T>(instance));
    }

    public static <T, P extends CheckedProvider<? super T>> P of(Class<P> providerType, @Nullable T instance) {
        return CheckedProviders.of(TypeLiteral.get(providerType), instance);
    }

    public static <T, P extends CheckedProvider<? super T>> P throwing(TypeLiteral<P> providerType, Class<? extends Throwable> throwable) {
        Class<P> providerRaw = providerType.getRawType();
        CheckedProviders.checkThrowable(providerRaw, throwable);
        return CheckedProviders.generateProvider(providerType, Optional.absent(), (InvocationHandler)ThrowingHandler.forClass(throwable));
    }

    public static <T, P extends CheckedProvider<? super T>> P throwing(Class<P> providerType, Class<? extends Throwable> throwable) {
        return CheckedProviders.throwing(TypeLiteral.get(providerType), throwable);
    }

    private static boolean isCheckedException(Class<? extends Throwable> thrownType) {
        return Exception.class.isAssignableFrom(thrownType) && !RuntimeException.class.isAssignableFrom(thrownType);
    }

    private static void checkThrowable(Class<? extends CheckedProvider<?>> providerType, Class<? extends Throwable> thrownType) {
        Method getMethod;
        try {
            thrownType.getDeclaredConstructor(new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException(String.format("Thrown exception <%s> must have a no-argument constructor", thrownType.getName()), e);
        }
        if (!CheckedProviders.isCheckedException(thrownType)) {
            return;
        }
        try {
            getMethod = providerType.getMethod("get", new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException(String.format("Provider class <%s> must have a get() method", providerType.getName()), e);
        }
        List<Class<?>> exceptionTypes = Arrays.asList(getMethod.getExceptionTypes());
        if (exceptionTypes.size() == 0) {
            return;
        }
        for (Class<? extends Throwable> clazz : exceptionTypes) {
            if (!clazz.isAssignableFrom(thrownType)) continue;
            return;
        }
        throw new IllegalArgumentException(String.format("Thrown exception <%s> is not declared to be thrown by <%s>", thrownType.getName(), getMethod));
    }

    private static final class ThrowingHandler
    extends CheckedProviderInvocationHandler<Object> {
        private final Constructor<? extends Throwable> throwableCtor;
        private final String typeName;

        private ThrowingHandler(Constructor<? extends Throwable> throwableCtor, String typeName) {
            this.throwableCtor = throwableCtor;
            this.typeName = typeName;
            this.throwableCtor.setAccessible(true);
        }

        static ThrowingHandler forClass(Class<? extends Throwable> throwable) {
            try {
                return new ThrowingHandler(throwable.getDeclaredConstructor(new Class[0]), throwable.getName());
            }
            catch (NoSuchMethodException e) {
                throw new AssertionError((Object)String.format("Throwable <%s> does not have a no-argument constructor", throwable.getName()));
            }
        }

        @Override
        protected Object invokeGet(Object proxy, Method method) throws Throwable {
            throw this.throwableCtor.newInstance(new Object[0]);
        }

        @Override
        public String toString() {
            return String.format("generated CheckedProvider throwing <%s>", this.typeName);
        }
    }

    private static final class ReturningHandler<T>
    extends CheckedProviderInvocationHandler<T> {
        private final T returned;

        ReturningHandler(T returned) {
            this.returned = returned;
        }

        @Override
        protected T invokeGet(Object proxy, Method method) throws Throwable {
            return this.returned;
        }

        @Override
        public String toString() {
            return String.format("generated CheckedProvider returning <%s>", this.returned);
        }
    }

    private static abstract class CheckedProviderInvocationHandler<T>
    implements InvocationHandler {
        private CheckedProviderInvocationHandler() {
        }

        private boolean isGetMethod(Method method) {
            return method.getName().equals("get") && method.getParameterTypes().length == 0;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (method.getDeclaringClass() == Object.class) {
                return method.invoke((Object)this, args);
            }
            if (this.isGetMethod(method)) {
                return this.invokeGet(proxy, method);
            }
            throw new UnsupportedOperationException(String.format("Unsupported method <%s> with args <%s> invoked on <%s>", method, Arrays.toString(args), proxy));
        }

        protected abstract T invokeGet(Object var1, Method var2) throws Throwable;

        public abstract String toString();
    }
}

