/*
 * Decompiled with CFR 0.152.
 */
package org.spincast.plugins.undertow;

import com.google.inject.Inject;
import io.undertow.Undertow;
import io.undertow.UndertowOptions;
import io.undertow.io.IoCallback;
import io.undertow.io.Sender;
import io.undertow.security.api.AuthenticationMechanism;
import io.undertow.security.api.AuthenticationMode;
import io.undertow.security.handlers.AuthenticationCallHandler;
import io.undertow.security.handlers.AuthenticationConstraintHandler;
import io.undertow.security.handlers.AuthenticationMechanismsHandler;
import io.undertow.security.handlers.SecurityInitialHandler;
import io.undertow.security.impl.BasicAuthenticationMechanism;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.CookieImpl;
import io.undertow.server.handlers.PathHandler;
import io.undertow.server.handlers.ResponseCodeHandler;
import io.undertow.server.handlers.form.FormData;
import io.undertow.server.handlers.form.FormDataParser;
import io.undertow.server.handlers.form.FormEncodedDataDefinition;
import io.undertow.server.handlers.form.FormParserFactory;
import io.undertow.server.handlers.form.MultiPartParserDefinition;
import io.undertow.server.handlers.resource.ClassPathResourceManager;
import io.undertow.server.handlers.resource.FileResourceManager;
import io.undertow.util.HeaderMap;
import io.undertow.util.HeaderValues;
import io.undertow.util.HttpString;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.BindException;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.ByteBuffer;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import javax.net.ssl.SSLContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spincast.core.config.SpincastConfig;
import org.spincast.core.controllers.FrontController;
import org.spincast.core.cookies.Cookie;
import org.spincast.core.cookies.CookieFactory;
import org.spincast.core.cookies.CookieSameSite;
import org.spincast.core.routing.HttpMethod;
import org.spincast.core.routing.StaticResource;
import org.spincast.core.routing.StaticResourceType;
import org.spincast.core.server.Server;
import org.spincast.core.server.ServerUtils;
import org.spincast.core.server.UploadedFile;
import org.spincast.core.server.UploadedFileDefault;
import org.spincast.core.utils.ContentTypeDefaults;
import org.spincast.core.utils.SpincastStatics;
import org.spincast.core.utils.SpincastUtils;
import org.spincast.core.utils.ssl.SSLContextFactory;
import org.spincast.core.websocket.WebsocketEndpointHandler;
import org.spincast.core.websocket.WebsocketEndpointManager;
import org.spincast.plugins.undertow.CacheBusterRemovalHandler;
import org.spincast.plugins.undertow.CacheBusterRemovalHandlerFactory;
import org.spincast.plugins.undertow.CorsHandler;
import org.spincast.plugins.undertow.CorsHandlerFactory;
import org.spincast.plugins.undertow.FileClassPathResourceManager;
import org.spincast.plugins.undertow.FileClassPathResourceManagerFactory;
import org.spincast.plugins.undertow.FullPathMatchingPathHandler;
import org.spincast.plugins.undertow.GzipCheckerHandler;
import org.spincast.plugins.undertow.GzipCheckerHandlerFactory;
import org.spincast.plugins.undertow.SkipResourceOnQueryStringHandlerFactory;
import org.spincast.plugins.undertow.SpincastHttpAuthIdentityManager;
import org.spincast.plugins.undertow.SpincastHttpAuthIdentityManagerFactory;
import org.spincast.plugins.undertow.SpincastResourceHandler;
import org.spincast.plugins.undertow.SpincastResourceHandlerFactory;
import org.spincast.plugins.undertow.WebsocketEndpoint;
import org.spincast.plugins.undertow.WebsocketEndpointFactory;
import org.spincast.plugins.undertow.config.SpincastUndertowConfig;
import org.spincast.shaded.org.apache.commons.lang3.StringUtils;
import org.spincast.shaded.org.commonjava.mimeparse.MIMEParse;

public class SpincastUndertowServer
implements Server {
    protected final Logger logger = LoggerFactory.getLogger(SpincastUndertowServer.class);
    public static final String UNDERTOW_EXCEPTION_CODE_REQUEST_TOO_LARGE = "UT000020";
    private final WebsocketEndpointFactory spincastWebsocketEndpointFactory;
    private final SpincastUtils spincastUtils;
    private final SpincastConfig config;
    private final SpincastUndertowConfig spincastUndertowConfig;
    private final FrontController frontController;
    private final CookieFactory cookieFactory;
    private final CorsHandlerFactory corsHandlerFactory;
    private final GzipCheckerHandlerFactory gzipCheckerHandlerFactory;
    private final SkipResourceOnQueryStringHandlerFactory skipResourceOnQueryStringHandlerFactory;
    private final SpincastResourceHandlerFactory spincastResourceHandlerFactory;
    private final CacheBusterRemovalHandlerFactory cacheBusterRemovalHandlerFactory;
    private final FileClassPathResourceManagerFactory fileClassPathResourceManagerFactory;
    private final SpincastHttpAuthIdentityManagerFactory spincastHttpAuthIdentityManagerFactory;
    private final SSLContextFactory sslContextFactory;
    private final ServerUtils serverUtils;
    private Undertow undertowServer;
    private IoCallback doNothingCallback = null;
    private IoCallback closeExchangeCallback = null;
    private final Map<String, StaticResource<?>> staticResourcesServedByUrlPath = new HashMap();
    private final Map<String, String> httpAuthActiveRealms = new HashMap<String, String>();
    private final Map<String, SpincastHttpAuthIdentityManager> httpAuthIdentityManagersByRealmName = new HashMap<String, SpincastHttpAuthIdentityManager>();
    private final Map<String, WebsocketEndpoint> websocketEndpointsMap = new ConcurrentHashMap<String, WebsocketEndpoint>();
    private HttpHandler spincastFrontControllerHandler;
    private PathHandler staticResourcesPathHandler;
    private PathHandler httpAuthenticationHandler;
    private CacheBusterRemovalHandler cacheBusterRemovalHandler;
    private FormParserFactory formParserFactory;
    private final Map<String, Object> websocketEndpointCreationLocks = new ConcurrentHashMap<String, Object>();
    private final Object websocketEndpointLockCreationLock = new Object();

    @Inject
    public SpincastUndertowServer(SpincastConfig config, SpincastUndertowConfig spincastUndertowConfig, FrontController frontController, SpincastUtils spincastUtils, CookieFactory cookieFactory, CorsHandlerFactory corsHandlerFactory, GzipCheckerHandlerFactory gzipCheckerHandlerFactory, SkipResourceOnQueryStringHandlerFactory skipResourceOnQueryStringHandlerFactory, SpincastResourceHandlerFactory spincastResourceHandlerFactory, CacheBusterRemovalHandlerFactory cacheBusterRemovalHandlerFactory, FileClassPathResourceManagerFactory fileClassPathResourceManagerFactory, SpincastHttpAuthIdentityManagerFactory spincastHttpAuthIdentityManagerFactory, WebsocketEndpointFactory spincastWebsocketEndpointFactory, SSLContextFactory sslContextFactory, ServerUtils serverUtils) {
        this.config = config;
        this.spincastUndertowConfig = spincastUndertowConfig;
        this.frontController = frontController;
        this.spincastUtils = spincastUtils;
        this.cookieFactory = cookieFactory;
        this.corsHandlerFactory = corsHandlerFactory;
        this.gzipCheckerHandlerFactory = gzipCheckerHandlerFactory;
        this.skipResourceOnQueryStringHandlerFactory = skipResourceOnQueryStringHandlerFactory;
        this.spincastResourceHandlerFactory = spincastResourceHandlerFactory;
        this.cacheBusterRemovalHandlerFactory = cacheBusterRemovalHandlerFactory;
        this.fileClassPathResourceManagerFactory = fileClassPathResourceManagerFactory;
        this.spincastHttpAuthIdentityManagerFactory = spincastHttpAuthIdentityManagerFactory;
        this.spincastWebsocketEndpointFactory = spincastWebsocketEndpointFactory;
        this.sslContextFactory = sslContextFactory;
        this.serverUtils = serverUtils;
    }

    protected SpincastConfig getConfig() {
        return this.config;
    }

    protected SpincastUndertowConfig getSpincastUndertowConfig() {
        return this.spincastUndertowConfig;
    }

    protected FrontController getFrontController() {
        return this.frontController;
    }

    protected SpincastUtils getSpincastUtils() {
        return this.spincastUtils;
    }

    protected CookieFactory getCookieFactory() {
        return this.cookieFactory;
    }

    protected CorsHandlerFactory getCorsHandlerFactory() {
        return this.corsHandlerFactory;
    }

    protected GzipCheckerHandlerFactory getGzipCheckerHandlerFactory() {
        return this.gzipCheckerHandlerFactory;
    }

    protected SkipResourceOnQueryStringHandlerFactory getSkipResourceOnQueryStringHandlerFactory() {
        return this.skipResourceOnQueryStringHandlerFactory;
    }

    protected SpincastResourceHandlerFactory getSpincastResourceHandlerFactory() {
        return this.spincastResourceHandlerFactory;
    }

    protected CacheBusterRemovalHandlerFactory getCacheBusterRemovalHandlerFactory() {
        return this.cacheBusterRemovalHandlerFactory;
    }

    protected FileClassPathResourceManagerFactory getFileClassPathResourceManagerFactory() {
        return this.fileClassPathResourceManagerFactory;
    }

    protected SpincastHttpAuthIdentityManagerFactory getSpincastHttpAuthIdentityManagerFactory() {
        return this.spincastHttpAuthIdentityManagerFactory;
    }

    protected WebsocketEndpointFactory getSpincastWebsocketEndpointFactory() {
        return this.spincastWebsocketEndpointFactory;
    }

    protected Map<String, StaticResource<?>> getStaticResourcesServedByUrlPath() {
        return this.staticResourcesServedByUrlPath;
    }

    protected Map<String, SpincastHttpAuthIdentityManager> getHttpAuthIdentityManagersByRealmName() {
        return this.httpAuthIdentityManagersByRealmName;
    }

    protected Map<String, WebsocketEndpoint> getWebsocketEndpointsMap() {
        return this.websocketEndpointsMap;
    }

    protected Map<String, String> getHttpAuthActiveRealms() {
        return this.httpAuthActiveRealms;
    }

    protected SSLContextFactory getSslContextFactory() {
        return this.sslContextFactory;
    }

    protected ServerUtils getServerUtils() {
        return this.serverUtils;
    }

    @Override
    public Map<String, String> getHttpAuthenticationRealms() {
        return Collections.unmodifiableMap(this.getHttpAuthActiveRealms());
    }

    protected FormParserFactory getFormParserFactory() {
        if (this.formParserFactory == null) {
            FormParserFactory.Builder builder = FormParserFactory.builder(false);
            builder.addParsers(new FormEncodedDataDefinition(), new MultiPartParserDefinition(this.createUndertowTempDir()));
            this.formParserFactory = builder.build();
        }
        return this.formParserFactory;
    }

    protected Path createUndertowTempDir() {
        boolean result;
        File undertowWritableDir = new File(this.getConfig().getTempDir().getAbsolutePath() + "/undertow");
        if (!undertowWritableDir.isDirectory() && !(result = undertowWritableDir.mkdirs())) {
            throw new RuntimeException("Unable to create the Undertow temp dir : " + undertowWritableDir.getAbsolutePath());
        }
        return undertowWritableDir.toPath();
    }

    @Override
    public boolean isRunning() {
        return this.undertowServer != null;
    }

    @Override
    public synchronized void start() {
        if (this.undertowServer != null) {
            this.logger.warn("Server already started.");
            return;
        }
        this.undertowServer = this.getServerBuilder().build();
        int serverStartTryNbr = this.getServerStartTryNbr();
        for (int i = 0; i < serverStartTryNbr; ++i) {
            try {
                this.undertowServer.start();
                break;
            }
            catch (Exception ex) {
                if (ex instanceof BindException || ex.getCause() != null && ex.getCause() instanceof BindException) {
                    this.logger.warn("BindException while trying to start the server. Try " + i + " of " + serverStartTryNbr + "...");
                    if (i < serverStartTryNbr) {
                        try {
                            Thread.sleep(this.getStartServerSleepMilliseconds());
                        }
                        catch (InterruptedException interruptedException) {}
                        continue;
                    }
                }
                this.undertowServer = null;
                throw ex;
            }
        }
        if (this.getConfig().getHttpServerPort() > 0) {
            this.logger.info("HTTP server started on host/ip \"" + this.getConfig().getServerHost() + "\", port " + this.getConfig().getHttpServerPort());
        }
        if (this.getConfig().getHttpsServerPort() > 0) {
            this.logger.info("HTTPS server started on host/ip \"" + this.getConfig().getServerHost() + "\", port " + this.getConfig().getHttpsServerPort());
        }
    }

    protected int getServerStartTryNbr() {
        return 10;
    }

    protected long getStartServerSleepMilliseconds() {
        return 500L;
    }

    protected Undertow.Builder getServerBuilder() {
        try {
            String serverHost = this.getConfig().getServerHost();
            int httpServerPort = this.getConfig().getHttpServerPort();
            int httpsServerPort = this.getConfig().getHttpsServerPort();
            if (httpServerPort <= 0 && httpsServerPort <= 0) {
                throw new RuntimeException("At least one of the HTTP or HTTPS port must be greater than 0 to start the server....");
            }
            Undertow.Builder builder = Undertow.builder().setHandler(this.getFinalHandler());
            if (httpServerPort > 0) {
                this.addHttpListener(builder, serverHost, httpServerPort);
            }
            if (httpsServerPort > 0) {
                this.addHttpsListener(builder, serverHost, httpsServerPort);
            }
            builder = this.addBuilderOptions(builder);
            return builder;
        }
        catch (Exception ex) {
            throw SpincastStatics.runtimize(ex);
        }
    }

    protected void addHttpListener(Undertow.Builder builder, String serverHost, int httpServerPort) {
        builder = builder.addHttpListener(httpServerPort, serverHost);
    }

    protected void addHttpsListener(Undertow.Builder builder, String serverHost, int httpsServerPort) {
        try {
            SSLContext sslContext = this.getSslContextFactory().createSSLContext(this.getConfig().getHttpsKeyStorePath(), this.getConfig().getHttpsKeyStoreType(), this.getConfig().getHttpsKeyStoreStorePass(), this.getConfig().getHttpsKeyStoreKeyPass());
            builder = builder.addHttpsListener(httpsServerPort, serverHost, sslContext);
        }
        catch (Exception ex) {
            throw SpincastStatics.runtimize(ex);
        }
    }

    protected Undertow.Builder addBuilderOptions(Undertow.Builder builder) {
        builder.setServerOption(UndertowOptions.MAX_ENTITY_SIZE, this.getConfig().getServerMaxRequestBodyBytes());
        return builder;
    }

    protected HttpHandler getFinalHandler() {
        return this.getCacheBusterRemovalHandler();
    }

    protected CacheBusterRemovalHandler getCacheBusterRemovalHandler() {
        if (this.cacheBusterRemovalHandler == null) {
            this.cacheBusterRemovalHandler = this.getCacheBusterRemovalHandlerFactory().create(this.getHttpAuthenticationHandler());
        }
        return this.cacheBusterRemovalHandler;
    }

    protected PathHandler getHttpAuthenticationHandler() {
        if (this.httpAuthenticationHandler == null) {
            this.httpAuthenticationHandler = new FullPathMatchingPathHandler(this.getHttpAuthHandlerNextHandler());
        }
        return this.httpAuthenticationHandler;
    }

    protected HttpHandler getHttpAuthHandlerNextHandler() {
        return this.getStaticResourcesPathHandler();
    }

    @Override
    public void createHttpAuthenticationRealm(String pathPrefix, String realmName) {
        if (this.getHttpAuthActiveRealms().containsKey(realmName)) {
            throw new RuntimeException("A HTTP authentication realm named '" + realmName + "' already exists for path: " + pathPrefix);
        }
        SpincastHttpAuthIdentityManager identityManager = this.getOrCreateHttpAuthIdentityManagersByRealmName(realmName);
        HttpHandler handler = new AuthenticationCallHandler(this.getHttpAuthHandlerNextHandler());
        handler = new AuthenticationConstraintHandler(handler);
        List<AuthenticationMechanism> mechanisms = Collections.singletonList(new BasicAuthenticationMechanism(this.getRealmNameToDisplay(pathPrefix, realmName)));
        handler = new AuthenticationMechanismsHandler(handler, mechanisms);
        handler = new SecurityInitialHandler(AuthenticationMode.PRO_ACTIVE, identityManager, handler);
        this.getHttpAuthIdentityManagersByRealmName().put(realmName, identityManager);
        this.getHttpAuthenticationHandler().addPrefixPath(pathPrefix, handler);
        this.getHttpAuthActiveRealms().put(realmName, pathPrefix);
    }

    protected String getRealmNameToDisplay(String pathPrefix, String realmName) {
        return realmName;
    }

    protected SpincastHttpAuthIdentityManager getOrCreateHttpAuthIdentityManagersByRealmName(String realmName) {
        SpincastHttpAuthIdentityManager identityManager = this.getHttpAuthIdentityManagersByRealmName().get(realmName);
        if (identityManager == null) {
            identityManager = this.getSpincastHttpAuthIdentityManagerFactory().create();
            this.getHttpAuthIdentityManagersByRealmName().put(realmName, identityManager);
        }
        return identityManager;
    }

    @Override
    public void addHttpAuthentication(String realmName, String username, String password) {
        SpincastHttpAuthIdentityManager identityManager = this.getOrCreateHttpAuthIdentityManagersByRealmName(realmName);
        identityManager.addUser(username, password);
    }

    @Override
    public void removeHttpAuthentication(String username, String realmName) {
        SpincastHttpAuthIdentityManager identityManager = this.getHttpAuthIdentityManagersByRealmName().get(realmName);
        if (identityManager != null) {
            identityManager.removeUser(username);
        }
    }

    @Override
    public void removeHttpAuthentication(String username) {
        for (SpincastHttpAuthIdentityManager identityManager : this.getHttpAuthIdentityManagersByRealmName().values()) {
            identityManager.removeUser(username);
        }
    }

    protected HttpHandler getSpincastFrontControllerHandler() {
        if (this.spincastFrontControllerHandler == null) {
            this.spincastFrontControllerHandler = new HttpHandler(){

                @Override
                public void handleRequest(HttpServerExchange exchange) throws Exception {
                    if (exchange.isInIoThread()) {
                        exchange.dispatch(this);
                        return;
                    }
                    SpincastUndertowServer.this.getFrontController().handle(exchange);
                }
            };
        }
        return this.spincastFrontControllerHandler;
    }

    @Override
    public void stop() {
        this.stop(true);
    }

    @Override
    public synchronized void stop(boolean sendClosingMessageToPeers) {
        if (this.undertowServer != null) {
            try {
                if (sendClosingMessageToPeers) {
                    this.sendWebsocketEnpointsClosedWhenServerStops();
                }
            }
            finally {
                try {
                    this.undertowServer.stop();
                    this.undertowServer = null;
                }
                catch (Exception ex) {
                    this.logger.error("Error stopping the Undertow server :\n" + SpincastStatics.getStackTrace(ex));
                }
            }
        }
    }

    protected int getSecondsToWaitForWebSocketEndpointsToBeProperlyClosedBeforeKillingTheServer() {
        return this.getSpincastUndertowConfig().getSecondsToWaitForWebSocketEndpointsToBeProperlyClosedBeforeKillingTheServer();
    }

    protected int getMilliSecondsIncrementWhenWaitingForWebSocketEndpointsToBeProperlyClosedBeforeKillingTheServer() {
        return this.getSpincastUndertowConfig().getMilliSecondsIncrementWhenWaitingForWebSocketEndpointsToBeProperlyClosedBeforeKillingTheServer();
    }

    protected void sendWebsocketEnpointsClosedWhenServerStops() {
        Collection<WebsocketEndpoint> websocketEndpointsMap = this.getWebsocketEndpointsMap().values();
        ArrayList<WebsocketEndpoint> websocketEndpoints = new ArrayList<WebsocketEndpoint>(websocketEndpointsMap);
        HashSet<String> unclosedEndpoints = new HashSet<String>(this.getWebsocketEndpointsMap().keySet());
        this.logger.debug("We wait for those endpoints to be finished closing : " + Arrays.toString(unclosedEndpoints.toArray()));
        for (WebsocketEndpoint websocketEndpoint : websocketEndpoints) {
            try {
                websocketEndpoint.closeEndpoint(true);
            }
            catch (Exception ex) {
                this.logger.warn("Error closing Websocket '" + websocketEndpoint.getEndpointId() + "': " + ex.getMessage());
            }
        }
        int millisecondsWaited = 0;
        int millisecondsToWait = 1000 * this.getSecondsToWaitForWebSocketEndpointsToBeProperlyClosedBeforeKillingTheServer();
        int incrementsMilliseconds = this.getMilliSecondsIncrementWhenWaitingForWebSocketEndpointsToBeProperlyClosedBeforeKillingTheServer();
        block9: while (millisecondsWaited < millisecondsToWait) {
            try {
                for (WebsocketEndpoint websocketEndpoint : websocketEndpoints) {
                    try {
                        if (!unclosedEndpoints.contains(websocketEndpoint.getEndpointId()) || !websocketEndpoint.isClosed()) continue;
                        this.logger.debug("Endpoint '" + websocketEndpoint.getEndpointId() + "' finished closing!");
                        unclosedEndpoints.remove(websocketEndpoint.getEndpointId());
                        if (unclosedEndpoints.size() != 0) continue;
                        this.logger.debug("All endpoints finished closing!");
                        break block9;
                    }
                    catch (Exception ex) {
                        this.logger.warn("Error closing Websocket '" + websocketEndpoint.getEndpointId() + "': " + ex.getMessage());
                    }
                }
            }
            catch (Exception ex) {
                this.logger.warn("Error while checking if all endpoints are closed : " + ex.getMessage());
            }
            this.logger.debug("Some endpoints are not finished closing. Remaining : " + Arrays.toString(unclosedEndpoints.toArray()));
            try {
                Thread.sleep(incrementsMilliseconds);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if ((millisecondsWaited += incrementsMilliseconds) < millisecondsToWait) continue;
            this.logger.debug("Some endpoints are still not finished closing, even after waiting for " + millisecondsWaited + " milliseconds. We'll stop the server as is. Remaining : " + Arrays.toString(unclosedEndpoints.toArray()));
        }
    }

    protected PathHandler getStaticResourcesPathHandler() {
        if (this.staticResourcesPathHandler == null) {
            this.staticResourcesPathHandler = new FullPathMatchingPathHandler(this.getSpincastFrontControllerHandler());
        }
        return this.staticResourcesPathHandler;
    }

    @Override
    public void addStaticResourceToServe(StaticResource<?> staticResource) {
        Map<String, StaticResource<?>> staticResourcesServedByUrlPath = this.getStaticResourcesServedByUrlPath();
        StaticResourceType staticResourceType = staticResource.getStaticResourceType();
        if (staticResourcesServedByUrlPath.containsKey(staticResource.getUrlPath())) {
            this.getStaticResourcesPathHandler().removeExactPath(staticResource.getUrlPath());
            this.getStaticResourcesPathHandler().removePrefixPath(staticResource.getUrlPath());
        }
        staticResourcesServedByUrlPath.put(staticResource.getUrlPath(), staticResource);
        if (staticResourceType == StaticResourceType.FILE) {
            CorsHandler corsHandler;
            File file = new File(staticResource.getResourcePath());
            if (!file.isFile() && !staticResource.isCanBeGenerated()) {
                throw new RuntimeException("The file doesn't exist and can't be generated so it can't be served : " + staticResource.getResourcePath());
            }
            HttpHandler next = staticResource.isCanBeGenerated() ? this.getSpincastFrontControllerHandler() : ResponseCodeHandler.HANDLE_404;
            SpincastResourceHandler resourceHandler = this.getSpincastResourceHandlerFactory().create(new FileResourceManager(file, 1024L), staticResource, next);
            GzipCheckerHandler gzipCheckerHandler = this.getGzipCheckerHandlerFactory().create(resourceHandler, file.getAbsolutePath());
            HttpHandler firstHandler = corsHandler = this.getCorsHandlerFactory().create(gzipCheckerHandler, staticResource.getCorsConfig());
            if (staticResource.isCanBeGenerated() && !staticResource.isIgnoreQueryString()) {
                firstHandler = this.getSkipResourceOnQueryStringHandlerFactory().create(corsHandler, next);
            }
            this.getStaticResourcesPathHandler().addExactPath(staticResource.getUrlPath(), firstHandler);
        } else if (staticResourceType == StaticResourceType.FILE_FROM_CLASSPATH) {
            String classpathPath = staticResource.getResourcePath();
            if (classpathPath == null) {
                classpathPath = "";
            } else if (classpathPath.startsWith("/")) {
                classpathPath = classpathPath.substring(1);
            }
            URL resource = this.getClass().getClassLoader().getResource(classpathPath);
            if (resource == null) {
                throw new RuntimeException("The classpath file doesn't exist so it can't be served : " + classpathPath);
            }
            FileClassPathResourceManager fileClassPathResourceManager = this.getFileClassPathResourceManagerFactory().create(classpathPath);
            SpincastResourceHandler resourceHandler = this.getSpincastResourceHandlerFactory().create(fileClassPathResourceManager, staticResource);
            GzipCheckerHandler gzipCheckerHandler = this.getGzipCheckerHandlerFactory().create(resourceHandler, classpathPath);
            CorsHandler corsHandler = this.getCorsHandlerFactory().create(gzipCheckerHandler, staticResource.getCorsConfig());
            this.getStaticResourcesPathHandler().addExactPath(staticResource.getUrlPath(), corsHandler);
        } else if (staticResourceType == StaticResourceType.DIRECTORY) {
            CorsHandler corsHandler;
            File dir = new File(staticResource.getResourcePath());
            if (!dir.isDirectory() && !staticResource.isCanBeGenerated()) {
                throw new RuntimeException("The directory doesn't exist and can't be generated so it can't be served : " + staticResource.getResourcePath());
            }
            HttpHandler next = staticResource.isCanBeGenerated() ? this.getSpincastFrontControllerHandler() : ResponseCodeHandler.HANDLE_404;
            SpincastResourceHandler resourceHandler = this.getSpincastResourceHandlerFactory().create(new FileResourceManager(dir, 1024L), staticResource, next);
            GzipCheckerHandler gzipCheckerHandler = this.getGzipCheckerHandlerFactory().create(resourceHandler, null);
            HttpHandler firstHandler = corsHandler = this.getCorsHandlerFactory().create(gzipCheckerHandler, staticResource.getCorsConfig());
            if (staticResource.isCanBeGenerated() && !staticResource.isIgnoreQueryString()) {
                firstHandler = this.getSkipResourceOnQueryStringHandlerFactory().create(corsHandler, next);
            }
            this.getStaticResourcesPathHandler().addPrefixPath(staticResource.getUrlPath(), firstHandler);
        } else if (staticResourceType == StaticResourceType.DIRECTORY_FROM_CLASSPATH) {
            String classpathPath = staticResource.getResourcePath();
            if (classpathPath == null) {
                classpathPath = "";
            } else if (classpathPath.startsWith("/")) {
                classpathPath = classpathPath.substring(1);
            }
            URL resource = this.getClass().getClassLoader().getResource(classpathPath);
            if (resource == null) {
                throw new RuntimeException("The classpath directory doesn't exist so it can't be used to serve static resources : " + classpathPath);
            }
            ClassPathResourceManager classPathResourceManager = new ClassPathResourceManager(SpincastUndertowServer.class.getClassLoader(), classpathPath);
            SpincastResourceHandler resourceHandler = this.getSpincastResourceHandlerFactory().create(classPathResourceManager, staticResource);
            GzipCheckerHandler gzipCheckerHandler = this.getGzipCheckerHandlerFactory().create(resourceHandler, null);
            CorsHandler corsHandler = this.getCorsHandlerFactory().create(gzipCheckerHandler, staticResource.getCorsConfig());
            this.getStaticResourcesPathHandler().addPrefixPath(staticResource.getUrlPath(), corsHandler);
        } else {
            throw new RuntimeException("Unamanaged static resource stype : " + (Object)((Object)staticResourceType));
        }
    }

    @Override
    public void removeStaticResourcesServed(StaticResourceType staticResourceType, String urlPath) {
        if (this.staticResourcesServedByUrlPath.containsKey(urlPath)) {
            this.removeStaticResource(staticResourceType, urlPath);
        }
    }

    @Override
    public void removeAllStaticResourcesServed() {
        for (Map.Entry<String, StaticResource<?>> entry : this.getStaticResourcesServedByUrlPath().entrySet()) {
            String urlPath = entry.getKey();
            StaticResource<?> staticResource = entry.getValue();
            this.removeStaticResource(staticResource.getStaticResourceType(), urlPath);
        }
    }

    protected void removeStaticResource(StaticResourceType staticResourceType, String urlPath) {
        if (staticResourceType == StaticResourceType.FILE || staticResourceType == StaticResourceType.FILE_FROM_CLASSPATH) {
            this.getStaticResourcesPathHandler().removeExactPath(urlPath);
        } else if (staticResourceType == StaticResourceType.DIRECTORY || staticResourceType == StaticResourceType.DIRECTORY_FROM_CLASSPATH) {
            this.getStaticResourcesPathHandler().removePrefixPath(urlPath);
        } else {
            throw new RuntimeException("Unamanaged static resource stype : " + (Object)((Object)staticResourceType));
        }
    }

    @Override
    public StaticResource<?> getStaticResourceServed(String urlPath) {
        return this.getStaticResourcesServedByUrlPath().get(urlPath);
    }

    @Override
    public Set<StaticResource<?>> getStaticResourcesServed() {
        return new HashSet(this.getStaticResourcesServedByUrlPath().values());
    }

    @Override
    public HttpMethod getHttpMethod(Object exchange) {
        HttpString httpString = ((HttpServerExchange)exchange).getRequestMethod();
        return HttpMethod.fromStringValue(httpString.toString());
    }

    protected HttpServerExchange castExchange(Object exchange) {
        return (HttpServerExchange)exchange;
    }

    @Override
    public ContentTypeDefaults getContentTypeBestMatch(Object exchangeObj) {
        HttpServerExchange exchange = (HttpServerExchange)exchangeObj;
        ContentTypeDefaults type = ContentTypeDefaults.TEXT;
        HeaderMap requestHeaders = exchange.getRequestHeaders();
        if (requestHeaders != null) {
            String bestMatch;
            String requestedWith = requestHeaders.getFirst("X-Requested-With");
            if ("XMLHttpRequest".equalsIgnoreCase(requestedWith)) {
                return ContentTypeDefaults.JSON;
            }
            String accept = requestHeaders.getFirst("Accept");
            if (accept != null && !StringUtils.isBlank(bestMatch = MIMEParse.bestMatch(ContentTypeDefaults.getAllContentTypesVariations(), accept)) && (type = ContentTypeDefaults.fromString(bestMatch)) == null) {
                this.logger.error("Not supposed : " + bestMatch);
                type = ContentTypeDefaults.TEXT;
            }
        }
        return type;
    }

    @Override
    public String getFullUrlProxied(Object exchangeObj) {
        return this.getFullUrlProxied(exchangeObj, false);
    }

    @Override
    public String getFullUrlProxied(Object exchangeObj, boolean keepCacheBusters) {
        try {
            HttpServerExchange exchange = (HttpServerExchange)exchangeObj;
            String queryString = exchange.getQueryString();
            queryString = StringUtils.isBlank(queryString) ? "" : "?" + queryString;
            if (keepCacheBusters) {
                return this.getCacheBusterRemovalHandler().getOrigninalRequestUrlWithPotentialCacheBusters(exchange) + queryString;
            }
            return exchange.getRequestURL() + queryString;
        }
        catch (Exception ex) {
            throw SpincastStatics.runtimize(ex);
        }
    }

    @Override
    public String getFullUrlOriginal(Object exchangeObj) {
        return this.getFullUrlOriginal(exchangeObj, false);
    }

    @Override
    public String getFullUrlOriginal(Object exchangeObj, boolean keepCacheBusters) {
        try {
            String fullUrl = this.getFullUrlProxied(exchangeObj, keepCacheBusters);
            HttpServerExchange exchange = (HttpServerExchange)exchangeObj;
            HeaderValues protoHeader = exchange.getRequestHeaders().get("X-Forwarded-Proto");
            HeaderValues hostHeader = exchange.getRequestHeaders().get("X-Forwarded-Host");
            HeaderValues portHeader = exchange.getRequestHeaders().get("X-Forwarded-Port");
            if (protoHeader != null || hostHeader != null || portHeader != null) {
                URL proxiedUrl = new URL(fullUrl);
                StringBuilder builder = new StringBuilder();
                if (protoHeader != null) {
                    builder.append(protoHeader.getFirst());
                } else {
                    builder.append(proxiedUrl.getProtocol());
                }
                builder.append("://");
                if (hostHeader != null) {
                    builder.append(hostHeader.getFirst());
                } else {
                    builder.append(proxiedUrl.getHost());
                }
                if (portHeader != null) {
                    builder.append(":").append(portHeader.getFirst());
                } else {
                    builder.append(proxiedUrl.getPort() > -1 ? ":" + proxiedUrl.getPort() : "");
                }
                builder.append(proxiedUrl.getPath());
                String queryString = proxiedUrl.getQuery();
                if (!StringUtils.isBlank(queryString)) {
                    builder.append("?").append(queryString);
                }
                fullUrl = builder.toString();
            }
            return fullUrl;
        }
        catch (Exception ex) {
            throw SpincastStatics.runtimize(ex);
        }
    }

    @Override
    public void setResponseHeader(Object exchangeObj, String name, List<String> values) {
        HttpServerExchange exchange = (HttpServerExchange)exchangeObj;
        HeaderMap responseHeaderMap = exchange.getResponseHeaders();
        responseHeaderMap.putAll(new HttpString(name), values);
    }

    @Override
    public void setResponseHeaders(Object exchange, Map<String, List<String>> headers) {
        HeaderMap responseHeaderMap = ((HttpServerExchange)exchange).getResponseHeaders();
        responseHeaderMap.clear();
        if (headers == null || headers.size() == 0) {
            return;
        }
        for (Map.Entry<String, List<String>> entry : headers.entrySet()) {
            responseHeaderMap.putAll(new HttpString(entry.getKey()), (Collection<String>)entry.getValue());
        }
    }

    @Override
    public Map<String, List<String>> getResponseHeaders(Object exchangeObj) {
        HttpServerExchange exchange = (HttpServerExchange)exchangeObj;
        HashMap<String, List<String>> headers = new HashMap<String, List<String>>();
        HeaderMap responseHeaders = exchange.getResponseHeaders();
        if (responseHeaders != null) {
            for (HeaderValues responseHeader : responseHeaders) {
                HttpString headerNameObj = responseHeader.getHeaderName();
                if (headerNameObj == null) continue;
                ArrayList<String> values = new ArrayList<String>();
                for (String value : responseHeader) {
                    values.add(value);
                }
                headers.put(headerNameObj.toString(), values);
            }
        }
        return headers;
    }

    @Override
    public void removeResponseHeader(Object exchange, String name) {
        HeaderMap responseHeaderMap = ((HttpServerExchange)exchange).getResponseHeaders();
        responseHeaderMap.remove(new HttpString(name));
    }

    @Override
    public void setResponseStatusCode(Object exchange, int statusCode) {
        ((HttpServerExchange)exchange).setStatusCode(statusCode);
    }

    protected IoCallback getDoNothingCallback() {
        if (this.doNothingCallback == null) {
            this.doNothingCallback = new IoCallback(){

                @Override
                public void onComplete(HttpServerExchange exchange, Sender sender) {
                    System.out.println();
                }

                @Override
                public void onException(HttpServerExchange exchange, Sender sender, IOException exception) {
                    throw new RuntimeException(exception);
                }
            };
        }
        return this.doNothingCallback;
    }

    protected IoCallback getCloseExchangeCallback() {
        if (this.closeExchangeCallback == null) {
            this.closeExchangeCallback = new IoCallback(){

                @Override
                public void onComplete(HttpServerExchange exchange, Sender sender) {
                    sender.close();
                    SpincastUndertowServer.this.end(exchange);
                }

                @Override
                public void onException(HttpServerExchange exchange, Sender sender, IOException exception) {
                    throw new RuntimeException(exception);
                }
            };
        }
        return this.closeExchangeCallback;
    }

    @Override
    public void flushBytes(Object exchange, byte[] bytes, boolean end) {
        Sender responseSender = ((HttpServerExchange)exchange).getResponseSender();
        IoCallback callback = end ? this.getCloseExchangeCallback() : this.getDoNothingCallback();
        responseSender.send(ByteBuffer.wrap(bytes), callback);
    }

    @Override
    public void end(Object exchange) {
        try {
            ((HttpServerExchange)exchange).endExchange();
        }
        catch (Exception ex) {
            throw SpincastStatics.runtimize(ex);
        }
    }

    @Override
    public boolean isResponseClosed(Object exchange) {
        return ((HttpServerExchange)exchange).isResponseComplete();
    }

    @Override
    public boolean isResponseHeadersSent(Object exchange) {
        return ((HttpServerExchange)exchange).isResponseStarted();
    }

    @Override
    public String getRequestScheme(Object exchange) {
        return ((HttpServerExchange)exchange).getRequestScheme();
    }

    @Override
    public void addCookies(Object exchange, Map<String, Cookie> cookies) {
        if (cookies == null) {
            return;
        }
        Map<String, io.undertow.server.handlers.Cookie> undertowResponseCookiesMap = ((HttpServerExchange)exchange).getResponseCookies();
        for (Cookie cookie : cookies.values()) {
            String name = cookie.getName();
            String value = cookie.getValue();
            try {
                if (name != null) {
                    name = URLEncoder.encode(name, this.getCookieEncoding());
                }
                if (value != null) {
                    value = URLEncoder.encode(value, this.getCookieEncoding());
                }
            }
            catch (Exception ex) {
                throw SpincastStatics.runtimize(ex);
            }
            CookieImpl undertowCookie = new CookieImpl(name);
            undertowCookie.setValue(value);
            undertowCookie.setDiscard(cookie.isDiscard());
            undertowCookie.setDomain(cookie.getDomain());
            undertowCookie.setExpires(cookie.getExpires());
            undertowCookie.setHttpOnly(cookie.isHttpOnly());
            CookieSameSite sameSite = cookie.getSameSite();
            if (sameSite != null) {
                undertowCookie.setSameSite(true);
                undertowCookie.setSameSiteMode(sameSite.toString());
            }
            undertowCookie.setPath(cookie.getPath());
            undertowCookie.setSecure(cookie.isSecure());
            undertowCookie.setVersion(cookie.getVersion());
            undertowResponseCookiesMap.put(name, undertowCookie);
        }
    }

    @Override
    public Map<String, String> getCookies(Object exchange) {
        HashMap<String, String> cookies = new HashMap<String, String>();
        Map<String, io.undertow.server.handlers.Cookie> undertowRequestCookies = ((HttpServerExchange)exchange).getRequestCookies();
        if (undertowRequestCookies != null) {
            for (io.undertow.server.handlers.Cookie undertowCookie : undertowRequestCookies.values()) {
                String name = undertowCookie.getName();
                String value = undertowCookie.getValue();
                try {
                    if (name != null) {
                        name = URLDecoder.decode(name, this.getCookieEncoding());
                    }
                    if (value != null) {
                        value = URLDecoder.decode(value, this.getCookieEncoding());
                    }
                }
                catch (Exception ex) {
                    throw SpincastStatics.runtimize(ex);
                }
                cookies.put(name, value);
            }
        }
        return cookies;
    }

    protected String getCookieEncoding() {
        return "UTF-8";
    }

    @Override
    public Map<String, List<String>> getQueryStringParams(Object exchange) {
        HashMap<String, List<String>> queryStringParams = new HashMap<String, List<String>>();
        Map<String, Deque<String>> queryParameters = ((HttpServerExchange)exchange).getQueryParameters();
        if (queryParameters != null) {
            for (Map.Entry<String, Deque<String>> entry : queryParameters.entrySet()) {
                LinkedList list = new LinkedList(entry.getValue());
                queryStringParams.put(entry.getKey(), list);
            }
        }
        return queryStringParams;
    }

    @Override
    public InputStream getRawInputStream(Object exchangeObj) {
        HttpServerExchange exchange = (HttpServerExchange)exchangeObj;
        exchange.startBlocking();
        return exchange.getInputStream();
    }

    protected FormData getFormData(HttpServerExchange exchange) {
        try {
            FormDataParser formDataParser = this.getFormParserFactory().createParser(exchange);
            if (formDataParser == null) {
                return null;
            }
            formDataParser.setCharacterEncoding(this.getSpincastUndertowConfig().getHtmlFormEncoding());
            if (!exchange.isBlocking()) {
                exchange.startBlocking();
            }
            FormData formData = formDataParser.parseBlocking();
            return formData;
        }
        catch (Exception ex) {
            if (ex.getCause() instanceof NoSuchFileException) {
                this.createUndertowTempDir();
            }
            throw SpincastStatics.runtimize(ex);
        }
    }

    @Override
    public Map<String, List<String>> getFormData(Object exchangeObj) {
        HttpServerExchange exchange = (HttpServerExchange)exchangeObj;
        HashMap<String, List<String>> postParams = new HashMap<String, List<String>>();
        FormData formData = this.getFormData(exchange);
        if (formData != null) {
            for (String key : formData) {
                Deque<FormData.FormValue> values = formData.get(key);
                if (values == null) continue;
                ArrayList<String> finalValues = new ArrayList<String>();
                for (FormData.FormValue formValue : values) {
                    String value;
                    if (formValue.isFile() || (value = formValue.getValue()) == null) continue;
                    finalValues.add(value);
                }
                postParams.put(key, finalValues);
            }
        }
        return postParams;
    }

    @Override
    public Map<String, List<UploadedFile>> getUploadedFiles(Object exchangeObj) {
        HttpServerExchange exchange = (HttpServerExchange)exchangeObj;
        HashMap<String, List<UploadedFile>> uploadedFiles = new HashMap<String, List<UploadedFile>>();
        FormData formData = this.getFormData(exchange);
        if (formData != null) {
            for (String key : formData) {
                Deque<FormData.FormValue> values = formData.get(key);
                if (values == null) continue;
                ArrayList<UploadedFileDefault> finalFiles = new ArrayList<UploadedFileDefault>();
                for (FormData.FormValue formValue : values) {
                    File file;
                    if (!formValue.isFile() || (file = formValue.getPath().toFile()) == null) continue;
                    String fileName = formValue.getFileName();
                    if (StringUtils.isBlank(fileName)) {
                        fileName = UUID.randomUUID().toString();
                    }
                    UploadedFileDefault uploadedFile = new UploadedFileDefault(file, fileName);
                    finalFiles.add(uploadedFile);
                }
                uploadedFiles.put(key, finalFiles);
            }
        }
        return uploadedFiles;
    }

    @Override
    public boolean forceRequestSizeValidation(Object exchangeObj) {
        block3: {
            HttpServerExchange exchange = (HttpServerExchange)exchangeObj;
            if (exchange.isRequestComplete()) {
                return true;
            }
            try {
                ByteBuffer b = ByteBuffer.allocate(200);
                exchange.getRequestChannel().read(b);
            }
            catch (Exception ex) {
                String message = ex.getMessage();
                if (message == null || !message.contains(UNDERTOW_EXCEPTION_CODE_REQUEST_TOO_LARGE)) break block3;
                return false;
            }
        }
        return true;
    }

    @Override
    public Map<String, List<String>> getRequestHeaders(Object exchangeObj) {
        HttpServerExchange exchange = (HttpServerExchange)exchangeObj;
        TreeMap<String, List<String>> headers = new TreeMap<String, List<String>>(String.CASE_INSENSITIVE_ORDER);
        HeaderMap requestHeaders = exchange.getRequestHeaders();
        if (requestHeaders != null) {
            for (HeaderValues requestHeader : requestHeaders) {
                HttpString headerNameObj = requestHeader.getHeaderName();
                if (headerNameObj == null) continue;
                ArrayList<String> values = new ArrayList<String>();
                for (String value : requestHeader) {
                    values.add(value);
                }
                headers.put(headerNameObj.toString(), values);
            }
        }
        return headers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object getWebsocketEndpointCreationLock(String endpointId) {
        Object lock = this.websocketEndpointCreationLocks.get(endpointId);
        if (lock == null) {
            Object object = this.websocketEndpointLockCreationLock;
            synchronized (object) {
                lock = this.websocketEndpointCreationLocks.get(endpointId);
                if (lock == null) {
                    lock = new Object();
                    this.websocketEndpointCreationLocks.put(endpointId, lock);
                }
            }
        }
        return lock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public WebsocketEndpointManager websocketCreateEndpoint(String endpointId, WebsocketEndpointHandler appEndpointHandler) {
        Object lock;
        Object object = lock = this.getWebsocketEndpointCreationLock(endpointId);
        synchronized (object) {
            WebsocketEndpoint websocketEndpoint = this.getWebsocketEndpointsMap().get(endpointId);
            if (websocketEndpoint != null) {
                throw new RuntimeException("The endpoint '" + endpointId + "' already exists.");
            }
            WebsocketEndpointHandler undertowEndpointHandler = this.createUndertowWebsocketEndpointHandler(endpointId, appEndpointHandler);
            websocketEndpoint = this.getSpincastWebsocketEndpointFactory().create(endpointId, undertowEndpointHandler);
            this.getWebsocketEndpointsMap().put(endpointId, websocketEndpoint);
            return websocketEndpoint;
        }
    }

    protected WebsocketEndpointHandler createUndertowWebsocketEndpointHandler(final String endpointId, final WebsocketEndpointHandler appHandler) {
        return new WebsocketEndpointHandler(){

            @Override
            public void onPeerMessage(String peerId, byte[] message) {
                appHandler.onPeerMessage(peerId, message);
            }

            @Override
            public void onPeerMessage(String peerId, String message) {
                appHandler.onPeerMessage(peerId, message);
            }

            @Override
            public void onPeerConnected(String peerId) {
                appHandler.onPeerConnected(peerId);
            }

            @Override
            public void onPeerClosed(String peerId) {
                appHandler.onPeerClosed(peerId);
            }

            @Override
            public void onEndpointClosed() {
                SpincastUndertowServer.this.getWebsocketEndpointsMap().remove(endpointId);
                appHandler.onEndpointClosed();
            }
        };
    }

    @Override
    public void websocketCloseEndpoint(String endpointId) {
        this.websocketCloseEndpoint(endpointId, this.getSpincastUndertowConfig().getWebsocketDefaultClosingCode(), this.getSpincastUndertowConfig().getWebsocketDefaultClosingReason());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void websocketCloseEndpoint(String endpointId, int closingCode, String closingReason) {
        Object lock;
        Object object = lock = this.getWebsocketEndpointCreationLock(endpointId);
        synchronized (object) {
            WebsocketEndpoint websocketEndpoint = this.getWebsocketEndpointsMap().get(endpointId);
            if (websocketEndpoint == null) {
                this.logger.warn("No Websocket endpoint with id '" + endpointId + "' exists...");
                return;
            }
            websocketEndpoint.closeEndpoint(closingCode, closingReason);
        }
    }

    @Override
    public void websocketConnection(Object exchangeObj, String endpointId, String peerId) {
        if (StringUtils.isBlank(endpointId)) {
            throw new RuntimeException("The endpoint id can't be empty.");
        }
        if (StringUtils.isBlank(peerId)) {
            throw new RuntimeException("The peer id can't be empty.");
        }
        HttpServerExchange exchange = (HttpServerExchange)exchangeObj;
        WebsocketEndpoint websocketEndpoint = this.getWebsocketEndpointsMap().get(endpointId);
        if (websocketEndpoint == null) {
            throw new RuntimeException("The Websocket endpoint '" + endpointId + "' doesn't exist.");
        }
        if (websocketEndpoint.getPeersIds().contains(peerId)) {
            throw new RuntimeException("The Websocket endpoint '" + endpointId + "' is already used by a peer with id '" + peerId + "'! Close the existing peer if you want to reuse this id.");
        }
        websocketEndpoint.handleConnectionRequest(exchange, peerId);
    }

    @Override
    public List<WebsocketEndpointManager> getWebsocketEndpointManagers() {
        return new ArrayList<WebsocketEndpointManager>(this.getWebsocketEndpointsMap().values());
    }

    @Override
    public WebsocketEndpointManager getWebsocketEndpointManager(String endpointId) {
        return this.getWebsocketEndpointsMap().get(endpointId);
    }

    @Override
    public String getIp(Object exchangeObj) {
        HttpServerExchange exchange = (HttpServerExchange)exchangeObj;
        List<String> xForwardedForHeaders = this.getRequestHeaders(exchangeObj).get("X-Forwarded-For");
        if (xForwardedForHeaders != null && xForwardedForHeaders.size() > 0) {
            String xForwardedForHeader = xForwardedForHeaders.get(0);
            try {
                return new StringTokenizer(xForwardedForHeader, ",").nextToken().trim();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return new StringTokenizer(exchange.getSourceAddress().getAddress().toString(), "/").nextToken().trim();
    }
}

