/*
 * Decompiled with CFR 0.152.
 */
package org.spincast.testing.core;

import com.google.inject.Inject;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.junit.Before;
import org.spincast.core.cookies.ICookie;
import org.spincast.core.cookies.ICookieFactory;
import org.spincast.core.exchange.IRequestContext;
import org.spincast.core.routing.HttpMethod;
import org.spincast.core.routing.IRouter;
import org.spincast.core.server.IServer;
import org.spincast.core.utils.ContentTypeDefaults;
import org.spincast.core.utils.SpincastStatics;
import org.spincast.shaded.org.apache.commons.lang3.StringUtils;
import org.spincast.shaded.org.apache.http.Header;
import org.spincast.shaded.org.apache.http.HttpEntity;
import org.spincast.shaded.org.apache.http.HttpResponse;
import org.spincast.shaded.org.apache.http.NameValuePair;
import org.spincast.shaded.org.apache.http.client.CookieStore;
import org.spincast.shaded.org.apache.http.client.HttpClient;
import org.spincast.shaded.org.apache.http.client.config.RequestConfig;
import org.spincast.shaded.org.apache.http.client.entity.UrlEncodedFormEntity;
import org.spincast.shaded.org.apache.http.client.methods.HttpDelete;
import org.spincast.shaded.org.apache.http.client.methods.HttpGet;
import org.spincast.shaded.org.apache.http.client.methods.HttpHead;
import org.spincast.shaded.org.apache.http.client.methods.HttpOptions;
import org.spincast.shaded.org.apache.http.client.methods.HttpPost;
import org.spincast.shaded.org.apache.http.client.methods.HttpRequestBase;
import org.spincast.shaded.org.apache.http.client.methods.HttpTrace;
import org.spincast.shaded.org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.spincast.shaded.org.apache.http.conn.ssl.TrustSelfSignedStrategy;
import org.spincast.shaded.org.apache.http.cookie.Cookie;
import org.spincast.shaded.org.apache.http.entity.StringEntity;
import org.spincast.shaded.org.apache.http.impl.client.BasicCookieStore;
import org.spincast.shaded.org.apache.http.impl.client.HttpClientBuilder;
import org.spincast.shaded.org.apache.http.ssl.SSLContexts;
import org.spincast.shaded.org.apache.http.util.EntityUtils;
import org.spincast.testing.core.SpincastGuiceBasedTestBase;
import org.spincast.testing.core.utils.SpincastTestHttpResponse;

public abstract class SpincastIntegrationTestBase<R extends IRequestContext<?>>
extends SpincastGuiceBasedTestBase {
    @Inject
    private IServer server;
    @Inject
    private IRouter<R> router;
    @Inject
    private ICookieFactory cookieFactory;
    private CookieStore cookieStore;

    @Override
    public void afterClass() {
        super.afterClass();
        this.stopServer();
    }

    @Before
    public void before() {
        this.clearHttpClientData();
    }

    protected void clearHttpClientData() {
        this.getCookieStore().clear();
    }

    protected void stopServer() {
        if (this.getServer() != null) {
            this.getServer().stop();
        }
    }

    protected IRouter<R> getRouter() {
        return this.router;
    }

    protected ICookieFactory getCookieFactory() {
        return this.cookieFactory;
    }

    protected IServer getServer() {
        return this.server;
    }

    protected CookieStore getCookieStore() {
        if (this.cookieStore == null) {
            this.cookieStore = new BasicCookieStore();
        }
        return this.cookieStore;
    }

    protected String getCookieEncoding() {
        return "UTF-8";
    }

    protected HttpClient getHttpClient() {
        try {
            HttpClientBuilder httpClientBuilder = HttpClientBuilder.create().setDefaultCookieStore(this.getCookieStore());
            SSLContext sslcontext = SSLContexts.custom().loadTrustMaterial(null, new TrustSelfSignedStrategy()).build();
            SSLConnectionSocketFactory sslsf = new SSLConnectionSocketFactory(sslcontext, new String[]{"TLSv1"}, null, (HostnameVerifier)new NoopHostnameVerifier());
            httpClientBuilder.setSSLSocketFactory(sslsf);
            return httpClientBuilder.build();
        }
        catch (Exception ex) {
            throw SpincastStatics.runtimize(ex);
        }
    }

    protected String createTestUrl(String path) {
        return this.createTestUrl(path, false);
    }

    protected String createTestUrl(String path, boolean https) {
        if (StringUtils.isBlank(path)) {
            path = "/";
        } else if (!path.startsWith("/")) {
            path = "/" + path;
        }
        return "http" + (https ? "s" : "") + "://" + this.getSpincastConfig().getServerHost() + ":" + (https ? this.getSpincastConfig().getHttpsServerPort() : this.getSpincastConfig().getHttpServerPort()) + path;
    }

    protected SpincastTestHttpResponse get(String path) throws Exception {
        return this.get(path, null, null);
    }

    protected SpincastTestHttpResponse get(String path, boolean https) throws Exception {
        return this.get(path, null, null, https);
    }

    protected SpincastTestHttpResponse get(String path, Map<String, String> headers) throws Exception {
        return this.get(path, headers, null);
    }

    protected SpincastTestHttpResponse get(String path, Map<String, String> headers, boolean https) throws Exception {
        return this.get(path, headers, null, https);
    }

    protected SpincastTestHttpResponse get(String path, RequestConfig requestConfig) throws Exception {
        return this.get(path, null, requestConfig);
    }

    protected SpincastTestHttpResponse get(String path, RequestConfig requestConfig, boolean https) throws Exception {
        return this.get(path, null, requestConfig, https);
    }

    protected SpincastTestHttpResponse get(String path, Map<String, String> headers, RequestConfig requestConfig) throws Exception {
        return this.get(path, headers, requestConfig, false);
    }

    protected SpincastTestHttpResponse get(String path, Map<String, String> headers, RequestConfig requestConfig, boolean https) throws Exception {
        return this.getWithUrl(this.createTestUrl(path, https), headers, requestConfig);
    }

    protected SpincastTestHttpResponse getWithUrl(String url) throws Exception {
        return this.getWithUrl(url, null, null);
    }

    protected SpincastTestHttpResponse getWithUrl(String url, RequestConfig requestConfig) throws Exception {
        return this.getWithUrl(url, null, requestConfig);
    }

    protected SpincastTestHttpResponse getWithUrl(String url, Map<String, String> headers, RequestConfig requestConfig) throws Exception {
        return this.methodWithUrl(HttpMethod.GET, url, headers, requestConfig);
    }

    protected SpincastTestHttpResponse getWithUrl(String url, Map<String, String> headers) throws Exception {
        return this.methodWithUrl(HttpMethod.GET, url, headers, null);
    }

    protected HttpResponse getRawResponse(String url) {
        return this.getRawResponse(url, null, null);
    }

    protected HttpResponse getRawResponse(String url, Map<String, String> headers) {
        return this.getRawResponse(url, headers, null);
    }

    protected HttpResponse getRawResponse(String url, RequestConfig requestConfig) {
        return this.getRawResponse(url, null, requestConfig);
    }

    protected HttpResponse getRawResponse(String url, Map<String, String> headers, RequestConfig requestConfig) {
        return this.requestRaw(HttpMethod.GET, url, headers, requestConfig, null, null, null);
    }

    protected SpincastTestHttpResponse postWithParams(String path, List<NameValuePair> params) throws Exception {
        return this.methodWithUrl(HttpMethod.POST, this.createTestUrl(path), null, null, params);
    }

    protected SpincastTestHttpResponse postWithHeaders(String path, Map<String, String> headers) throws Exception {
        return this.methodWithUrl(HttpMethod.POST, this.createTestUrl(path), headers, null, null);
    }

    protected SpincastTestHttpResponse postStringEntity(String path, String str, String contentType) throws Exception {
        return this.request(HttpMethod.POST, this.createTestUrl(path), null, null, null, str, contentType);
    }

    protected SpincastTestHttpResponse postJson(String path, String json) throws Exception {
        return this.request(HttpMethod.POST, this.createTestUrl(path), null, null, null, json, ContentTypeDefaults.JSON.getMainVariationWithUtf8Charset());
    }

    protected SpincastTestHttpResponse methodWithUrl(HttpMethod method, String url, Map<String, String> headers, RequestConfig requestConfig) throws Exception {
        return this.methodWithUrl(method, url, headers, requestConfig, null);
    }

    protected SpincastTestHttpResponse methodWithUrl(HttpMethod method, String url, Map<String, String> headers, RequestConfig requestConfig, List<NameValuePair> params) throws Exception {
        return this.request(method, url, headers, requestConfig, params, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SpincastTestHttpResponse request(HttpMethod method, String url, Map<String, String> headers, RequestConfig requestConfig, List<NameValuePair> params, String payload, String contentTypeIn) throws Exception {
        HttpResponse response = this.requestRaw(method, url, headers, requestConfig, params, payload, contentTypeIn);
        try {
            Header[] allHeaders;
            HttpEntity entity;
            String content = null;
            int status = response.getStatusLine().getStatusCode();
            String contentType = null;
            Header contentTypeHeader = response.getFirstHeader("Content-Type");
            if (contentTypeHeader != null) {
                contentType = contentTypeHeader.getValue();
            }
            if ((entity = response.getEntity()) != null) {
                content = EntityUtils.toString(entity, "UTF-8");
            }
            HashMap<String, List<String>> responseHeaders = new HashMap<String, List<String>>();
            for (Header header : allHeaders = response.getAllHeaders()) {
                ArrayList<String> vals = (ArrayList<String>)responseHeaders.get(header.getName());
                if (vals == null) {
                    vals = new ArrayList<String>();
                    responseHeaders.put(header.getName(), vals);
                }
                vals.add(header.getValue());
            }
            HashMap<String, ICookie> cookies = new HashMap<String, ICookie>();
            CookieStore cookieStore = this.getCookieStore();
            List<Cookie> responseCookies = cookieStore.getCookies();
            for (Cookie responseCookie : responseCookies) {
                String name = responseCookie.getName();
                String value = responseCookie.getValue();
                if (value != null) {
                    try {
                        name = URLDecoder.decode(name, this.getCookieEncoding());
                        value = URLDecoder.decode(value, this.getCookieEncoding());
                    }
                    catch (Exception ex) {
                        throw SpincastStatics.runtimize(ex);
                    }
                }
                ICookie cookie = this.getCookieFactory().createCookie(name, value, responseCookie.getPath(), responseCookie.getDomain(), responseCookie.getExpiryDate(), responseCookie.isSecure(), false, !responseCookie.isPersistent(), responseCookie.getVersion());
                cookies.put(cookie.getName(), cookie);
            }
            SpincastTestHttpResponse spincastTestHttpResponse = new SpincastTestHttpResponse(status, contentType, content, responseHeaders, cookies);
            return spincastTestHttpResponse;
        }
        finally {
            EntityUtils.consumeQuietly(response.getEntity());
        }
    }

    protected HttpResponse requestRaw(HttpMethod method, String url, Map<String, String> headers, RequestConfig requestConfig, List<NameValuePair> params, String str, String contentType) {
        try {
            HttpRequestBase request;
            if (headers == null) {
                headers = new HashMap<String, String>();
            }
            if (requestConfig == null) {
                requestConfig = RequestConfig.copy(RequestConfig.DEFAULT).setCookieSpec("standard").build();
            }
            if (method == HttpMethod.GET) {
                request = new HttpGet(url);
            } else if (method == HttpMethod.POST) {
                request = new HttpPost(url);
                if (params != null) {
                    ((HttpPost)request).setEntity(new UrlEncodedFormEntity(params, "UTF-8"));
                } else if (str != null) {
                    StringEntity input = new StringEntity(str, "UTF-8");
                    input.setContentType(contentType);
                    ((HttpPost)request).setEntity(input);
                }
            } else if (method == HttpMethod.HEAD) {
                request = new HttpHead(url);
            } else if (method == HttpMethod.DELETE) {
                request = new HttpDelete(url);
            } else if (method == HttpMethod.OPTIONS) {
                request = new HttpOptions(url);
            } else if (method == HttpMethod.TRACE) {
                request = new HttpTrace(url);
            } else {
                throw new RuntimeException("Not implemented : " + (Object)((Object)method));
            }
            if (requestConfig != null) {
                request.setConfig(requestConfig);
            }
            for (Map.Entry<String, String> header : headers.entrySet()) {
                request.addHeader(header.getKey(), header.getValue());
            }
            return this.getHttpClient().execute(request);
        }
        catch (Exception ex) {
            throw SpincastStatics.runtimize(ex);
        }
    }
}

