/*
 * Decompiled with CFR 0.152.
 */
package net.logstash.logback.stacktrace;

import ch.qos.logback.classic.pattern.Abbreviator;
import ch.qos.logback.classic.pattern.TargetLengthBasedClassNameAbbreviator;
import ch.qos.logback.classic.pattern.ThrowableHandlingConverter;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.classic.spi.IThrowableProxy;
import ch.qos.logback.classic.spi.StackTraceElementProxy;
import ch.qos.logback.classic.spi.ThrowableProxyUtil;
import ch.qos.logback.core.CoreConstants;
import ch.qos.logback.core.boolex.EvaluationException;
import ch.qos.logback.core.boolex.EventEvaluator;
import ch.qos.logback.core.status.ErrorStatus;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Pattern;
import net.logstash.logback.CachingAbbreviator;
import net.logstash.logback.NullAbbreviator;

public class ShortenedThrowableConverter
extends ThrowableHandlingConverter {
    public static final int FULL_MAX_DEPTH_PER_THROWABLE = Integer.MAX_VALUE;
    public static final int SHORT_MAX_DEPTH_PER_THROWABLE = 3;
    public static final int DEFAULT_MAX_DEPTH_PER_THROWABLE = 25;
    public static final int FULL_MAX_LENGTH = Integer.MAX_VALUE;
    public static final int SHORT_MAX_LENGTH = 1024;
    public static final int DEFAULT_MAX_LENGTH = Integer.MAX_VALUE;
    public static final int FULL_CLASS_NAME_LENGTH = Integer.MAX_VALUE;
    public static final int SHORT_CLASS_NAME_LENGTH = 10;
    public static final int DEFAULT_CLASS_NAME_LENGTH = Integer.MAX_VALUE;
    private static final String ELLIPSIS = "...";
    private static final int BUFFER_INITIAL_CAPACITY = 4096;
    private static final String OPTION_VALUE_FULL = "full";
    private static final String OPTION_VALUE_SHORT = "short";
    private static final String OPTION_VALUE_ROOT_FIRST = "rootFirst";
    private static final int OPTION_INDEX_MAX_DEPTH = 0;
    private static final int OPTION_INDEX_SHORTENED_CLASS_NAME = 1;
    private static final int OPTION_INDEX_MAX_LENGTH = 2;
    private AtomicInteger errorCount = new AtomicInteger();
    private int maxDepthPerThrowable = 25;
    private int maxLength = Integer.MAX_VALUE;
    private int shortenedClassNameLength = Integer.MAX_VALUE;
    private Abbreviator abbreviator = NullAbbreviator.INSTANCE;
    private List<Pattern> excludes = new ArrayList<Pattern>(5);
    private boolean rootCauseFirst;
    private List<EventEvaluator<ILoggingEvent>> evaluators = new ArrayList<EventEvaluator<ILoggingEvent>>(1);

    @Override
    public void start() {
        this.parseOptions();
        super.start();
    }

    private void parseOptions() {
        List<String> optionList = this.getOptionList();
        if (optionList == null) {
            return;
        }
        int optionListSize = optionList.size();
        block5: for (int i = 0; i < optionListSize; ++i) {
            String option = optionList.get(i);
            switch (i) {
                case 0: {
                    this.setMaxDepthPerThrowable(this.parseIntegerOptionValue(option, Integer.MAX_VALUE, 3, 25));
                    continue block5;
                }
                case 1: {
                    this.setShortenedClassNameLength(this.parseIntegerOptionValue(option, Integer.MAX_VALUE, 10, Integer.MAX_VALUE));
                    continue block5;
                }
                case 2: {
                    this.setMaxLength(this.parseIntegerOptionValue(option, Integer.MAX_VALUE, 1024, Integer.MAX_VALUE));
                    continue block5;
                }
                default: {
                    EventEvaluator evaluator;
                    if (OPTION_VALUE_ROOT_FIRST.equals(option)) {
                        this.setRootCauseFirst(true);
                        continue block5;
                    }
                    Map evaluatorMap = (Map)this.getContext().getObject("EVALUATOR_MAP");
                    EventEvaluator eventEvaluator = evaluator = evaluatorMap != null ? (EventEvaluator)evaluatorMap.get(option) : null;
                    if (evaluator != null) {
                        this.addEvaluator(evaluator);
                        continue block5;
                    }
                    this.addExclude(option);
                }
            }
        }
    }

    private int parseIntegerOptionValue(String option, int valueIfFull, int valueIfShort, int valueIfNonParsable) {
        if (OPTION_VALUE_FULL.equals(option)) {
            return valueIfFull;
        }
        if (OPTION_VALUE_SHORT.equals(option)) {
            return valueIfShort;
        }
        try {
            return Integer.parseInt(option);
        }
        catch (NumberFormatException nfe) {
            this.addError("Could not parse [" + option + "] as an integer");
            return valueIfNonParsable;
        }
    }

    @Override
    public String convert(ILoggingEvent event) {
        IThrowableProxy throwableProxy = event.getThrowableProxy();
        if (throwableProxy == null || this.isExcludedByEvaluator(event)) {
            return "";
        }
        StringBuilder builder = new StringBuilder(Math.min(4096, Math.max(Integer.MAX_VALUE, this.maxLength + 100)));
        if (this.rootCauseFirst) {
            this.appendRootCauseFirst(builder, null, 1, throwableProxy);
        } else {
            this.appendRootCauseLast(builder, null, 1, throwableProxy);
        }
        if (builder.length() > this.maxLength) {
            builder.setLength(this.maxLength - ELLIPSIS.length());
            builder.append(ELLIPSIS);
        }
        return builder.toString();
    }

    private boolean isExcludedByEvaluator(ILoggingEvent event) {
        for (int i = 0; i < this.evaluators.size(); ++i) {
            EventEvaluator<ILoggingEvent> evaluator = this.evaluators.get(i);
            try {
                if (!evaluator.evaluate(event)) continue;
                return true;
            }
            catch (EvaluationException eex) {
                int errors = this.errorCount.incrementAndGet();
                if (errors < 4) {
                    this.addError(String.format("Exception thrown for evaluator named [%s]", evaluator.getName()), eex);
                    continue;
                }
                if (errors != 4) continue;
                ErrorStatus errorStatus = new ErrorStatus(String.format("Exception thrown for evaluator named [%s]", evaluator.getName()), this, eex);
                errorStatus.add(new ErrorStatus("This was the last warning about this evaluator's errors.We don't want the StatusManager to get flooded.", this));
                this.addStatus(errorStatus);
            }
        }
        return false;
    }

    private void appendRootCauseLast(StringBuilder builder, String prefix, int indent, IThrowableProxy throwableProxy) {
        if (throwableProxy == null || builder.length() > this.maxLength) {
            return;
        }
        this.appendFirstLine(builder, prefix, indent, throwableProxy);
        this.appendStackTraceElements(builder, indent, throwableProxy);
        IThrowableProxy[] suppressedThrowableProxies = throwableProxy.getSuppressed();
        if (suppressedThrowableProxies != null) {
            for (IThrowableProxy suppressedThrowableProxy : suppressedThrowableProxies) {
                this.appendRootCauseLast(builder, "Suppressed: ", indent + 1, suppressedThrowableProxy);
            }
        }
        this.appendRootCauseLast(builder, "Caused by: ", indent, throwableProxy.getCause());
    }

    private void appendRootCauseFirst(StringBuilder builder, String prefix, int indent, IThrowableProxy throwableProxy) {
        if (throwableProxy == null || builder.length() > this.maxLength) {
            return;
        }
        if (throwableProxy.getCause() != null) {
            this.appendRootCauseFirst(builder, prefix, indent, throwableProxy.getCause());
            prefix = "Wrapped by: ";
        }
        this.appendFirstLine(builder, prefix, indent, throwableProxy);
        this.appendStackTraceElements(builder, indent, throwableProxy);
        IThrowableProxy[] suppressedThrowableProxies = throwableProxy.getSuppressed();
        if (suppressedThrowableProxies != null) {
            for (IThrowableProxy suppressedThrowableProxy : suppressedThrowableProxies) {
                this.appendRootCauseFirst(builder, "Suppressed: ", indent + 1, suppressedThrowableProxy);
            }
        }
    }

    private void appendStackTraceElements(StringBuilder builder, int indent, IThrowableProxy throwableProxy) {
        if (builder.length() > this.maxLength) {
            return;
        }
        StackTraceElementProxy[] stackTraceElements = throwableProxy.getStackTraceElementProxyArray();
        int commonFrames = throwableProxy.getCommonFrames();
        boolean appendingExcluded = false;
        int consecutiveExcluded = 0;
        int appended = 0;
        StackTraceElementProxy previousWrittenStackTraceElement = null;
        for (int i = 0; i < stackTraceElements.length - commonFrames; ++i) {
            if (this.maxDepthPerThrowable > 0 && appended >= this.maxDepthPerThrowable) {
                this.appendPlaceHolder(builder, indent, stackTraceElements.length - commonFrames - this.maxDepthPerThrowable, "frames truncated");
                break;
            }
            StackTraceElementProxy stackTraceElement = stackTraceElements[i];
            if (i <= 1 || this.isIncluded(stackTraceElement)) {
                if (consecutiveExcluded >= 2) {
                    this.appendPlaceHolder(builder, indent, consecutiveExcluded, "frames excluded");
                    consecutiveExcluded = 0;
                } else if (consecutiveExcluded == 1) {
                    appendingExcluded = true;
                    consecutiveExcluded = 0;
                    i -= 2;
                    continue;
                }
                this.appendStackTraceElement(builder, indent, stackTraceElement, previousWrittenStackTraceElement);
                previousWrittenStackTraceElement = stackTraceElement;
                appendingExcluded = false;
                ++appended;
                continue;
            }
            if (appendingExcluded) {
                this.appendStackTraceElement(builder, indent, stackTraceElement, previousWrittenStackTraceElement);
                previousWrittenStackTraceElement = stackTraceElement;
                ++appended;
                continue;
            }
            ++consecutiveExcluded;
        }
        if (consecutiveExcluded > 0) {
            this.appendPlaceHolder(builder, indent, consecutiveExcluded, "frames excluded");
        }
        if (commonFrames > 0) {
            this.appendPlaceHolder(builder, indent, commonFrames, "common frames omitted");
        }
    }

    private void appendPlaceHolder(StringBuilder builder, int indent, int consecutiveExcluded, String message) {
        this.indent(builder, indent);
        builder.append(ELLIPSIS).append(" ").append(consecutiveExcluded).append(" ").append(message).append(CoreConstants.LINE_SEPARATOR);
    }

    private boolean isIncluded(StackTraceElementProxy step) {
        if (!this.excludes.isEmpty()) {
            StackTraceElement stackTraceElement = step.getStackTraceElement();
            String testString = stackTraceElement.getClassName() + "." + stackTraceElement.getMethodName();
            for (Pattern exclusionPattern : this.excludes) {
                if (!exclusionPattern.matcher(testString).find()) continue;
                return false;
            }
        }
        return true;
    }

    private void appendStackTraceElement(StringBuilder builder, int indent, StackTraceElementProxy step, StackTraceElementProxy previousStep) {
        if (builder.length() > this.maxLength) {
            return;
        }
        this.indent(builder, indent);
        StackTraceElement stackTraceElement = step.getStackTraceElement();
        String fileName = stackTraceElement.getFileName();
        int lineNumber = stackTraceElement.getLineNumber();
        builder.append("at ").append(this.abbreviator.abbreviate(stackTraceElement.getClassName())).append(".").append(stackTraceElement.getMethodName()).append("(").append(fileName == null ? "Unknown Source" : fileName);
        if (lineNumber >= 0) {
            builder.append(":").append(lineNumber);
        }
        builder.append(")");
        if (this.shouldAppendPackagingData(step, previousStep)) {
            this.appendPackagingData(builder, step);
        }
        builder.append(CoreConstants.LINE_SEPARATOR);
    }

    private boolean shouldAppendPackagingData(StackTraceElementProxy step, StackTraceElementProxy previousStep) {
        if (step == null || step.getClassPackagingData() == null) {
            return false;
        }
        if (previousStep == null || previousStep.getClassPackagingData() == null) {
            return true;
        }
        return !step.getClassPackagingData().equals(previousStep.getClassPackagingData());
    }

    private void appendPackagingData(StringBuilder builder, StackTraceElementProxy step) {
        ThrowableProxyUtil.subjoinPackagingData(builder, step);
    }

    private void appendFirstLine(StringBuilder builder, String prefix, int indent, IThrowableProxy throwableProxy) {
        if (builder.length() > this.maxLength) {
            return;
        }
        this.indent(builder, indent - 1);
        if (prefix != null) {
            builder.append(prefix);
        }
        builder.append(this.abbreviator.abbreviate(throwableProxy.getClassName())).append(": ").append(throwableProxy.getMessage()).append(CoreConstants.LINE_SEPARATOR);
    }

    private void indent(StringBuilder builder, int indent) {
        ThrowableProxyUtil.indent(builder, indent);
    }

    public int getShortenedClassNameLength() {
        return this.shortenedClassNameLength;
    }

    public void setShortenedClassNameLength(int length) {
        if (length <= 0) {
            throw new IllegalArgumentException();
        }
        this.shortenedClassNameLength = length;
        this.abbreviator = length < Integer.MAX_VALUE ? new CachingAbbreviator(new TargetLengthBasedClassNameAbbreviator(this.shortenedClassNameLength)) : NullAbbreviator.INSTANCE;
    }

    public int getMaxDepthPerThrowable() {
        return this.maxDepthPerThrowable;
    }

    public void setMaxDepthPerThrowable(int maxDepthPerThrowable) {
        if (maxDepthPerThrowable <= 0) {
            throw new IllegalArgumentException();
        }
        this.maxDepthPerThrowable = maxDepthPerThrowable;
    }

    public void setMaxLength(int maxLength) {
        if (maxLength <= 0) {
            throw new IllegalArgumentException();
        }
        this.maxLength = maxLength;
    }

    public int getMaxLength() {
        return this.maxLength;
    }

    public boolean isRootCauseFirst() {
        return this.rootCauseFirst;
    }

    public void setRootCauseFirst(boolean rootCauseFirst) {
        this.rootCauseFirst = rootCauseFirst;
    }

    public void addExclude(String exclusionPattern) {
        this.excludes.add(Pattern.compile(exclusionPattern));
    }

    public void setExcludes(List<String> exclusionPatterns) {
        if (exclusionPatterns == null || exclusionPatterns.isEmpty()) {
            this.excludes = new ArrayList<Pattern>(5);
        } else {
            this.excludes = new ArrayList<Pattern>(exclusionPatterns.size());
            for (String pattern : exclusionPatterns) {
                this.addExclude(pattern);
            }
        }
    }

    public List<String> getExcludes() {
        ArrayList<String> exclusionPatterns = new ArrayList<String>(this.excludes.size());
        for (Pattern pattern : this.excludes) {
            exclusionPatterns.add(pattern.pattern());
        }
        return exclusionPatterns;
    }

    public void addEvaluator(EventEvaluator<ILoggingEvent> evaluator) {
        this.evaluators.add(evaluator);
    }

    public void setEvaluators(List<EventEvaluator<ILoggingEvent>> evaluators) {
        this.evaluators = evaluators == null || evaluators.isEmpty() ? new ArrayList<EventEvaluator<ILoggingEvent>>(1) : new ArrayList<EventEvaluator<ILoggingEvent>>(evaluators);
    }

    public List<EventEvaluator<ILoggingEvent>> getEvaluators() {
        return new ArrayList<EventEvaluator<ILoggingEvent>>(this.evaluators);
    }
}

