/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.predicate;

import io.undertow.predicate.Predicate;
import io.undertow.predicate.PredicateBuilder;
import io.undertow.security.api.SecurityContext;
import io.undertow.server.HttpServerExchange;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class AuthenticationRequiredPredicate
implements Predicate {
    public static final AuthenticationRequiredPredicate INSTANCE = new AuthenticationRequiredPredicate();

    @Override
    public boolean resolve(HttpServerExchange value) {
        SecurityContext sc = value.getSecurityContext();
        if (sc == null) {
            return false;
        }
        return sc.isAuthenticationRequired();
    }

    public static class Builder
    implements PredicateBuilder {
        @Override
        public String name() {
            return "auth-required";
        }

        @Override
        public Map<String, Class<?>> parameters() {
            HashMap params = new HashMap();
            return params;
        }

        @Override
        public Set<String> requiredParameters() {
            HashSet<String> params = new HashSet<String>();
            return params;
        }

        @Override
        public String defaultParameter() {
            return null;
        }

        @Override
        public Predicate build(Map<String, Object> config) {
            return INSTANCE;
        }
    }
}

