/*
 * Decompiled with CFR 0.152.
 */
package org.spincast.website.controllers.demos;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spincast.core.flash.FlashMessageLevel;
import org.spincast.core.request.Form;
import org.spincast.shaded.org.apache.commons.lang3.StringUtils;
import org.spincast.website.exchange.AppRequestContext;

public class DemoHtmlFormsSingleFieldController {
    protected final Logger logger = LoggerFactory.getLogger(DemoHtmlFormsSingleFieldController.class);

    public void singleField(AppRequestContext context) {
        context.response().sendTemplateHtml("/templates/demos/htmlForms/single.html");
    }

    public void singleFieldSubmit(AppRequestContext context) {
        Form form = context.request().getFormOrCreate("demoForm");
        context.response().addForm(form);
        this.validateForm(form);
        boolean process = true;
        if (!form.isValid() || form.getMessages().size() > 0 || "stay@example.com".equals(form.getString("email"))) {
            process = false;
        }
        if (!process) {
            this.singleField(context);
            return;
        }
        context.response().redirect(FlashMessageLevel.SUCCESS, "The form has been processed successfully.");
    }

    protected void validateForm(Form form) {
        String email = form.getString("email");
        if (StringUtils.isBlank(email)) {
            form.addError("email", "email_empty", "The email is required");
        }
        if (form.isValid("email") && !form.validators().isEmailValid(email)) {
            form.addError("email", "email_invalid", "The email is invalid");
        }
        if (form.isValid("email") && email.length() < 8) {
            form.addWarning("email", "email_minLength", "This is valid but seems quite short for an email.");
        }
        if (!form.hasMessages("email") && "success@example.com".equalsIgnoreCase(email)) {
            form.addSuccess("email", "email_good", "This is a success message");
        }
        if (!form.hasMessages("email") && "all@example.com".equalsIgnoreCase(email)) {
            form.addSuccess("email", "email_success", "This is a success message");
            form.addWarning("email", "email_warning", "This is a warning message");
            form.addError("email", "email_error", "This is an error message");
        }
    }
}

