/*
 * Copyright 2011 The Closure Compiler Authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.google.javascript.jscomp.parsing.parser.trees;

/**
 * The types of concrete parse trees.
 *
 * The name of the ParseTreeType must match the name of the class that it applies to.
 * For example the DerivedTree class should use ParseTreeType.DERIVED.
 */
public enum ParseTreeType {
  PROGRAM,
  FUNCTION_DECLARATION,
  BLOCK,
  VARIABLE_STATEMENT,
  VARIABLE_DECLARATION,
  EMPTY_STATEMENT,
  EXPRESSION_STATEMENT,
  IF_STATEMENT,
  DO_WHILE_STATEMENT,
  WHILE_STATEMENT,
  FOR_IN_STATEMENT,
  FOR_STATEMENT,
  VARIABLE_DECLARATION_LIST,
  CONTINUE_STATEMENT,
  BREAK_STATEMENT,
  RETURN_STATEMENT,
  WITH_STATEMENT,
  CASE_CLAUSE,
  DEFAULT_CLAUSE,
  SWITCH_STATEMENT,
  LABELLED_STATEMENT,
  THROW_STATEMENT,
  CATCH,
  TRY_STATEMENT,
  DEBUGGER_STATEMENT,
  THIS_EXPRESSION,
  IDENTIFIER_EXPRESSION,
  LITERAL_EXPRESSION,
  ARRAY_LITERAL_EXPRESSION,
  OBJECT_LITERAL_EXPRESSION,
  COMPREHENSION,
  COMPREHENSION_IF,
  COMPREHENSION_FOR,
  GET_ACCESSOR,
  SET_ACCESSOR,
  PROPERTY_NAME_ASSIGNMENT,
  COMPUTED_PROPERTY_DEFINITION,
  COMPUTED_PROPERTY_GETTER,
  COMPUTED_PROPERTY_METHOD,
  COMPUTED_PROPERTY_SETTER,
  MISSING_PRIMARY_EXPRESSION,
  COMMA_EXPRESSION,
  BINARY_OPERATOR,
  CONDITIONAL_EXPRESSION,
  UNARY_EXPRESSION,
  UPDATE_EXPRESSION,
  MEMBER_EXPRESSION,
  NEW_EXPRESSION,
  ARGUMENT_LIST,
  CALL_EXPRESSION,
  CLASS_DECLARATION,
  INTERFACE_DECLARATION,
  NAMESPACE_DECLARATION,
  NAMESPACE_NAME,
  ENUM_DECLARATION,
  MEMBER_LOOKUP_EXPRESSION,
  PAREN_EXPRESSION,
  FINALLY,
  SUPER_EXPRESSION,
  ARRAY_PATTERN,
  ASSIGNMENT_REST_ELEMENT,
  OBJECT_PATTERN,
  FORMAL_PARAMETER_LIST,
  SPREAD_EXPRESSION,
  NULL,
  REST_PARAMETER,
  MODULE_IMPORT,
  EXPORT_DECLARATION,
  EXPORT_SPECIFIER,
  IMPORT_DECLARATION,
  IMPORT_SPECIFIER,
  FOR_OF_STATEMENT,
  FOR_AWAIT_OF_STATEMENT,
  YIELD_EXPRESSION,
  DEFAULT_PARAMETER,
  TEMPLATE_LITERAL_EXPRESSION,
  TEMPLATE_LITERAL_PORTION,
  TEMPLATE_SUBSTITUTION,
  TYPE_NAME,
  TYPE_QUERY,
  TYPED_PARAMETER,
  OPTIONAL_PARAMETER,
  PARAMETERIZED_TYPE_TREE,
  ARRAY_TYPE,
  RECORD_TYPE,
  UNION_TYPE,
  FUNCTION_TYPE,
  GENERIC_TYPE_LIST,
  MEMBER_VARIABLE,
  COMPUTED_PROPERTY_MEMBER_VARIABLE,
  TYPE_ALIAS,
  AMBIENT_DECLARATION,
  INDEX_SIGNATURE,
  CALL_SIGNATURE,
  NEW_TARGET_EXPRESSION,
  AWAIT_EXPRESSION,
  DYNAMIC_IMPORT_EXPRESSION,
}
