/*
 * Decompiled with CFR 0.152.
 */
package org.spincast.website.services;

import com.google.inject.Inject;
import java.util.List;
import org.spincast.website.AppConfig;
import org.spincast.website.models.NewsEntriesAndTotalNbr;
import org.spincast.website.models.NewsEntry;
import org.spincast.website.repositories.NewsRepository;
import org.spincast.website.services.NewsService;

public class NewsServiceDefault
implements NewsService {
    private final NewsRepository newsRepository;
    private final AppConfig appConfig;

    @Inject
    public NewsServiceDefault(NewsRepository newsRepository, AppConfig appConfig) {
        this.newsRepository = newsRepository;
        this.appConfig = appConfig;
    }

    protected NewsRepository getNewsRepository() {
        return this.newsRepository;
    }

    protected AppConfig getAppConfig() {
        return this.appConfig;
    }

    @Override
    public List<NewsEntry> getNewsEntries(boolean ascOrder) {
        return this.getNewsRepository().getNewsEntries(ascOrder);
    }

    @Override
    public NewsEntriesAndTotalNbr getNewsEntries(int startPos, int endPos, boolean ascOrder) {
        return this.getNewsRepository().getNewsEntriesAndTotalNbr(startPos, endPos, ascOrder);
    }

    @Override
    public NewsEntry getNewsEntry(long newsId) {
        return this.getNewsRepository().getNewsEntry(newsId);
    }

    @Override
    public List<NewsEntry> getFeedNewsEntries() {
        int nbrNewsEntriesPerFeedRequest;
        int newsEntriesTotalNumber = this.getNewsRepository().getNewsEntriesTotalNumber();
        int startPos = newsEntriesTotalNumber - (nbrNewsEntriesPerFeedRequest = this.getAppConfig().getNbrNewsEntriesPerFeedRequest()) + 1;
        if (startPos < 1) {
            startPos = 1;
        }
        return this.getNewsRepository().getNewsEntries(startPos, newsEntriesTotalNumber, true);
    }
}

