/*
 * Decompiled with CFR 0.152.
 */
package org.spokbjorn.lazy;

import java.io.Serializable;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Lazy<T>
implements Supplier<T>,
Comparable<T>,
Serializable {
    @NotNull
    private final Supplier<T> lazySupplier;
    @Nullable
    private T value;

    @Contract(value="_ -> new", pure=true)
    @NotNull
    public static <T> Lazy<T> of(@NotNull Supplier<T> supplier) {
        Objects.requireNonNull(supplier);
        return new Lazy<T>(supplier);
    }

    @Contract(value="_ -> new")
    @NotNull
    public static <T> Lazy<T> lazy(@NotNull Supplier<T> supplier) {
        return Lazy.of(supplier);
    }

    private Lazy(@NotNull Supplier<T> lazySupplier) {
        Objects.requireNonNull(lazySupplier);
        this.lazySupplier = lazySupplier;
    }

    @Override
    public T get() {
        if (Objects.isNull(this.value)) {
            this.value = this.lazySupplier.get();
        }
        return this.value;
    }

    public <R> Lazy<R> map(Function<? super T, ? extends R> function) {
        Objects.requireNonNull(function);
        return Lazy.of(() -> function.apply((T)this.get()));
    }

    public boolean same(@Nullable Lazy<T> other) {
        return Objects.nonNull(other) && Objects.equals(this.get(), other.get());
    }

    public boolean same(@Nullable Object other) {
        return Objects.equals(this.get(), other);
    }

    @Override
    public int compareTo(@NotNull T o) {
        if (o instanceof Comparable) {
            return ((Comparable)o).compareTo(this.get());
        }
        return 0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Lazy lazy = (Lazy)o;
        return Objects.equals(this.lazySupplier, lazy.lazySupplier) && Objects.equals(this.value, lazy.value);
    }

    public int hashCode() {
        return Objects.hash(this.lazySupplier, this.value);
    }

    public String toString() {
        return String.valueOf(this.get());
    }
}

