/*
 * Decompiled with CFR 0.152.
 */
package org.spokbjorn.tuple;

import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Unmodifiable;
import org.spokbjorn.tuple.Duad;
import org.spokbjorn.tuple.Heptad;
import org.spokbjorn.tuple.Hexad;
import org.spokbjorn.tuple.Monad;
import org.spokbjorn.tuple.Octad;
import org.spokbjorn.tuple.Pentad;
import org.spokbjorn.tuple.Quad;
import org.spokbjorn.tuple.Triad;
import org.spokbjorn.tuple.Unit;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface Tuple {
    public static <T> @Unmodifiable @NotNull List<? super T> asList(@NotNull Tuple tuple) {
        if (tuple instanceof Monad) {
            Monad monad = (Monad)tuple;
            return Tuple.asList(monad);
        }
        if (tuple instanceof Duad) {
            Duad duad = (Duad)tuple;
            return Tuple.asList(duad);
        }
        if (tuple instanceof Heptad) {
            Heptad heptad = (Heptad)tuple;
            return Tuple.asList(heptad);
        }
        if (tuple instanceof Hexad) {
            Hexad hexad = (Hexad)tuple;
            return Tuple.asList(hexad);
        }
        if (tuple instanceof Octad) {
            Octad octad = (Octad)tuple;
            return Tuple.asList(octad);
        }
        if (tuple instanceof Pentad) {
            Pentad pentad = (Pentad)tuple;
            return Tuple.asList(pentad);
        }
        if (tuple instanceof Quad) {
            Quad quad = (Quad)tuple;
            return Tuple.asList(quad);
        }
        if (tuple instanceof Triad) {
            Triad triad = (Triad)tuple;
            return Tuple.asList(triad);
        }
        if (tuple instanceof Unit) {
            return Collections.emptyList();
        }
        throw new IllegalArgumentException();
    }

    @Contract(pure=true)
    public static <T> @Unmodifiable @NotNull List<T> asList(@NotNull Unit unit) {
        return Collections.emptyList();
    }

    public static <T> @Unmodifiable @NotNull List<T> asList(@NotNull Monad<? extends T> monad) {
        return List.of(monad.first());
    }

    public static <T> @Unmodifiable @NotNull List<T> asList(@NotNull Duad<? extends T, ? extends T> duad) {
        return List.of(duad.first(), duad.second());
    }

    public static <T> @Unmodifiable @NotNull List<T> asList(@NotNull Triad<? extends T, ? extends T, ? extends T> triad) {
        return List.of(triad.first(), triad.second(), triad.third());
    }

    public static <T> @Unmodifiable @NotNull List<T> asList(@NotNull Quad<? extends T, ? extends T, ? extends T, ? extends T> quad) {
        return List.of(quad.first(), quad.second(), quad.third(), quad.fourth());
    }

    public static <T> @Unmodifiable @NotNull List<T> asList(@NotNull Pentad<? extends T, ? extends T, ? extends T, ? extends T, ? extends T> pentad) {
        return List.of(pentad.first(), pentad.second(), pentad.third(), pentad.fourth(), pentad.fifth());
    }

    public static <T> @Unmodifiable @NotNull List<T> asList(@NotNull Hexad<? extends T, ? extends T, ? extends T, ? extends T, ? extends T, ? extends T> hexad) {
        return List.of(hexad.first(), hexad.second(), hexad.third(), hexad.fourth(), hexad.fifth(), hexad.sixth());
    }

    public static <T> @Unmodifiable @NotNull List<T> asList(@NotNull Heptad<? extends T, ? extends T, ? extends T, ? extends T, ? extends T, ? extends T, ? extends T> heptad) {
        return List.of(heptad.first(), heptad.second(), heptad.third(), heptad.fourth(), heptad.fifth(), heptad.sixth(), heptad.seventh());
    }

    public static <T> @Unmodifiable @NotNull List<T> asList(@NotNull Octad<? extends T, ? extends T, ? extends T, ? extends T, ? extends T, ? extends T, ? extends T, ? extends T> octad) {
        return List.of(octad.first(), octad.second(), octad.third(), octad.fourth(), octad.fifth(), octad.sixth(), octad.seventh(), octad.eighth());
    }

    @Contract(value=" -> new")
    @NotNull
    public static Unit empty() {
        return new Unit();
    }

    @Contract(value="_ -> new")
    @NotNull
    public static <T> Monad<T> of(T first) {
        return new Monad<T>(first);
    }

    @Contract(value="_, _ -> new")
    @NotNull
    public static <T, U> Duad<T, U> of(T first, U second) {
        return new Duad<T, U>(first, second);
    }

    @Contract(value="_, _, _ -> new")
    @NotNull
    public static <T, U, V> Triad<T, U, V> of(T first, U second, V third) {
        return new Triad<T, U, V>(first, second, third);
    }

    @Contract(value="_, _, _, _ -> new")
    @NotNull
    public static <T, U, V, W> Quad<T, U, V, W> of(T first, U second, V third, W fourth) {
        return new Quad<T, U, V, W>(first, second, third, fourth);
    }

    @Contract(value="_, _, _, _, _ -> new")
    @NotNull
    public static <T, U, V, W, X> Pentad<T, U, V, W, X> of(T first, U second, V third, W fourth, X fifth) {
        return new Pentad<T, U, V, W, X>(first, second, third, fourth, fifth);
    }

    @Contract(value="_, _, _, _, _, _ -> new")
    @NotNull
    public static <T, U, V, W, X, Y> Hexad<T, U, V, W, X, Y> of(T first, U second, V third, W fourth, X fifth, Y sixth) {
        return new Hexad<T, U, V, W, X, Y>(first, second, third, fourth, fifth, sixth);
    }

    @Contract(value="_, _, _, _, _, _, _ -> new")
    @NotNull
    public static <T, U, V, W, X, Y, Z> Heptad<T, U, V, W, X, Y, Z> of(T first, U second, V third, W fourth, X fifth, Y sixth, Z seventh) {
        return new Heptad<T, U, V, W, X, Y, Z>(first, second, third, fourth, fifth, sixth, seventh);
    }

    @Contract(value="_, _, _, _, _, _, _, _ -> new")
    @NotNull
    public static <T, U, V, W, X, Y, Z, A> Octad<T, U, V, W, X, Y, Z, A> of(T first, U second, V third, W fourth, X fifth, Y sixth, Z seventh, A eighth) {
        return new Octad<T, U, V, W, X, Y, Z, A>(first, second, third, fourth, fifth, sixth, seventh, eighth);
    }
}

