/*
 * Decompiled with CFR 0.152.
 */
package ninja.leaping.configurate.json;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.PrettyPrinter;
import com.google.common.collect.ImmutableSet;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ninja.leaping.configurate.ConfigurationNode;
import ninja.leaping.configurate.ConfigurationOptions;
import ninja.leaping.configurate.ConfigurationVisitor;
import ninja.leaping.configurate.commented.CommentedConfigurationNode;
import ninja.leaping.configurate.json.ConfiguratePrettyPrinter;
import ninja.leaping.configurate.json.FieldValueSeparatorStyle;
import ninja.leaping.configurate.json.JacksonVisitor;
import ninja.leaping.configurate.loader.AbstractConfigurationLoader;
import ninja.leaping.configurate.loader.CommentHandler;
import ninja.leaping.configurate.loader.CommentHandlers;
import org.checkerframework.checker.nullness.qual.NonNull;

public class JSONConfigurationLoader
extends AbstractConfigurationLoader<ConfigurationNode> {
    private final JsonFactory factory;
    private final int indent;
    private final FieldValueSeparatorStyle fieldValueSeparatorStyle;

    public static @NonNull Builder builder() {
        return new Builder();
    }

    private JSONConfigurationLoader(Builder builder) {
        super((AbstractConfigurationLoader.Builder)builder, new CommentHandler[]{CommentHandlers.DOUBLE_SLASH, CommentHandlers.SLASH_BLOCK, CommentHandlers.HASH});
        this.factory = builder.getFactory();
        this.indent = builder.getIndent();
        this.fieldValueSeparatorStyle = builder.getFieldValueSeparatorStyle();
    }

    protected void loadInternal(ConfigurationNode node, BufferedReader reader) throws IOException {
        try (JsonParser parser = this.factory.createParser((Reader)reader);){
            parser.nextToken();
            JSONConfigurationLoader.parseValue(parser, node);
        }
    }

    private static void parseValue(JsonParser parser, ConfigurationNode node) throws IOException {
        JsonToken token = parser.getCurrentToken();
        switch (token) {
            case START_OBJECT: {
                JSONConfigurationLoader.parseObject(parser, node);
                break;
            }
            case START_ARRAY: {
                JSONConfigurationLoader.parseArray(parser, node);
                break;
            }
            case VALUE_NUMBER_FLOAT: {
                double doubleVal = parser.getDoubleValue();
                if ((double)((float)doubleVal) != doubleVal) {
                    node.setValue((Object)parser.getDoubleValue());
                    break;
                }
                node.setValue((Object)Float.valueOf(parser.getFloatValue()));
                break;
            }
            case VALUE_NUMBER_INT: {
                long longVal = parser.getLongValue();
                if ((long)((int)longVal) != longVal) {
                    node.setValue((Object)parser.getLongValue());
                    break;
                }
                node.setValue((Object)parser.getIntValue());
                break;
            }
            case VALUE_STRING: {
                node.setValue((Object)parser.getText());
                break;
            }
            case VALUE_TRUE: 
            case VALUE_FALSE: {
                node.setValue((Object)parser.getBooleanValue());
                break;
            }
            case VALUE_NULL: 
            case FIELD_NAME: {
                break;
            }
            default: {
                throw new IOException("Unsupported token type: " + token + " (at " + parser.getTokenLocation() + ")");
            }
        }
    }

    private static void parseArray(JsonParser parser, ConfigurationNode node) throws IOException {
        JsonToken token;
        while ((token = parser.nextToken()) != null) {
            switch (token) {
                case END_ARRAY: {
                    return;
                }
            }
            JSONConfigurationLoader.parseValue(parser, node.appendListNode());
        }
        throw new JsonParseException(parser, "Reached end of stream with unclosed array!", parser.getCurrentLocation());
    }

    private static void parseObject(JsonParser parser, ConfigurationNode node) throws IOException {
        JsonToken token;
        while ((token = parser.nextToken()) != null) {
            switch (token) {
                case END_OBJECT: {
                    return;
                }
            }
            JSONConfigurationLoader.parseValue(parser, node.getNode(new Object[]{parser.getCurrentName()}));
        }
        throw new JsonParseException(parser, "Reached end of stream with unclosed array!", parser.getCurrentLocation());
    }

    public void saveInternal(ConfigurationNode node, Writer writer) throws IOException {
        try (JsonGenerator generator = this.factory.createGenerator(writer);){
            generator.setPrettyPrinter((PrettyPrinter)new ConfiguratePrettyPrinter(this.indent, this.fieldValueSeparatorStyle));
            node.visit((ConfigurationVisitor)JacksonVisitor.INSTANCE, (Object)generator);
            writer.write(SYSTEM_LINE_SEPARATOR);
        }
    }

    public @NonNull CommentedConfigurationNode createEmptyNode(@NonNull ConfigurationOptions options) {
        options = options.withNativeTypes((Set)ImmutableSet.of(Map.class, List.class, Double.class, Float.class, Long.class, Integer.class, (Object[])new Class[]{Boolean.class, String.class, byte[].class}));
        return CommentedConfigurationNode.root((ConfigurationOptions)options);
    }

    public static class Builder
    extends AbstractConfigurationLoader.Builder<Builder> {
        private final JsonFactory factory = new JsonFactory();
        private int indent = 2;
        private FieldValueSeparatorStyle fieldValueSeparatorStyle = FieldValueSeparatorStyle.SPACE_AFTER;

        protected Builder() {
            this.factory.disable(JsonParser.Feature.AUTO_CLOSE_SOURCE);
            this.factory.enable(JsonParser.Feature.ALLOW_COMMENTS);
            this.factory.enable(JsonParser.Feature.ALLOW_YAML_COMMENTS);
            this.factory.enable(JsonParser.Feature.ALLOW_BACKSLASH_ESCAPING_ANY_CHARACTER);
            this.factory.enable(JsonParser.Feature.ALLOW_UNQUOTED_FIELD_NAMES);
            this.factory.enable(JsonParser.Feature.ALLOW_SINGLE_QUOTES);
            this.factory.enable(JsonParser.Feature.ALLOW_NON_NUMERIC_NUMBERS);
            this.factory.enable(JsonParser.Feature.ALLOW_UNQUOTED_CONTROL_CHARS);
        }

        public @NonNull JsonFactory getFactory() {
            return this.factory;
        }

        public @NonNull Builder setIndent(int indent) {
            this.indent = indent;
            return this;
        }

        public int getIndent() {
            return this.indent;
        }

        public @NonNull Builder setFieldValueSeparatorStyle(@NonNull FieldValueSeparatorStyle style) {
            this.fieldValueSeparatorStyle = style;
            return this;
        }

        public @NonNull FieldValueSeparatorStyle getFieldValueSeparatorStyle() {
            return this.fieldValueSeparatorStyle;
        }

        public @NonNull JSONConfigurationLoader build() {
            return new JSONConfigurationLoader(this);
        }
    }
}

