/*
 * Decompiled with CFR 0.152.
 */
package ninja.leaping.configurate.json;

import com.fasterxml.jackson.core.JsonGenerator;
import java.io.IOException;
import java.util.Objects;
import ninja.leaping.configurate.ConfigurationNode;
import ninja.leaping.configurate.ConfigurationVisitor;
import org.checkerframework.checker.nullness.qual.Nullable;

class JacksonVisitor
implements ConfigurationVisitor<JsonGenerator, Void, IOException> {
    static JacksonVisitor INSTANCE = new JacksonVisitor();

    JacksonVisitor() {
    }

    public JsonGenerator newState() {
        throw new UnsupportedOperationException("Generator must be provided");
    }

    public void beginVisit(ConfigurationNode node, JsonGenerator state) throws IOException {
    }

    public void enterNode(ConfigurationNode node, JsonGenerator generator) throws IOException {
        @Nullable ConfigurationNode parent = node.getParent();
        if (parent != null && parent.isMap()) {
            generator.writeFieldName(Objects.requireNonNull(node.getKey(), "Node must have key to be a value in a mapping").toString());
        }
    }

    public void enterMappingNode(ConfigurationNode node, JsonGenerator state) throws IOException {
        state.writeStartObject();
    }

    public void enterListNode(ConfigurationNode node, JsonGenerator state) throws IOException {
        state.writeStartArray();
    }

    public void enterScalarNode(ConfigurationNode node, JsonGenerator generator) throws IOException {
        Object value = node.getValue();
        if (value instanceof Double) {
            generator.writeNumber(((Double)value).doubleValue());
        } else if (value instanceof Float) {
            generator.writeNumber(((Float)value).floatValue());
        } else if (value instanceof Long) {
            generator.writeNumber(((Long)value).longValue());
        } else if (value instanceof Integer) {
            generator.writeNumber(((Integer)value).intValue());
        } else if (value instanceof Boolean) {
            generator.writeBoolean(((Boolean)value).booleanValue());
        } else if (value instanceof byte[]) {
            generator.writeBinary((byte[])value);
        } else {
            generator.writeString(value.toString());
        }
    }

    public void exitMappingNode(ConfigurationNode node, JsonGenerator state) throws IOException {
        state.writeEndObject();
    }

    public void exitListNode(ConfigurationNode node, JsonGenerator state) throws IOException {
        state.writeEndArray();
    }

    public Void endVisit(JsonGenerator state) throws IOException {
        state.flush();
        return null;
    }
}

