/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.eventimplgen;

import java.lang.annotation.Annotation;
import java.util.ArrayDeque;
import java.util.Map;
import java.util.Set;
import javax.lang.model.AnnotatedConstruct;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.eventgen.annotations.ImplementedBy;

public final class AnnotationUtils {
    private AnnotationUtils() {
    }

    public static <T> T getValue(AnnotationMirror anno, String key) {
        if (anno == null) {
            return null;
        }
        for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> element : anno.getElementValues().entrySet()) {
            if (!element.getKey().getSimpleName().contentEquals(key)) continue;
            return (T)element.getValue().getValue();
        }
        return null;
    }

    @Nullable
    public static AnnotationMirror getAnnotation(AnnotatedConstruct type, Class<? extends Annotation> clazz) {
        return AnnotationUtils.getAnnotation(type, clazz.getName());
    }

    @Nullable
    public static DeclaredType getImplementedBy(TypeElement iface) {
        TypeElement scannedType;
        ArrayDeque<TypeElement> queue = new ArrayDeque<TypeElement>();
        AnnotationMirror implementedBy = null;
        int max = Integer.MIN_VALUE;
        queue.add(iface);
        while ((scannedType = (TypeElement)queue.poll()) != null) {
            AnnotationMirror anno = AnnotationUtils.getAnnotation((AnnotatedConstruct)scannedType, ImplementedBy.class);
            Integer priority = (Integer)AnnotationUtils.getValue(anno, "priority");
            if (priority == null) {
                priority = 1;
            }
            if (anno != null && priority >= max) {
                implementedBy = anno;
                max = priority;
            }
            for (TypeMirror typeMirror : scannedType.getInterfaces()) {
                Element element;
                if (typeMirror.getKind() != TypeKind.DECLARED || (element = ((DeclaredType)typeMirror).asElement()) == null || !element.getKind().isInterface()) continue;
                queue.offer((TypeElement)element);
            }
        }
        if (implementedBy != null) {
            TypeMirror type = (TypeMirror)AnnotationUtils.getValue(implementedBy, "value");
            if (type.getKind() == TypeKind.ERROR) {
                return null;
            }
            return (DeclaredType)type;
        }
        return null;
    }

    @Nullable
    public static AnnotationMirror getAnnotation(AnnotatedConstruct type, String name) {
        for (AnnotationMirror annotationMirror : type.getAnnotationMirrors()) {
            if (!((TypeElement)annotationMirror.getAnnotationType().asElement()).getQualifiedName().toString().equals(name)) continue;
            return annotationMirror;
        }
        return null;
    }

    public static boolean containsAnnotation(AnnotatedConstruct type, Set<String> looking) {
        for (AnnotationMirror annotationMirror : type.getAnnotationMirrors()) {
            if (!looking.contains(((TypeElement)annotationMirror.getAnnotationType().asElement()).getQualifiedName().toString())) continue;
            return true;
        }
        return false;
    }
}

