/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.eventimplgen.eventgencore;

import dagger.assisted.Assisted;
import dagger.assisted.AssistedFactory;
import dagger.assisted.AssistedInject;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.eventimplgen.AnnotationUtils;
import org.spongepowered.eventimplgen.eventgencore.Property;
import org.spongepowered.eventimplgen.eventgencore.PropertySearchStrategy;
import org.spongepowered.eventimplgen.signature.Descriptors;

public class AccessorFirstStrategy
implements PropertySearchStrategy {
    private static final Pattern ACCESSOR = Pattern.compile("^get([A-Z].*)");
    private static final Pattern ACCESSOR_BOOL = Pattern.compile("^is([A-Z].*)");
    private static final Pattern ACCESSOR_HAS = Pattern.compile("^has([A-Z].*)");
    private static final Pattern ACCESSOR_KEEPS = Pattern.compile("^(keeps[A-Z].*)");
    private static final Pattern MUTATOR = Pattern.compile("^set([A-Z].*)");
    private final Descriptors descriptors;
    private final Types types;
    private final boolean allowFluentStyle;
    private final TypeElement optional;

    @AssistedInject
    public AccessorFirstStrategy(Types types, Elements elements, Descriptors descriptors, @Assisted boolean allowFluentStyle) {
        this.types = types;
        this.descriptors = descriptors;
        this.allowFluentStyle = allowFluentStyle;
        this.optional = elements.getTypeElement("java.util.Optional");
    }

    private String getAccessorName(ExecutableElement method) {
        if (this.isPublic(method) && method.getParameters().isEmpty()) {
            Name methodName = method.getSimpleName();
            TypeMirror returnType = method.getReturnType();
            if (returnType.getKind() == TypeKind.VOID) {
                return null;
            }
            Matcher m = ACCESSOR.matcher(methodName);
            if (m.matches()) {
                return AccessorFirstStrategy.getPropertyName(m.group(1));
            }
            m = ACCESSOR_BOOL.matcher(methodName);
            if (m.matches() && returnType.getKind() == TypeKind.BOOLEAN) {
                return AccessorFirstStrategy.getPropertyName(m.group(1));
            }
            m = ACCESSOR_KEEPS.matcher(methodName);
            if (m.matches() && returnType.getKind() == TypeKind.BOOLEAN) {
                return AccessorFirstStrategy.getPropertyName(m.group(1));
            }
            m = ACCESSOR_HAS.matcher(methodName);
            if (m.matches() && returnType.getKind() == TypeKind.BOOLEAN) {
                return AccessorFirstStrategy.getPropertyName(methodName);
            }
            if (this.allowFluentStyle) {
                return methodName.toString();
            }
        }
        return null;
    }

    @Nullable
    private String getMutatorName(ExecutableElement method) {
        if (this.isPublic(method) && method.getParameters().size() == 1 && method.getReturnType().getKind() == TypeKind.VOID) {
            Matcher m = MUTATOR.matcher(method.getSimpleName());
            if (m.matches()) {
                return AccessorFirstStrategy.getPropertyName(m.group(1));
            }
            if (this.allowFluentStyle) {
                return method.getSimpleName().toString();
            }
        }
        return null;
    }

    private boolean isPublic(ExecutableElement method) {
        Set<Modifier> modifiers = method.getModifiers();
        return modifiers.contains((Object)Modifier.PUBLIC) || !modifiers.contains((Object)Modifier.PROTECTED) && !modifiers.contains((Object)Modifier.PRIVATE);
    }

    public static String getPropertyName(CharSequence name) {
        return Character.toLowerCase(name.charAt(0)) + name.subSequence(1, name.length()).toString();
    }

    @Nullable
    protected ExecutableElement findMutator(ExecutableElement accessor, @Nullable Collection<ExecutableElement> candidates, DeclaredType implementedBy) {
        if (candidates == null) {
            return null;
        }
        TypeMirror expectedType = accessor.getReturnType();
        boolean isOptionalReturn = expectedType.getKind() == TypeKind.DECLARED && this.types.isAssignable(this.types.erasure(expectedType), this.optional.asType());
        for (ExecutableElement method : candidates) {
            ExecutableElement candidate;
            if (implementedBy != null) {
                for (Element element : implementedBy.asElement().getEnclosedElements()) {
                    ExecutableElement ee;
                    if (!(element instanceof ExecutableElement) || this.isMatchingMutator(ee = (ExecutableElement)element, isOptionalReturn, expectedType) == null) continue;
                    return null;
                }
            }
            if ((candidate = this.isMatchingMutator(method, isOptionalReturn, expectedType)) == null) continue;
            return candidate;
        }
        return null;
    }

    @Nullable
    private ExecutableElement isMatchingMutator(ExecutableElement method, boolean optionalReturn, TypeMirror expectedType) {
        if (method.getParameters().isEmpty()) {
            return null;
        }
        TypeMirror firstParam = method.getParameters().get(0).asType();
        if (this.types.isSameType(firstParam, expectedType)) {
            return method;
        }
        if (optionalReturn && this.types.isSameType(firstParam, ((DeclaredType)expectedType).getTypeArguments().get(0))) {
            return method;
        }
        return null;
    }

    @Override
    public List<Property> findProperties(TypeElement type) {
        Objects.requireNonNull(type, "type");
        HashMap<String, Set> accessors = new HashMap<String, Set>();
        HashMap<String, Set> mutators = new HashMap<String, Set>();
        HashMap<String, ExecutableElement> accessorHierarchyBottoms = new HashMap<String, ExecutableElement>();
        HashMap<String, ExecutableElement> mostSpecific = new HashMap<String, ExecutableElement>();
        HashSet<String> signatures = new HashSet<String>();
        ArrayDeque<TypeElement> queue = new ArrayDeque<TypeElement>();
        queue.push(type);
        while (!queue.isEmpty()) {
            TypeElement ourType = (TypeElement)queue.pop();
            for (Element element : ourType.getEnclosedElements()) {
                ExecutableElement leastSpecificMethod;
                if (element.getKind() != ElementKind.METHOD) continue;
                ExecutableElement method = (ExecutableElement)element;
                StringBuilder signature = new StringBuilder(String.valueOf(method.getSimpleName()) + ";");
                signature.append(this.descriptors.getDescriptor(method));
                String name = this.getAccessorName(method);
                if (!(name == null || signatures.contains(signature.toString()) || (leastSpecificMethod = (ExecutableElement)accessorHierarchyBottoms.get(name)) != null && this.types.isSameType(leastSpecificMethod.getReturnType(), method.getReturnType()))) {
                    accessors.computeIfAbsent(name, $ -> new HashSet()).add(method);
                    signatures.add(signature.toString());
                    if (!mostSpecific.containsKey(name) || this.types.isSubtype(method.getReturnType(), ((ExecutableElement)mostSpecific.get(name)).getReturnType())) {
                        mostSpecific.put(name, method);
                    }
                    if (accessorHierarchyBottoms.get(name) != null && !this.types.isSubtype(((ExecutableElement)accessorHierarchyBottoms.get(name)).getReturnType(), method.getReturnType())) continue;
                    accessorHierarchyBottoms.put(name, method);
                    continue;
                }
                name = this.getMutatorName(method);
                if (name == null) continue;
                mutators.computeIfAbsent(name, $ -> new HashSet()).add(method);
            }
            if (ourType.getSuperclass().getKind() != TypeKind.NONE) {
                queue.push((TypeElement)this.types.asElement(ourType.getSuperclass()));
            }
            for (TypeMirror typeMirror : ourType.getInterfaces()) {
                queue.push((TypeElement)this.types.asElement(typeMirror));
            }
        }
        ArrayList<Property> result = new ArrayList<Property>();
        for (Map.Entry entry : accessors.entrySet()) {
            for (ExecutableElement accessor : (Set)entry.getValue()) {
                ExecutableType relativizedAccessor = (ExecutableType)this.types.asMemberOf((DeclaredType)type.asType(), accessor);
                @Nullable DeclaredType implementedBy = AnnotationUtils.getImplementedBy(type);
                @Nullable ExecutableElement mutator = this.findMutator(accessor, (Collection)mutators.get(entry.getKey()), implementedBy);
                result.add(new Property((String)entry.getKey(), relativizedAccessor.getReturnType(), (ExecutableElement)accessorHierarchyBottoms.get(entry.getKey()), (ExecutableElement)mostSpecific.get(entry.getKey()), accessor, mutator));
            }
        }
        result.sort(Comparator.comparing(Property::getName));
        return Collections.unmodifiableList(result);
    }

    @AssistedFactory
    public static interface Factory {
        public AccessorFirstStrategy create(boolean var1);
    }
}

