/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.eventimplgen.eventgencore;

import java.util.Objects;
import java.util.Optional;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Types;
import org.jetbrains.annotations.Nullable;

public final class Property
implements Comparable<Property> {
    private final String name;
    private final TypeMirror type;
    private final ExecutableElement leastSpecificMethod;
    private final ExecutableElement mostSpecificMethod;
    private final ExecutableElement accessor;
    private final Optional<ExecutableElement> mutator;

    public Property(String name, TypeMirror type, ExecutableElement leastSpecificMethod, ExecutableElement mostSpecificMethod, ExecutableElement accessor, @Nullable ExecutableElement mutator) {
        this.name = Objects.requireNonNull(name, "name");
        this.type = Objects.requireNonNull(type, "type");
        this.leastSpecificMethod = Objects.requireNonNull(leastSpecificMethod, "leastSpecificMethod");
        this.mostSpecificMethod = Objects.requireNonNull(mostSpecificMethod, "mostSpecificMethod");
        this.accessor = Objects.requireNonNull(accessor, "accessor");
        this.mutator = Optional.ofNullable(mutator);
    }

    public String getName() {
        return this.name;
    }

    public TypeMirror getType() {
        return this.type;
    }

    public TypeMirror getWrapperType() {
        return this.type;
    }

    public ExecutableElement getLeastSpecificMethod() {
        return this.leastSpecificMethod;
    }

    public TypeMirror getLeastSpecificType() {
        return this.leastSpecificMethod.getReturnType();
    }

    public ExecutableElement getMostSpecificMethod() {
        return this.mostSpecificMethod;
    }

    public TypeMirror getMostSpecificType() {
        return this.mostSpecificMethod.getReturnType();
    }

    public ExecutableElement getAccessor() {
        return this.accessor;
    }

    public ExecutableElement getAccessorWrapper() {
        return this.accessor;
    }

    public Optional<ExecutableElement> getMutator() {
        return this.mutator;
    }

    public boolean isLeastSpecificType(Types types) {
        return types.isSameType(this.accessor.asType(), this.leastSpecificMethod.asType());
    }

    public boolean isMostSpecificType(Types types) {
        return types.isSameType(this.accessor.asType(), this.mostSpecificMethod.asType());
    }

    @Override
    public int compareTo(Property other) {
        return this.getName().compareTo(other.getName());
    }
}

