/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.eventimplgen.eventgencore;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.lang.model.util.Types;
import org.spongepowered.eventgen.annotations.AbsoluteSortPosition;
import org.spongepowered.eventimplgen.eventgencore.AccessorFirstStrategy;
import org.spongepowered.eventimplgen.eventgencore.Property;
import org.spongepowered.eventimplgen.processor.EventGenOptions;

public class PropertySorter {
    private final String prefix;
    private final Map<String, String> groupingPrefixes;
    private final Types types;

    @Inject
    PropertySorter(Types types, EventGenOptions options) {
        this(types, options.sortPriorityPrefix(), options.groupingPrefixes());
    }

    public PropertySorter(Types types, String prefix, Map<String, String> groupingPrefixes) {
        this.types = types;
        this.prefix = prefix;
        this.groupingPrefixes = groupingPrefixes;
    }

    public List<Property> sortProperties(Collection<Property> properties) {
        String name;
        ArrayList<Property> finalProperties = new ArrayList<Property>();
        HashMap propertyMap = new HashMap();
        ArrayList<PrefixPair> pairs = new ArrayList<PrefixPair>();
        ArrayList<Property> primitiveProperties = new ArrayList<Property>();
        properties.stream().filter(prop -> prop.isMostSpecificType(this.types)).forEach(property -> {
            propertyMap.put(property.getName(), property);
            AbsoluteSortPosition sortPosition = property.getAccessor().getAnnotation(AbsoluteSortPosition.class);
            if (sortPosition != null) {
                finalProperties.add(Math.min(sortPosition.value(), finalProperties.size()), (Property)property);
                propertyMap.remove(property.getName());
            }
        });
        for (Map.Entry entry : new HashSet(propertyMap.entrySet())) {
            name = ((Property)entry.getValue()).getName();
            String unprefixedName = this.getUnprefixedName(name);
            if (!name.startsWith(this.prefix) || !propertyMap.containsKey(unprefixedName)) continue;
            pairs.add(new PrefixPair((Property)entry.getValue(), (Property)propertyMap.get(unprefixedName)));
            propertyMap.remove(name);
            propertyMap.remove(unprefixedName);
        }
        block1: for (Map.Entry entry : new HashSet(propertyMap.entrySet())) {
            name = (String)entry.getKey();
            Property property2 = (Property)entry.getValue();
            if (property2.getWrapperType().getKind().isPrimitive()) {
                primitiveProperties.add(property2);
                propertyMap.remove(name);
                continue;
            }
            for (Map.Entry<String, String> prefixEntry : this.groupingPrefixes.entrySet()) {
                String modifiedName;
                if (!name.startsWith(prefixEntry.getKey()) || !propertyMap.containsKey(modifiedName = name.replaceFirst(prefixEntry.getKey(), prefixEntry.getValue()))) continue;
                pairs.add(new PrefixPair((Property)entry.getValue(), (Property)propertyMap.get(modifiedName)));
                propertyMap.remove(name);
                propertyMap.remove(modifiedName);
                continue block1;
            }
        }
        Collections.sort(pairs);
        for (PrefixPair pair : pairs) {
            finalProperties.add(pair.prefixed);
            finalProperties.add(pair.unprefixed);
        }
        ArrayList normalProperties = new ArrayList(propertyMap.values());
        Collections.sort(normalProperties);
        Collections.sort(primitiveProperties);
        finalProperties.addAll(normalProperties);
        finalProperties.addAll(primitiveProperties);
        return finalProperties;
    }

    private String getUnprefixedName(String name) {
        if (name.startsWith(this.prefix)) {
            return AccessorFirstStrategy.getPropertyName(name.replaceFirst(this.prefix, ""));
        }
        return name;
    }

    private static class PrefixPair
    implements Comparable<PrefixPair> {
        private final Property prefixed;
        private final Property unprefixed;

        private PrefixPair(Property prefixed, Property unprefixed) {
            this.prefixed = prefixed;
            this.unprefixed = unprefixed;
        }

        @Override
        public int compareTo(PrefixPair other) {
            return this.unprefixed.getName().compareTo(other.unprefixed.getName());
        }
    }
}

