/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.eventimplgen.factory;

import com.palantir.javapoet.ClassName;
import com.palantir.javapoet.CodeBlock;
import com.palantir.javapoet.FieldSpec;
import com.palantir.javapoet.MethodSpec;
import com.palantir.javapoet.TypeName;
import com.palantir.javapoet.TypeSpec;
import dagger.assisted.Assisted;
import dagger.assisted.AssistedFactory;
import dagger.assisted.AssistedInject;
import java.util.Optional;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import org.spongepowered.eventgen.annotations.PropertySettings;
import org.spongepowered.eventgen.annotations.UseField;
import org.spongepowered.eventimplgen.eventgencore.Property;
import org.spongepowered.eventimplgen.factory.ClassGenerator;

public final class ClassContext {
    private static final ClassName OPTIONAL = ClassName.get(Optional.class);
    private final Types types;
    private final TypeSpec.Builder builder;
    private final CodeBlock.Builder toStringBuilder = CodeBlock.builder();
    private boolean toStringReceivedParam;
    private final TypeMirror erasedOptional;

    @AssistedInject
    public ClassContext(Types types, Elements elements, @Assisted TypeSpec.Builder builder) {
        this.types = types;
        this.builder = builder;
        this.erasedOptional = types.erasure(elements.getTypeElement(Optional.class.getName()).asType());
    }

    public ClassContext addField(FieldSpec field) {
        this.builder.addField(field);
        return this;
    }

    public ClassContext addField(FieldSpec.Builder field) {
        this.builder.addField(field.build());
        return this;
    }

    public ClassContext addField(TypeMirror typeMirror, String name, Modifier ... modifiers) {
        this.builder.addField(TypeName.get((TypeMirror)typeMirror), name, modifiers);
        return this;
    }

    public ClassContext addField(Property property) {
        if (!ClassGenerator.isRequired(property) && !ClassGenerator.generateMethods(property) || !property.isLeastSpecificType(this.types)) {
            return this;
        }
        return this.addField(property.getType(), property.getName(), Modifier.PRIVATE);
    }

    public ClassContext addMethod(MethodSpec methodSpec) {
        this.builder.addMethod(methodSpec);
        return this;
    }

    public ClassContext addMethod(MethodSpec.Builder methodBuilder) {
        this.builder.addMethod(methodBuilder.build());
        return this;
    }

    public ClassContext addMutator(TypeElement type, String fieldName, Property property) {
        String varName;
        ExecutableElement mutator = property.getMutator().get();
        MethodSpec.Builder method = MethodSpec.methodBuilder((String)mutator.getSimpleName().toString()).addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).addParameter(TypeName.get((TypeMirror)mutator.getParameters().get(0).asType()), property.getName(), new Modifier[]{Modifier.FINAL});
        if (this.types.isAssignable(property.getAccessor().getReturnType(), this.erasedOptional)) {
            method.addStatement("final $T wrapped = $T.ofNullable($L)", new Object[]{TypeName.get((TypeMirror)property.getType()), OPTIONAL, property.getName()});
            varName = "wrapped";
        } else {
            varName = property.getName();
        }
        if (!property.getType().getKind().isPrimitive() && !this.types.isSameType(property.getMostSpecificType(), property.getAccessor().getReturnType())) {
            TypeMirror mostSpecificReturn = property.getMostSpecificType();
            method.addCode(CodeBlock.builder().beginControlFlow("if ($1L != null && !($1L instanceof $2T))", new Object[]{varName, this.types.erasure(mostSpecificReturn)}).addStatement("throw new RuntimeException(\"You've attempted to call the method '$L' with an object of type\" + $L.getClass().getName()\n+ \", instead of $L. Though you may have been listening for a supertype of this event, it's technically\"\n+ \"a $L. You need to ensure that the event is the type you think it is.\")", new Object[]{mutator.getSimpleName(), varName, mostSpecificReturn, type.getQualifiedName()}).endControlFlow().build());
        }
        method.addStatement("this.$L = $L", new Object[]{fieldName, varName});
        return this.addMethod(method);
    }

    void initializeToString(TypeElement type) {
        this.toStringBuilder.add("return $S\n", new Object[]{String.valueOf(type.getSimpleName()) + "{"}).indent();
    }

    void contributeToString(TypeMirror parentType, Property property) {
        PropertySettings settings = ClassGenerator.getPropertySettings(property);
        if (settings != null && !settings.useInToString()) {
            return;
        }
        if (property.isLeastSpecificType(this.types) && (ClassGenerator.isRequired(property) || ClassGenerator.generateMethods(property))) {
            boolean overrideToString = false;
            UseField useField = ClassGenerator.getUseField(parentType, property.getName());
            if (useField != null) {
                overrideToString = useField.overrideToString();
            }
            String value = overrideToString ? "this." + property.getName() : "this." + String.valueOf(property.getAccessor().getSimpleName()) + "()";
            this.toStringBuilder.add("+ $S + $L\n", new Object[]{(this.toStringReceivedParam ? ", " : "") + property.getName() + "=", value});
            this.toStringReceivedParam = true;
        }
    }

    void finalizeToString(TypeElement type) {
        this.toStringBuilder.add("+ '}';", new Object[0]);
        this.addMethod(MethodSpec.methodBuilder((String)"toString").addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(String.class).addAnnotation(Override.class).addCode(this.toStringBuilder.build()));
    }

    @AssistedFactory
    static interface Factory {
        public ClassContext create(TypeSpec.Builder var1);
    }
}

