/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.eventimplgen.factory;

import com.palantir.javapoet.AnnotationSpec;
import com.palantir.javapoet.ClassName;
import com.palantir.javapoet.CodeBlock;
import com.palantir.javapoet.JavaFile;
import com.palantir.javapoet.MethodSpec;
import com.palantir.javapoet.ParameterizedTypeName;
import com.palantir.javapoet.TypeName;
import com.palantir.javapoet.TypeSpec;
import com.palantir.javapoet.TypeVariableName;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.processing.Generated;
import javax.annotation.processing.Messager;
import javax.inject.Inject;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.eventgen.annotations.PropertySettings;
import org.spongepowered.eventgen.annotations.UseField;
import org.spongepowered.eventgen.annotations.internal.GeneratedEvent;
import org.spongepowered.eventimplgen.eventgencore.Property;
import org.spongepowered.eventimplgen.eventgencore.PropertySorter;
import org.spongepowered.eventimplgen.factory.ClassContext;
import org.spongepowered.eventimplgen.factory.ClassNameProvider;
import org.spongepowered.eventimplgen.factory.EventData;
import org.spongepowered.eventimplgen.factory.NullPolicy;
import org.spongepowered.eventimplgen.factory.plugin.EventFactoryPlugin;
import org.spongepowered.eventimplgen.processor.EventImplGenProcessor;

public class ClassGenerator {
    private static final ClassName OBJECTS = ClassName.get(Objects.class);
    private final Types types;
    private final Elements elements;
    private final Messager messager;
    private final ClassContext.Factory classContextFactory;
    private final ClassNameProvider classNameProvider;
    private NullPolicy nullPolicy = NullPolicy.DISABLE_PRECONDITIONS;

    @Inject
    ClassGenerator(ClassNameProvider classNameProvider, Types types, Elements elements, Messager messager, ClassContext.Factory classContextFactory) {
        this.classNameProvider = classNameProvider;
        this.types = types;
        this.elements = elements;
        this.messager = messager;
        this.classContextFactory = classContextFactory;
    }

    static PropertySettings getPropertySettings(Property property) {
        PropertySettings anno = property.getMostSpecificMethod().getAnnotation(PropertySettings.class);
        if (anno != null) {
            return anno;
        }
        return property.getAccessor().getAnnotation(PropertySettings.class);
    }

    static boolean isRequired(Property property) {
        PropertySettings settings = ClassGenerator.getPropertySettings(property);
        if (settings == null) {
            return !property.getMostSpecificMethod().isDefault();
        }
        return settings.requiredParameter();
    }

    static boolean generateMethods(Property property) {
        PropertySettings settings = ClassGenerator.getPropertySettings(property);
        if (settings != null) {
            return settings.generateMethods();
        }
        return !property.getMostSpecificMethod().isDefault();
    }

    static UseField getUseField(TypeMirror clazz, String fieldName) {
        if (clazz.getKind() != TypeKind.DECLARED) {
            return null;
        }
        Element type = ((DeclaredType)clazz).asElement();
        if (type == null) {
            return null;
        }
        for (VariableElement element : ElementFilter.fieldsIn(type.getEnclosedElements())) {
            if (!element.getSimpleName().contentEquals(fieldName)) continue;
            return element.getAnnotation(UseField.class);
        }
        return null;
    }

    public boolean hasDeclaredMethod(DeclaredType clazz, String name, TypeMirror ... params) {
        for (ExecutableElement method : ElementFilter.methodsIn(this.elements.getAllMembers((TypeElement)clazz.asElement()))) {
            if (!method.getSimpleName().contentEquals(name) || !this.parametersEqual(method.getParameters(), params)) continue;
            return true;
        }
        return false;
    }

    private boolean parametersEqual(List<? extends VariableElement> a, TypeMirror ... b) {
        if (a.size() != b.length) {
            return false;
        }
        for (int i = 0; i < b.length; ++i) {
            if (this.types.isSameType(a.get(i).asType(), b[i])) continue;
            return false;
        }
        return true;
    }

    public VariableElement getField(DeclaredType clazz, String fieldName) {
        for (VariableElement field : ElementFilter.fieldsIn(this.elements.getAllMembers((TypeElement)clazz.asElement()))) {
            if (!field.getSimpleName().contentEquals(fieldName)) continue;
            return field;
        }
        return null;
    }

    public NullPolicy getNullPolicy() {
        return this.nullPolicy;
    }

    public void setNullPolicy(NullPolicy nullPolicy) {
        this.nullPolicy = Objects.requireNonNull(nullPolicy, "nullPolicy");
    }

    private void alwaysQualifiedImports(TypeSpec.Builder classBuilder, TypeElement element) {
        HashSet alwaysQualified = new HashSet();
        this.elements.getAllMembers(element).stream().filter(el -> el.getKind().isClass() || el.getKind().isInterface()).filter(el -> ((TypeElement)el).getNestingKind().isNested()).map(el -> el.getSimpleName().toString()).forEach(alwaysQualified::add);
        classBuilder.alwaysQualify(alwaysQualified.toArray(new String[0]));
    }

    private boolean hasNullable(ExecutableElement method) {
        return ClassGenerator.hasAnnotationOnSelfOrReturnType(method, name -> name.contentEquals("Nullable"));
    }

    private boolean hasNonNull(ExecutableElement method) {
        return ClassGenerator.hasAnnotationOnSelfOrReturnType(method, name -> name.contentEquals("NotNull") || name.contentEquals("Nonnull"));
    }

    private static boolean hasAnnotationOnSelfOrReturnType(ExecutableElement method, Predicate<Name> annotationTest) {
        List<? extends AnnotationMirror> typeUseAnnotations;
        List<? extends AnnotationMirror> annotations = method.getAnnotationMirrors();
        if (!annotations.isEmpty()) {
            for (AnnotationMirror annotationMirror : annotations) {
                if (!annotationTest.test(annotationMirror.getAnnotationType().asElement().getSimpleName())) continue;
                return true;
            }
        }
        if (!(typeUseAnnotations = method.getReturnType().getAnnotationMirrors()).isEmpty()) {
            for (AnnotationMirror annotationMirror : annotations) {
                if (!annotationTest.test(annotationMirror.getAnnotationType().asElement().getSimpleName())) continue;
                return true;
            }
        }
        return false;
    }

    public boolean contributeField(ClassContext classWriter, DeclaredType parentType, Property property) {
        VariableElement field = this.getField(parentType, property.getName());
        if (field == null || field.getAnnotation(UseField.class) == null) {
            classWriter.addField(property);
        } else {
            if (field.getModifiers().contains((Object)Modifier.PRIVATE)) {
                this.messager.printMessage(Diagnostic.Kind.ERROR, "You've annotated the field " + property.getName() + " with @UseField, but it's private. This just won't work.", field);
                return false;
            }
            if (!this.types.isSubtype(this.types.erasure(field.asType()), this.types.erasure(property.getType()))) {
                if (this.types.isAssignable(this.types.erasure(property.getType()), this.types.erasure(field.asType()))) {
                    return true;
                }
                this.messager.printMessage(Diagnostic.Kind.ERROR, String.format("In event %s with parent %s - you've specified field '%s' of type %s but the property has the expected type of %s", this.elements.getBinaryName((TypeElement)property.getAccessor().getEnclosingElement()), parentType, field.getSimpleName(), field.asType(), property.getType()), field);
                return false;
            }
        }
        return true;
    }

    public List<Property> getRequiredProperties(List<Property> properties) {
        return properties.stream().filter(p -> p.isMostSpecificType(this.types) && ClassGenerator.isRequired(p)).collect(Collectors.toList());
    }

    private MethodSpec generateConstructor(DeclaredType parentType, List<Property> properties) {
        List<Property> requiredProperties = this.getRequiredProperties(properties);
        MethodSpec.Builder builder = MethodSpec.constructorBuilder();
        CodeBlock.Builder initializer = CodeBlock.builder();
        for (Property property : requiredProperties) {
            builder.addParameter(TypeName.get((TypeMirror)property.getType()), property.getName(), new Modifier[]{Modifier.FINAL});
            if (this.nullPolicy != NullPolicy.DISABLE_PRECONDITIONS) {
                boolean useNullTest;
                boolean bl = useNullTest = !property.getType().getKind().isPrimitive() && (this.nullPolicy == NullPolicy.NON_NULL_BY_DEFAULT && !this.hasNullable(property.getAccessor()) || this.nullPolicy == NullPolicy.NULL_BY_DEFAULT && this.hasNonNull(property.getAccessor())) && ClassGenerator.isRequired(property);
                if (useNullTest) {
                    initializer.addStatement("this.$1L = $2T.requireNonNull($1L, $3S)", new Object[]{property.getName(), OBJECTS, "The property '" + property.getName() + "' was not provided!"});
                    continue;
                }
            }
            initializer.addStatement("this.$1L = $1L", new Object[]{property.getName()});
        }
        if (this.hasDeclaredMethod(parentType, "init", new TypeMirror[0])) {
            initializer.addStatement("super.init()", new Object[0]);
        }
        builder.addCode(initializer.build());
        return builder.build();
    }

    private MethodSpec generateAccessor(Property property) {
        ExecutableElement accessor = property.getAccessor();
        TypeName returnType = TypeName.get((TypeMirror)property.getType());
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)accessor.getSimpleName().toString()).addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(TypeName.get((TypeMirror)property.getType()));
        if (property.isLeastSpecificType(this.types)) {
            builder.addStatement("return this.$L", new Object[]{property.getName()});
        } else {
            builder.addStatement("return ($T) this.$L", new Object[]{returnType, property.getName()});
        }
        return builder.build();
    }

    private void generateAccessorsAndMutator(ClassContext typeBuilder, TypeElement type, Property property) {
        if (ClassGenerator.generateMethods(property)) {
            Optional<ExecutableElement> mutatorOptional;
            if (property.isMostSpecificType(this.types)) {
                typeBuilder.addMethod(this.generateAccessor(property));
            }
            if ((mutatorOptional = property.getMutator()).isPresent()) {
                typeBuilder.addMutator(type, property.getName(), property);
            }
        }
    }

    private void deriveParentTypeName(TypeSpec.Builder builder, DeclaredType parentType, TypeElement iface) {
        Element element;
        ArrayList classTypeParameters = new ArrayList();
        TypeName superClassName = TypeName.get((TypeMirror)parentType);
        if (iface != null) {
            iface.getTypeParameters().stream().map(TypeVariableName::get).forEach(classTypeParameters::add);
        }
        if ((element = parentType.asElement()) instanceof TypeElement) {
            TypeElement te = (TypeElement)element;
            TypeName[] params = (TypeName[])te.getTypeParameters().stream().map(tpe -> TypeName.get((TypeMirror)tpe.asType())).toArray(TypeName[]::new);
            ClassName newClassName = ClassName.get((TypeElement)te);
            if (params.length == 0) {
                builder.superclass(superClassName);
                return;
            }
            superClassName = ParameterizedTypeName.get((ClassName)newClassName, (TypeName[])params);
            if (classTypeParameters.isEmpty()) {
                ArrayList innerParams = new ArrayList();
                for (TypeMirror typeMirror : iface.getInterfaces()) {
                    if (!(typeMirror instanceof DeclaredType)) continue;
                    DeclaredType de = (DeclaredType)typeMirror;
                    de.getTypeArguments().stream().map(ite -> {
                        if (ite instanceof DeclaredType) {
                            DeclaredType dte = (DeclaredType)ite;
                            TypeElement nte = (TypeElement)dte.asElement();
                            return ClassName.get((TypeElement)nte);
                        }
                        return TypeName.get((TypeMirror)ite);
                    }).forEach(innerParams::add);
                }
                TypeName[] modifiedParams = innerParams.toArray(new TypeName[0]);
                superClassName = ParameterizedTypeName.get((ClassName)newClassName, (TypeName[])modifiedParams);
            }
            builder.superclass(superClassName);
        }
    }

    @Nullable
    public JavaFile createClass(TypeElement type, ClassName name, DeclaredType parentType, EventData data, PropertySorter sorter, Set<? extends EventFactoryPlugin> plugins) {
        Objects.requireNonNull(type, "type");
        Objects.requireNonNull(name, "name");
        Objects.requireNonNull(parentType, "parentType");
        TypeName implementedInterface = this.classNameProvider.getImplementingInterfaceName(type);
        ArrayList classTypeParameters = new ArrayList();
        TypeSpec.Builder classBuilder = TypeSpec.classBuilder((ClassName)name).addModifiers(new Modifier[]{Modifier.FINAL}).addTypeVariables(classTypeParameters).addSuperinterface(implementedInterface).addOriginatingElement((Element)type).addAnnotation(this.generatedAnnotation()).addAnnotation(AnnotationSpec.builder(GeneratedEvent.class).addMember("source", "$T.class", new Object[]{implementedInterface instanceof ParameterizedTypeName ? ((ParameterizedTypeName)implementedInterface).rawType() : implementedInterface}).addMember("version", "$S", new Object[]{ClassGenerator.class.getPackage().getImplementationVersion()}).build());
        this.deriveParentTypeName(classBuilder, parentType, type);
        this.alwaysQualifiedImports(classBuilder, type);
        classBuilder.avoidClashesWithNestedClasses(type);
        data.extraOrigins().forEach(arg_0 -> ((TypeSpec.Builder)classBuilder).addOriginatingElement(arg_0));
        for (TypeParameterElement typeParameterElement : type.getTypeParameters()) {
            classBuilder.addTypeVariable(TypeVariableName.get((TypeParameterElement)typeParameterElement));
        }
        classBuilder.addMethod(this.generateConstructor(parentType, sorter.sortProperties(data.properties())));
        ClassContext ctx = this.classContextFactory.create(classBuilder);
        ctx.initializeToString(type);
        if (!this.generateWithPlugins(ctx, type, parentType, data.properties(), plugins)) {
            return null;
        }
        ctx.finalizeToString(type);
        return JavaFile.builder((String)name.packageName(), (TypeSpec)classBuilder.build()).indent("    ").build();
    }

    private boolean generateWithPlugins(ClassContext classBuilder, TypeElement eventClass, DeclaredType parentType, List<Property> properties, Set<? extends EventFactoryPlugin> plugins) {
        boolean success = true;
        for (Property property : properties) {
            boolean processed = false;
            for (EventFactoryPlugin eventFactoryPlugin : plugins) {
                EventFactoryPlugin.Result result = eventFactoryPlugin.contributeProperty(eventClass, classBuilder, property);
                processed = result != EventFactoryPlugin.Result.IGNORE;
                success &= result != EventFactoryPlugin.Result.FAILURE;
                if (!processed) continue;
                break;
            }
            classBuilder.contributeToString(parentType, property);
            if (processed) continue;
            success &= this.contributeField(classBuilder, parentType, property);
            this.generateAccessorsAndMutator(classBuilder, eventClass, property);
        }
        return success;
    }

    AnnotationSpec generatedAnnotation() {
        return AnnotationSpec.builder(Generated.class).addMember("value", "$S", new Object[]{EventImplGenProcessor.class.getName()}).build();
    }

    public ClassName qualifiedName(TypeElement event) {
        return this.classNameProvider.getClassName(event, "Impl");
    }
}

