/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.eventimplgen.factory;

import com.palantir.javapoet.ClassName;
import com.palantir.javapoet.ParameterizedTypeName;
import com.palantir.javapoet.TypeName;
import java.util.ArrayList;
import javax.inject.Inject;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.type.TypeMirror;
import org.spongepowered.eventimplgen.processor.EventGenOptions;

public class ClassNameProvider {
    private final String targetPackage;

    @Inject
    public ClassNameProvider(EventGenOptions options) {
        String outputFactory = options.generatedEventFactory();
        this.targetPackage = outputFactory.substring(0, outputFactory.lastIndexOf(46));
    }

    public ClassName getClassName(TypeElement clazz, String classifier) {
        StringBuilder name = new StringBuilder();
        int startIdx = name.length();
        for (Element target = clazz; target != null && (target.getKind().isClass() || target.getKind().isInterface()); target = target.getEnclosingElement()) {
            if (name.length() > startIdx) {
                name.insert(startIdx, '_');
            }
            name.insert(startIdx, target.getSimpleName());
        }
        return ClassName.get((String)this.targetPackage, (String)name.append('_').append(classifier).toString(), (String[])new String[0]);
    }

    public TypeName getImplementingInterfaceName(TypeElement clazz) {
        TypeName original = TypeName.get((TypeMirror)clazz.asType());
        if (!clazz.getNestingKind().isNested()) {
            return original;
        }
        if (!clazz.getTypeParameters().isEmpty()) {
            ArrayList<TypeName> typeArguments = new ArrayList<TypeName>();
            for (TypeParameterElement typeParameterElement : clazz.getTypeParameters()) {
                typeArguments.add(TypeName.get((TypeMirror)typeParameterElement.asType()));
            }
            ClassName ifaceName = ClassName.get((TypeElement)clazz);
            return ParameterizedTypeName.get((ClassName)ifaceName, (TypeName[])typeArguments.toArray(new TypeName[0]));
        }
        return ClassName.get((TypeElement)clazz);
    }
}

