/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.eventimplgen.factory;

import com.palantir.javapoet.AnnotationSpec;
import com.palantir.javapoet.ClassName;
import com.palantir.javapoet.JavaFile;
import com.palantir.javapoet.MethodSpec;
import com.palantir.javapoet.TypeName;
import com.palantir.javapoet.TypeSpec;
import com.palantir.javapoet.TypeVariableName;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import org.spongepowered.eventgen.annotations.internal.GeneratedFactory;
import org.spongepowered.eventimplgen.eventgencore.Property;
import org.spongepowered.eventimplgen.eventgencore.PropertySorter;
import org.spongepowered.eventimplgen.factory.ClassGenerator;
import org.spongepowered.eventimplgen.factory.EventData;

@Singleton
public class FactoryInterfaceGenerator {
    private final ClassGenerator generator;

    @Inject
    FactoryInterfaceGenerator(ClassGenerator generator) {
        this.generator = generator;
    }

    public JavaFile createClass(String name, Map<TypeElement, EventData> foundProperties, PropertySorter sorter, List<ExecutableElement> forwardedMethods) {
        ClassName clazz = ClassName.bestGuess((String)name);
        TypeSpec.Builder factoryClass = TypeSpec.classBuilder((ClassName)clazz.topLevelClassName()).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).addMethod(MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PRIVATE}).build()).addAnnotation(AnnotationSpec.builder(GeneratedFactory.class).addMember("version", "$S", new Object[]{FactoryInterfaceGenerator.class.getPackage().getImplementationVersion()}).build()).addAnnotation(this.generator.generatedAnnotation());
        for (Map.Entry<TypeElement, EventData> event : foundProperties.entrySet()) {
            factoryClass.addOriginatingElement((Element)event.getKey());
            event.getValue().extraOrigins().forEach(arg_0 -> ((TypeSpec.Builder)factoryClass).addOriginatingElement(arg_0));
            factoryClass.addMethod(this.generateRealImpl(event.getKey(), this.generator.qualifiedName(event.getKey()), this.generator.getRequiredProperties(sorter.sortProperties(event.getValue().properties()))));
        }
        for (ExecutableElement forwardedMethod : forwardedMethods) {
            factoryClass.addOriginatingElement((Element)forwardedMethod);
            factoryClass.addMethod(this.generateForwardingMethod(forwardedMethod));
        }
        return JavaFile.builder((String)clazz.packageName(), (TypeSpec)factoryClass.build()).indent("    ").build();
    }

    private MethodSpec generateForwardingMethod(ExecutableElement targetMethod) {
        MethodSpec.Builder spec = MethodSpec.methodBuilder((String)targetMethod.getSimpleName().toString()).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).returns(TypeName.get((TypeMirror)targetMethod.getReturnType()));
        for (TypeParameterElement typeParameterElement : targetMethod.getTypeParameters()) {
            spec.addTypeVariable(TypeVariableName.get((TypeVariable)((TypeVariable)typeParameterElement.asType())));
        }
        StringBuilder params = new StringBuilder();
        for (VariableElement variableElement : targetMethod.getParameters()) {
            spec.addParameter(TypeName.get((TypeMirror)variableElement.asType()), variableElement.getSimpleName().toString(), new Modifier[]{Modifier.FINAL});
            if (params.length() > 0) {
                params.append(", ");
            }
            params.append(variableElement.getSimpleName().toString());
        }
        String string = targetMethod.getTypeParameters().isEmpty() ? "return $T.$L($L);" : "return $T.$L<>($L);";
        spec.addCode(string, new Object[]{TypeName.get((TypeMirror)targetMethod.getEnclosingElement().asType()), targetMethod.getSimpleName().toString(), params.toString()});
        return spec.build();
    }

    private MethodSpec generateRealImpl(TypeElement event, ClassName eventName, List<Property> params) {
        MethodSpec.Builder spec = MethodSpec.methodBuilder((String)FactoryInterfaceGenerator.generateMethodName(event)).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).returns(TypeName.get((TypeMirror)event.asType()));
        for (TypeParameterElement typeParameterElement : event.getTypeParameters()) {
            spec.addTypeVariable(TypeVariableName.get((TypeVariable)((TypeVariable)typeParameterElement.asType())));
        }
        StringBuilder paramNames = new StringBuilder();
        for (Property property : params) {
            spec.addParameter(TypeName.get((TypeMirror)property.getType()), property.getName(), new Modifier[]{Modifier.FINAL});
            if (paramNames.length() > 0) {
                paramNames.append(", ");
            }
            paramNames.append(property.getName());
        }
        String string = event.getTypeParameters().isEmpty() ? "return new $T($L);" : "return new $T<>($L);";
        spec.addCode(string, new Object[]{eventName, paramNames.toString()});
        return spec.build();
    }

    public static String generateMethodName(TypeElement event) {
        ElementKind kind;
        StringBuilder name = new StringBuilder();
        do {
            name.insert(0, event.getSimpleName());
        } while ((event = (kind = event.getEnclosingElement().getKind()).isClass() || kind.isInterface() ? (TypeElement)event.getEnclosingElement() : null) != null);
        name.insert(0, "create");
        return name.toString();
    }
}

