/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.eventimplgen.factory.plugin;

import com.palantir.javapoet.MethodSpec;
import com.palantir.javapoet.TypeName;
import java.util.Objects;
import javax.annotation.processing.Messager;
import javax.inject.Inject;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;
import org.spongepowered.eventgen.annotations.TransformResult;
import org.spongepowered.eventgen.annotations.TransformWith;
import org.spongepowered.eventimplgen.eventgencore.Property;
import org.spongepowered.eventimplgen.factory.ClassContext;
import org.spongepowered.eventimplgen.factory.plugin.EventFactoryPlugin;

public class AccessorModifierEventFactoryPlugin
implements EventFactoryPlugin {
    private final Types types;
    private final Messager messager;

    @Inject
    AccessorModifierEventFactoryPlugin(Types types, Messager messager) {
        this.types = types;
        this.messager = messager;
    }

    private MethodPair getLinkedField(Property property) {
        ExecutableElement leastSpecificMethod = property.getLeastSpecificMethod();
        ExecutableElement transformWith = null;
        String name = null;
        TransformResult transformResult = leastSpecificMethod.getAnnotation(TransformResult.class);
        if (transformResult != null) {
            name = transformResult.value();
            for (ExecutableElement method : ElementFilter.methodsIn(this.types.asElement(property.getAccessor().getReturnType()).getEnclosedElements())) {
                TransformWith annotation = method.getAnnotation(TransformWith.class);
                if (annotation == null || !Objects.equals(annotation.value(), name)) continue;
                if (transformWith != null) {
                    this.messager.printMessage(Diagnostic.Kind.ERROR, "Multiple @TransformResult annotations were found with the name " + name + ". One of them needs to be changed!", method);
                    return MethodPair.FAILED;
                }
                transformWith = method;
            }
            if (transformWith == null) {
                this.messager.printMessage(Diagnostic.Kind.ERROR, "Unable to locate a matching @TransformWith annotation with the name " + name + " for this method", property.getAccessor());
                return MethodPair.FAILED;
            }
        }
        if (transformWith != null) {
            return new MethodPair(name, transformWith, property);
        }
        return null;
    }

    private void generateTransformingAccessor(ClassContext cw, MethodPair pair, Property property) {
        ExecutableElement accessor = property.getAccessor();
        ExecutableElement transformerMethod = pair.getTransformerMethod();
        cw.addMethod(MethodSpec.methodBuilder((String)accessor.getSimpleName().toString()).addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).returns(TypeName.get((TypeMirror)property.getType())).addStatement("return this.$L(this.$L)", new Object[]{transformerMethod.getSimpleName().toString(), property.getName()}));
    }

    @Override
    public EventFactoryPlugin.Result contributeProperty(TypeElement eventClass, ClassContext classWriter, Property property) {
        MethodPair methodPair = this.getLinkedField(property);
        if (methodPair == null) {
            return EventFactoryPlugin.Result.IGNORE;
        }
        if (methodPair == MethodPair.FAILED) {
            return EventFactoryPlugin.Result.FAILURE;
        }
        classWriter.addField(property);
        if (property.getMutator().isPresent()) {
            classWriter.addMutator(eventClass, property.getName(), property);
        }
        this.generateTransformingAccessor(classWriter, methodPair, property);
        return EventFactoryPlugin.Result.SUCCESSS;
    }

    static final class MethodPair {
        static final MethodPair FAILED = new MethodPair("error", null, null);
        private final String name;
        private final ExecutableElement transformerMethod;
        private final Property property;

        public MethodPair(String name, ExecutableElement transformerMethod, Property property) {
            this.name = name;
            this.transformerMethod = transformerMethod;
            this.property = property;
        }

        public String getName() {
            return this.name;
        }

        public ExecutableElement getTransformerMethod() {
            return this.transformerMethod;
        }

        public Property getProperty() {
            return this.property;
        }
    }
}

