/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.eventimplgen.processor;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.processing.Messager;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.tools.Diagnostic;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.eventgen.annotations.GenerateFactoryMethod;
import org.spongepowered.eventgen.annotations.NoFactoryMethod;
import org.spongepowered.eventimplgen.processor.ProcessorOptions;

@Singleton
public class EventGenOptions {
    static final Pattern COMMA_SPLIT = Pattern.compile(",", 16);
    static final Pattern COLON_SPLIT = Pattern.compile(":", 16);
    public static final String GENERATED_EVENT_FACTORY = "eventGenFactory";
    public static final String SORT_PRIORITY_PREFIX = "sortPriorityPrefix";
    public static final String GROUPING_PREFIXES = "groupingPrefixes";
    public static final String INCLUSIVE_FOLDERS = "eventGenInclusiveFolders";
    public static final String EXCLUSIVE_FOLDERS = "eventGenExclusiveFolders";
    public static final String INCLUSIVE_ANNOTATIONS = "inclusiveAnnotations";
    public static final String EXCLUSIVE_ANNOTATIONS = "exclusiveAnnotations";
    public static final String DEBUG = "eventGenDebug";
    private boolean validated;
    private boolean valid = true;
    private final Messager messager;
    private final Map<String, String> options;

    @Inject
    EventGenOptions(@ProcessorOptions Map<String, String> options, Messager messager) {
        this.options = options;
        this.messager = messager;
    }

    public String generatedEventFactory() {
        return Objects.requireNonNull(this.options.get(GENERATED_EVENT_FACTORY), "invalid state, factory name not provided");
    }

    public Set<String> inclusivePackages() {
        String rawInclusiveFolders = this.options.get(INCLUSIVE_FOLDERS);
        if (rawInclusiveFolders == null) {
            return Collections.emptySet();
        }
        String[] folders = rawInclusiveFolders.split(",");
        return Arrays.stream(folders).map(s -> s.replace("/", ".")).collect(Collectors.toUnmodifiableSet());
    }

    public Set<String> exclusivePackages() {
        String rawExclusiveFolders = this.options.get(EXCLUSIVE_FOLDERS);
        if (rawExclusiveFolders == null) {
            return Collections.emptySet();
        }
        String[] folders = rawExclusiveFolders.split(",");
        return Arrays.stream(folders).map(s -> s.replace("/", ".")).collect(Collectors.toUnmodifiableSet());
    }

    @Nullable
    public String sortPriorityPrefix() {
        return this.options.getOrDefault(SORT_PRIORITY_PREFIX, "original");
    }

    public Map<String, String> groupingPrefixes() {
        @Nullable String input = this.options.get(GROUPING_PREFIXES);
        if (input == null || input.isEmpty()) {
            return Collections.singletonMap("from", "to");
        }
        HashMap<String, String> prefixes = new HashMap<String, String>();
        for (String pair : COMMA_SPLIT.split(input, -1)) {
            String[] values;
            if (pair.isEmpty() || (values = COLON_SPLIT.split(pair, 2)).length == 2) continue;
            this.messager.printMessage(Diagnostic.Kind.WARNING, String.format("[event-impl-gen]: Invalid grouping prefix pair '%s' detected. Must be in the form <a>:<b>", pair));
            prefixes.put(values[0], values[1]);
        }
        return Collections.unmodifiableMap(prefixes);
    }

    public Set<String> inclusiveAnnotations() {
        return this.commaSeparatedSet(INCLUSIVE_ANNOTATIONS, GenerateFactoryMethod.class.getCanonicalName());
    }

    public Set<String> exclusiveAnnotations() {
        return this.commaSeparatedSet(EXCLUSIVE_ANNOTATIONS, NoFactoryMethod.class.getCanonicalName());
    }

    public boolean debug() {
        return Boolean.parseBoolean(this.options.getOrDefault(DEBUG, "false"));
    }

    private Set<String> commaSeparatedSet(String key, String defaultValue) {
        @Nullable String input = this.options.get(key);
        if (input == null) {
            return Collections.singleton(defaultValue);
        }
        return new HashSet<String>(Arrays.asList(COMMA_SPLIT.split(input, -1)));
    }

    public boolean validate() {
        if (this.validated) {
            return this.valid;
        }
        boolean valid = true;
        if (!this.options.containsKey(GENERATED_EVENT_FACTORY)) {
            this.messager.printMessage(Diagnostic.Kind.ERROR, "[event-impl-gen]: The eventGenFactory option must be specified to generate a factory.");
            valid = false;
        }
        this.valid = valid;
        this.validated = true;
        return valid;
    }
}

