/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.eventimplgen.processor;

import com.google.auto.service.AutoService;
import java.io.IOException;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.Processor;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedOptions;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import javax.tools.Diagnostic;
import org.spongepowered.eventimplgen.processor.DaggerEventGenComponent;
import org.spongepowered.eventimplgen.processor.EventGenComponent;
import org.spongepowered.eventimplgen.processor.EventImplWriter;
import org.spongepowered.eventimplgen.processor.EventScanner;
import org.spongepowered.eventimplgen.processor.ProcessorEnvironmentModule;

@SupportedOptions(value={"eventGenFactory", "eventGenInclusiveFolders", "eventGenExclusiveFolders", "sortPriorityPrefix", "groupingPrefixes", "inclusiveAnnotations", "exclusiveAnnotations", "eventGenDebug"})
@SupportedSourceVersion(value=SourceVersion.RELEASE_21)
@SupportedAnnotationTypes(value={"org.spongepowered.eventgen.annotations.AbsoluteSortPosition", "org.spongepowered.eventgen.annotations.DefaultImplemented", "org.spongepowered.eventgen.annotations.GenerateFactoryMethod", "org.spongepowered.eventgen.annotations.NoFactoryMethod", "org.spongepowered.eventgen.annotations.PropertySettings", "org.spongepowered.eventgen.annotations.ToStringExclude", "org.spongepowered.eventgen.annotations.TransformResult", "org.spongepowered.eventgen.annotations.TransformWith", "org.spongepowered.eventgen.annotations.UseField", "org.gradle.annotation.processing.isolating"})
@AutoService(value={Processor.class})
public class EventImplGenProcessor
extends AbstractProcessor {
    private EventGenComponent component;

    static Element topLevelType(TypeElement element) {
        Element output = element;
        while (output.getEnclosingElement().getKind() != ElementKind.PACKAGE) {
            output = output.getEnclosingElement();
        }
        return output;
    }

    @Override
    public synchronized void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        this.component = DaggerEventGenComponent.builder().processorEnvironmentModule(new ProcessorEnvironmentModule(processingEnv)).build();
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        EventImplWriter writer;
        if (!this.component.options().validate()) {
            return false;
        }
        EventScanner scanner = this.component.scanner();
        if (!scanner.scanRound(roundEnv, writer = this.component.writer(), annotations)) {
            writer.skipRound();
        }
        try {
            writer.dumpRound(roundEnv.getRootElements());
            if (roundEnv.processingOver()) {
                writer.dumpFinal();
            }
        }
        catch (IOException ex) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Failed to write class information due to an exception: " + ex.getMessage());
            ex.printStackTrace();
        }
        return false;
    }
}

