/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.eventimplgen.processor;

import com.palantir.javapoet.ClassName;
import com.palantir.javapoet.JavaFile;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.annotation.processing.Filer;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.util.Elements;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.eventimplgen.AnnotationUtils;
import org.spongepowered.eventimplgen.eventgencore.Property;
import org.spongepowered.eventimplgen.eventgencore.PropertySorter;
import org.spongepowered.eventimplgen.factory.ClassGenerator;
import org.spongepowered.eventimplgen.factory.EventData;
import org.spongepowered.eventimplgen.factory.FactoryInterfaceGenerator;
import org.spongepowered.eventimplgen.factory.NullPolicy;
import org.spongepowered.eventimplgen.factory.plugin.EventFactoryPlugin;
import org.spongepowered.eventimplgen.processor.EventGenOptions;
import org.spongepowered.eventimplgen.processor.EventImplGenProcessor;
import org.spongepowered.eventimplgen.processor.PropertyConsumer;

@Singleton
public class EventImplWriter
implements PropertyConsumer {
    private final Filer filer;
    private final Elements elements;
    private final PropertySorter sorter;
    private final Set<EventFactoryPlugin> plugins;
    private final String outputFactory;
    private final FactoryInterfaceGenerator factoryGenerator;
    private final ClassGenerator generator;
    private final Map<TypeElement, EventData> roundFoundProperties;
    private final Map<TypeElement, EventData> allFoundProperties;
    private final List<ExecutableElement> forwardedMethods = new ArrayList<ExecutableElement>();
    private boolean failed = false;
    private boolean classesWritten = false;

    @Inject
    EventImplWriter(Filer filer, Elements elements, PropertySorter sorter, Set<EventFactoryPlugin> plugins, EventGenOptions options, FactoryInterfaceGenerator factoryGenerator, ClassGenerator generator) {
        this.filer = filer;
        this.elements = elements;
        this.sorter = sorter;
        this.plugins = plugins;
        this.roundFoundProperties = new TreeMap<TypeElement, EventData>(Comparator.comparing(e -> elements.getBinaryName((TypeElement)e).toString()));
        this.allFoundProperties = new TreeMap<TypeElement, EventData>(Comparator.comparing(e -> elements.getBinaryName((TypeElement)e).toString()));
        this.outputFactory = options.generatedEventFactory();
        this.factoryGenerator = factoryGenerator;
        this.generator = generator;
    }

    @Override
    public void propertyFound(TypeElement event, List<Property> property, Set<? extends Element> originating) {
        this.roundFoundProperties.put(event, new EventData(property, originating));
    }

    @Override
    public void forwardedMethods(List<? extends ExecutableElement> elements) {
        this.forwardedMethods.addAll(elements);
    }

    void skipRound() {
        this.roundFoundProperties.clear();
    }

    public void dumpRound(Set<? extends Element> rootElements) throws IOException {
        this.generator.setNullPolicy(NullPolicy.NON_NULL_BY_DEFAULT);
        for (TypeElement event : this.roundFoundProperties.keySet()) {
            DeclaredType baseClass;
            TypeElement existing;
            ClassName name = this.generator.qualifiedName(event);
            if (!rootElements.contains(EventImplGenProcessor.topLevelType(event)) || (existing = this.elements.getTypeElement(name.reflectionName())) != null && rootElements.contains(existing) || (baseClass = this.getBaseClass(event)) == null) continue;
            JavaFile clazz = this.generator.createClass(event, name, baseClass, this.roundFoundProperties.get(event), this.sorter, this.plugins);
            if (clazz != null) {
                this.classesWritten = true;
                clazz.writeTo(this.filer);
                continue;
            }
            this.failed = true;
        }
        this.allFoundProperties.putAll(this.roundFoundProperties);
        this.roundFoundProperties.clear();
    }

    public void dumpFinal() throws IOException {
        if (this.failed || !this.classesWritten) {
            return;
        }
        JavaFile clazz = this.factoryGenerator.createClass(this.outputFactory, this.allFoundProperties, this.sorter, this.forwardedMethods);
        clazz.writeTo(this.filer);
    }

    @Nullable
    private DeclaredType getBaseClass(TypeElement event) {
        DeclaredType found = AnnotationUtils.getImplementedBy(event);
        if (found != null) {
            return found;
        }
        return (DeclaredType)this.elements.getTypeElement("java.lang.Object").asType();
    }
}

