/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.eventimplgen.processor;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import javax.annotation.processing.Messager;
import javax.annotation.processing.RoundEnvironment;
import javax.inject.Inject;
import javax.lang.model.AnnotatedConstruct;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.QualifiedNameable;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.eventgen.annotations.FactoryMethod;
import org.spongepowered.eventgen.annotations.NoFactoryMethod;
import org.spongepowered.eventgen.annotations.internal.GeneratedEvent;
import org.spongepowered.eventimplgen.AnnotationUtils;
import org.spongepowered.eventimplgen.eventgencore.PropertySearchStrategy;
import org.spongepowered.eventimplgen.processor.EventGenOptions;
import org.spongepowered.eventimplgen.processor.EventImplGenProcessor;
import org.spongepowered.eventimplgen.processor.PropertyConsumer;

public class EventScanner {
    static final Pattern DOT_SPLIT = Pattern.compile("\\.");
    private final Set<String> inclusiveAnnotations;
    private final Set<String> exclusiveAnnotations;
    private final boolean debugMode;
    private final Types types;
    private final Elements elements;
    private final Messager messager;
    private final PropertySearchStrategy strategy;
    private final RootNode packages = new RootNode();
    private final Set<String> inclusivePackages;
    private final Set<String> exclusivePackages;

    @Inject
    EventScanner(EventGenOptions options, Types types, Elements elemests, Messager messager, PropertySearchStrategy strategy) {
        this.inclusiveAnnotations = options.inclusiveAnnotations();
        this.exclusiveAnnotations = options.exclusiveAnnotations();
        this.debugMode = options.debug();
        this.inclusivePackages = options.inclusivePackages();
        this.exclusivePackages = options.exclusivePackages();
        this.types = types;
        this.elements = elemests;
        this.messager = messager;
        this.strategy = strategy;
    }

    /*
     * WARNING - void declaration
     */
    boolean scanRound(RoundEnvironment environment, PropertyConsumer consumer, Set<? extends TypeElement> annotations) {
        OriginatedElement pointer;
        if (!environment.getRootElements().isEmpty()) {
            this.packages.populate(environment);
        }
        boolean failed = false;
        ArrayDeque<OriginatedElement> elements = new ArrayDeque<OriginatedElement>();
        for (String inclusiveAnnotation : this.inclusiveAnnotations) {
            TypeElement element = this.elements.getTypeElement(inclusiveAnnotation);
            if (element == null) {
                this.messager.printMessage(Diagnostic.Kind.ERROR, "Unable to resolve an annotation for specified inclusive annotation " + inclusiveAnnotation);
                failed = true;
                continue;
            }
            if (!annotations.contains(element)) continue;
            for (Element element2 : environment.getElementsAnnotatedWith(element)) {
                elements.add(OriginatedElement.root(element2));
            }
        }
        if (failed) {
            return false;
        }
        this.hydrateIncrementalPackageHierarchy(environment, annotations);
        for (String inclusivePackage : this.inclusivePackages) {
            String fixedPackage = inclusivePackage.replace('/', '.');
            PackageElement packageElement = this.elements.getPackageElement(fixedPackage);
            if (packageElement == null) {
                this.messager.printMessage(Diagnostic.Kind.ERROR, "Unable to resolve an inclusive package " + fixedPackage);
                failed = true;
                continue;
            }
            PackageNode packageNode = this.packages.get(packageElement);
            if (packageNode == null) continue;
            elements.add(OriginatedElement.root(packageElement));
        }
        HashSet<Element> seen = new HashSet<Element>();
        block10: while ((pointer = (OriginatedElement)elements.poll()) != null) {
            Element active = pointer.element;
            if (!seen.add(active)) continue;
            if (this.debugMode) {
                this.messager.printMessage(Diagnostic.Kind.NOTE, "Testing for events " + String.valueOf(active instanceof QualifiedNameable ? ((QualifiedNameable)active).getQualifiedName() : active.getSimpleName()));
            }
            switch (active.getKind()) {
                case PACKAGE: {
                    OriginatedElement finalPointer = pointer;
                    active.getEnclosedElements().stream().filter(el -> el.getKind().isInterface() || el.getKind().isClass()).forEach(el -> elements.add(new OriginatedElement((Element)el, finalPointer)));
                    PackageNode packageNode = this.packages.get((PackageElement)active);
                    if (packageNode == null) {
                        this.messager.printMessage(Diagnostic.Kind.ERROR, "Unable to query package metadata", active);
                        failed = true;
                        continue block10;
                    }
                    packageNode.childPackages().filter(pkg -> !this.hasExclusiveAnnotation((Element)pkg)).forEach(pkg -> elements.add(new OriginatedElement((Element)pkg, finalPointer)));
                    continue block10;
                }
                case ANNOTATION_TYPE: {
                    continue block10;
                }
                case INTERFACE: {
                    void var10_18;
                    TypeElement event = (TypeElement)active;
                    if (this.hasExclusiveAnnotation(event)) continue block10;
                    for (Element element : event.getEnclosedElements()) {
                        if (!element.getKind().isClass() && !element.getKind().isInterface()) continue;
                        elements.add(new OriginatedElement(element, pointer));
                    }
                    if (this.isNonTransitivelyExcluded(event)) continue block10;
                    if (this.debugMode) {
                        this.messager.printMessage(Diagnostic.Kind.NOTE, "Generating for event " + String.valueOf(event.getSimpleName()));
                    }
                    if (pointer.parent == null) {
                        Set set = Collections.emptySet();
                    } else {
                        void var11_22;
                        OriginatedElement originatedElement;
                        HashSet<Element> hashSet = new HashSet<Element>();
                        OriginatedElement originatedElement2 = pointer.parent;
                        do {
                            hashSet.add(var11_22.element);
                        } while ((originatedElement = var11_22.parent) != null);
                    }
                    consumer.propertyFound(event, this.strategy.findProperties(event), (Set<? extends Element>)var10_18);
                    consumer.forwardedMethods(this.findForwardedMethods(event));
                    continue block10;
                }
                case ENUM: {
                    continue block10;
                }
                case CLASS: {
                    if (active.getAnnotation(GeneratedEvent.class) != null || active.getModifiers().contains((Object)Modifier.ABSTRACT) || this.hasExclusiveAnnotation(active)) continue block10;
                    this.messager.printMessage(Diagnostic.Kind.ERROR, "This element (" + String.valueOf((Object)active.getKind()) + " " + String.valueOf(active.getSimpleName()) + ")  was annotated directly or transitively, but it is not a package or interface", active);
                    failed = true;
                    continue block10;
                }
            }
            this.messager.printMessage(Diagnostic.Kind.ERROR, "This element (" + String.valueOf((Object)active.getKind()) + " " + String.valueOf(active.getSimpleName()) + ")  was annotated directly or transitively, but it is not a package or interface", active);
            failed = true;
        }
        return !failed;
    }

    private boolean hasExclusiveAnnotationInherited(Element candidate, boolean inherited) {
        boolean excludedByAnnotation = AnnotationUtils.containsAnnotation(candidate, this.exclusiveAnnotations);
        if (excludedByAnnotation) {
            if (!inherited) {
                return true;
            }
            AnnotationMirror noFactory = AnnotationUtils.getAnnotation((AnnotatedConstruct)candidate, NoFactoryMethod.class);
            return noFactory == null || (Boolean)AnnotationUtils.getValue(noFactory, "ignoreNested") == false;
        }
        return switch (candidate.getKind()) {
            case ElementKind.PACKAGE -> {
                if (AnnotationUtils.containsAnnotation(candidate, this.inclusiveAnnotations)) {
                    yield false;
                }
                String qualifiedPackageName = ((PackageElement)candidate).getQualifiedName().toString();
                if (this.inclusivePackages.contains(qualifiedPackageName)) {
                    yield false;
                }
                if (this.exclusivePackages.contains(qualifiedPackageName)) {
                    yield true;
                }
                int lastDot = qualifiedPackageName.lastIndexOf(46);
                if (lastDot == -1) {
                    yield false;
                }
                String parentPackage = qualifiedPackageName.substring(0, lastDot);
                PackageElement parent = this.elements.getPackageElement(parentPackage);
                if (parent == null) {
                    yield false;
                }
                yield this.hasExclusiveAnnotationInherited(parent, true);
            }
            case ElementKind.INTERFACE, ElementKind.CLASS -> {
                TypeElement typeElement = (TypeElement)candidate;
                if (AnnotationUtils.containsAnnotation(candidate, this.inclusiveAnnotations)) {
                    yield false;
                }
                yield this.hasExclusiveAnnotationInherited(typeElement.getEnclosingElement(), false);
            }
            default -> false;
        };
    }

    public boolean hasExclusiveAnnotation(Element candidate) {
        return this.hasExclusiveAnnotationInherited(candidate, false);
    }

    public boolean isNonTransitivelyExcluded(TypeElement candidate) {
        if (!ElementFilter.typesIn(candidate.getEnclosedElements()).isEmpty()) {
            return !AnnotationUtils.containsAnnotation(candidate, this.inclusiveAnnotations);
        }
        return false;
    }

    private void hydrateIncrementalPackageHierarchy(RoundEnvironment environment, Set<? extends TypeElement> annotations) {
        TypeElement generatedEvent = this.elements.getTypeElement(GeneratedEvent.class.getName());
        if (generatedEvent != null && annotations.contains(generatedEvent)) {
            TypeMirror object = this.elements.getTypeElement("java.lang.Object").asType();
            HashSet<String> seenPackages = new HashSet<String>();
            for (Element element : environment.getElementsAnnotatedWith(generatedEvent)) {
                int dotIndex;
                TypeElement eventItf;
                PackageElement packageElement;
                String packageName;
                AnnotationMirror mirror = AnnotationUtils.getAnnotation((AnnotatedConstruct)element, GeneratedEvent.class);
                TypeMirror annotatedType = (TypeMirror)AnnotationUtils.getValue(mirror, "source");
                if (annotatedType == null || this.types.isSameType(annotatedType, object) || annotatedType.getKind() != TypeKind.DECLARED || !seenPackages.add(packageName = (packageElement = (PackageElement)EventImplGenProcessor.topLevelType(eventItf = (TypeElement)((DeclaredType)annotatedType).asElement()).getEnclosingElement()).getQualifiedName().toString())) continue;
                this.packages.set(packageName, packageElement);
                while ((dotIndex = packageName.lastIndexOf(46)) != -1 && seenPackages.add(packageName = packageName.substring(0, dotIndex))) {
                    packageElement = this.elements.getPackageElement(packageName);
                    if (packageElement == null) continue;
                    this.packages.set(packageName, packageElement);
                }
            }
        }
    }

    private List<ExecutableElement> findForwardedMethods(TypeElement event) {
        ArrayList<ExecutableElement> methods = new ArrayList<ExecutableElement>();
        for (ExecutableElement method : ElementFilter.methodsIn(event.getEnclosedElements())) {
            if (method.getAnnotation(FactoryMethod.class) == null) continue;
            boolean failed = false;
            if (!method.getModifiers().contains((Object)Modifier.STATIC) || method.getModifiers().contains((Object)Modifier.PRIVATE)) {
                this.messager.printMessage(Diagnostic.Kind.ERROR, "Methods annotated with @FactoryMethod must be public and static", method);
                failed = true;
            }
            if (!this.types.isAssignable(method.getReturnType(), event.asType())) {
                this.messager.printMessage(Diagnostic.Kind.ERROR, "Methods annotated by @FactoryMethod must return their owning type.", method);
                failed = true;
            }
            if (!failed) continue;
            methods.add(method);
        }
        return methods;
    }

    class RootNode
    extends PackageNode {
        RootNode() {
        }

        void populate(RoundEnvironment env) {
            HashSet<String> seen = new HashSet<String>();
            for (TypeElement type : ElementFilter.typesIn(env.getRootElements())) {
                PackageElement pkg = EventScanner.this.elements.getPackageOf(type);
                String pkgname = pkg.getQualifiedName().toString();
                if (seen.add(pkgname)) {
                    this.set(pkgname, pkg);
                }
                EventScanner.this.elements.getAllPackageElements("").stream().filter(potentialPkg -> {
                    String pkgName = potentialPkg.getQualifiedName().toString();
                    return pkgName.startsWith(pkgName + ".") && pkgName.substring(pkgName.length() + 1).indexOf(46) == -1;
                }).forEachOrdered(childPackage -> {
                    String childPackageName = childPackage.getQualifiedName().toString();
                    if (seen.add(childPackageName)) {
                        this.set(childPackageName, (PackageElement)childPackage);
                    }
                });
            }
        }

        void set(String name, PackageElement element) {
            this.get((String)name, (boolean)true).self = element;
        }

        @Nullable
        PackageNode get(PackageElement element) {
            @Nullable PackageNode node = this.get(element.getQualifiedName().toString(), false);
            if (node != null) {
                node.self = element;
            }
            return node;
        }

        PackageNode get(String packageName, boolean create) {
            String[] elements = DOT_SPLIT.split(packageName, -1);
            PackageNode pointer = this;
            for (String element : elements) {
                if (create) {
                    pointer = pointer.knownChildren.computeIfAbsent(element, $ -> new PackageNode());
                    continue;
                }
                pointer = pointer.knownChildren.get(element);
                if (pointer != null) continue;
                return null;
            }
            return pointer;
        }

        @Override
        public String toString() {
            return "<root>";
        }
    }

    static class OriginatedElement {
        final Element element;
        @Nullable
        final OriginatedElement parent;

        static OriginatedElement root(Element element) {
            return new OriginatedElement(element, null);
        }

        OriginatedElement(Element element, @Nullable OriginatedElement parent) {
            this.element = element;
            this.parent = parent;
        }
    }

    class PackageNode {
        @Nullable
        PackageElement self;
        protected final Map<String, PackageNode> knownChildren = new HashMap<String, PackageNode>();

        PackageNode() {
        }

        Stream<PackageElement> childPackages() {
            return this.knownChildren.entrySet().stream().filter(Objects::nonNull).flatMap(entry -> {
                PackageNode childNode = (PackageNode)entry.getValue();
                if (childNode.self == null && this.self != null) {
                    String packageName = this.self.getQualifiedName().toString() + "." + (String)entry.getKey();
                    childNode.self = EventScanner.this.elements.getPackageElement(packageName);
                }
                if (childNode.self == null) {
                    return childNode.childPackages();
                }
                return Stream.concat(Stream.of(childNode.self), childNode.childPackages());
            }).filter(Objects::nonNull);
        }

        public String toString() {
            return this.self == null ? "<unknown>" : this.self.getQualifiedName().toString();
        }
    }
}

