/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.eventimplgen.processor;

import dagger.Module;
import dagger.Provides;
import java.util.Locale;
import java.util.Map;
import javax.annotation.processing.Filer;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.inject.Singleton;
import javax.lang.model.SourceVersion;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import org.spongepowered.eventimplgen.processor.PreviewFeatureShim;
import org.spongepowered.eventimplgen.processor.PreviewFeatures;
import org.spongepowered.eventimplgen.processor.ProcessorOptions;

@Module
public class ProcessorEnvironmentModule {
    private final ProcessingEnvironment environment;

    public ProcessorEnvironmentModule(ProcessingEnvironment environment) {
        this.environment = environment;
    }

    @Provides
    ProcessingEnvironment provideEnvironment() {
        return this.environment;
    }

    @Provides
    Types provideTypes(ProcessingEnvironment environment) {
        return environment.getTypeUtils();
    }

    @Provides
    Elements provideElements(ProcessingEnvironment environment) {
        return environment.getElementUtils();
    }

    @Provides
    Messager provideMessager(ProcessingEnvironment environment) {
        return environment.getMessager();
    }

    @Provides
    Filer provideFiler(ProcessingEnvironment environment) {
        return environment.getFiler();
    }

    @Provides
    SourceVersion provideSourceVersion(ProcessingEnvironment environment) {
        return environment.getSourceVersion();
    }

    @Provides
    @PreviewFeatures
    boolean providePreviewFeatures(ProcessingEnvironment environment) {
        return PreviewFeatureShim.previewFeaturesEnabled(environment);
    }

    @Provides
    Locale provideLocale(ProcessingEnvironment environment) {
        return environment.getLocale();
    }

    @Provides
    @Singleton
    @ProcessorOptions
    Map<String, String> options(ProcessingEnvironment environment) {
        return environment.getOptions();
    }
}

