/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.eventimplgen.signature;

import javax.inject.Inject;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import org.spongepowered.eventimplgen.signature.TypeToDescriptorWriter;

public class Descriptors {
    public static final String TYPE_UNKNOWN = "eventImplGen/UNKNOWN";
    public static final String TYPE_ERROR = "eventImplGen/ERROR";
    private final Elements elements;
    private final Types types;
    private final TypeToDescriptorWriter descWriter;

    @Inject
    Descriptors(Elements elements, Types types, TypeToDescriptorWriter descWriter) {
        this.elements = elements;
        this.types = types;
        this.descWriter = descWriter;
    }

    public String getDescriptor(ExecutableElement method) {
        return this.getDescriptor((ExecutableType)method.asType(), true);
    }

    public String getDescriptor(ExecutableType method, boolean includeReturnType) {
        if (includeReturnType) {
            return method.accept(this.descWriter, new StringBuilder()).toString();
        }
        StringBuilder builder = new StringBuilder();
        builder.append('(');
        for (TypeMirror typeMirror : method.getParameterTypes()) {
            typeMirror.accept(this.descWriter, builder);
        }
        builder.append(")V");
        return builder.toString();
    }

    public String getInternalName(TypeMirror name) {
        name = this.types.erasure(name);
        switch (name.getKind()) {
            case DECLARED: {
                return this.getInternalName(this.elements.getBinaryName((TypeElement)((DeclaredType)name).asElement()).toString());
            }
            case ERROR: {
                return TYPE_ERROR;
            }
        }
        return TYPE_UNKNOWN;
    }

    public String getInternalName(String name) {
        return name.replace('.', '/');
    }
}

