/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.eventimplgen.signature;

import javax.inject.Inject;
import javax.inject.Singleton;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ErrorType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.IntersectionType;
import javax.lang.model.type.NoType;
import javax.lang.model.type.NullType;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.type.UnionType;
import javax.lang.model.type.WildcardType;
import javax.lang.model.util.AbstractTypeVisitor14;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;

@Singleton
public class TypeToDescriptorWriter
extends AbstractTypeVisitor14<StringBuilder, StringBuilder> {
    private final Types types;
    private final Elements elements;

    @Inject
    TypeToDescriptorWriter(Types types, Elements elements) {
        this.types = types;
        this.elements = elements;
    }

    static char descriptor(PrimitiveType primitive) {
        return switch (primitive.getKind()) {
            case TypeKind.BOOLEAN -> 'Z';
            case TypeKind.BYTE -> 'B';
            case TypeKind.SHORT -> 'S';
            case TypeKind.INT -> 'I';
            case TypeKind.LONG -> 'J';
            case TypeKind.CHAR -> 'C';
            case TypeKind.FLOAT -> 'F';
            case TypeKind.DOUBLE -> 'D';
            default -> throw new IllegalArgumentException("Unknown primitive type kind " + String.valueOf((Object)primitive.getKind()));
        };
    }

    @Override
    public StringBuilder visitIntersection(IntersectionType t, StringBuilder builder) {
        return this.types.erasure(t).accept(this, builder);
    }

    @Override
    public StringBuilder visitPrimitive(PrimitiveType t, StringBuilder builder) {
        return builder.append(TypeToDescriptorWriter.descriptor(t));
    }

    @Override
    public StringBuilder visitArray(ArrayType t, StringBuilder builder) {
        builder.append('[');
        return t.getComponentType().accept(this, builder);
    }

    @Override
    public StringBuilder visitDeclared(DeclaredType t, StringBuilder builder) {
        return builder.append('L').append(this.elements.getBinaryName((TypeElement)t.asElement()).toString().replace('.', '/')).append(';');
    }

    @Override
    public StringBuilder visitTypeVariable(TypeVariable t, StringBuilder builder) {
        return t.getUpperBound().accept(this, builder);
    }

    @Override
    public StringBuilder visitWildcard(WildcardType t, StringBuilder builder) {
        if (t.getExtendsBound() != null) {
            t.getExtendsBound().accept(this, builder);
        } else {
            this.elements.getTypeElement("java.lang.Object").asType().accept(this, builder);
        }
        return builder;
    }

    @Override
    public StringBuilder visitExecutable(ExecutableType t, StringBuilder builder) {
        builder.append('(');
        for (TypeMirror typeMirror : t.getParameterTypes()) {
            typeMirror.accept(this, builder);
        }
        builder.append(')');
        return t.getReturnType().accept(this, builder);
    }

    @Override
    public StringBuilder visitNoType(NoType t, StringBuilder builder) {
        if (t.getKind() == TypeKind.VOID) {
            return builder.append('V');
        }
        return builder;
    }

    @Override
    public StringBuilder visitError(ErrorType t, StringBuilder builder) {
        builder.append("L!ERROR!;");
        return builder;
    }

    @Override
    public StringBuilder visitNull(NullType t, StringBuilder builder) {
        return builder;
    }

    @Override
    public StringBuilder visitUnion(UnionType t, StringBuilder builder) {
        return null;
    }
}

