/*
 * Decompiled with CFR 0.152.
 */
package org.squeryl.logging;

import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintStream;
import org.squeryl.InternalFieldMapper$;
import org.squeryl.logging.BarChartRenderer;
import org.squeryl.logging.Measure$;
import org.squeryl.logging.StatLine;
import org.squeryl.logging.StatsSchema$;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.xml.Unparsed$;

public final class BarChartRenderer$ {
    public static final BarChartRenderer$ MODULE$;
    private final String drawFunc;

    static {
        new BarChartRenderer$();
    }

    public void generateStatSummary(File staticHtmlFile, int n) {
        String page = this.page((Seq<BarChartRenderer.Stat>)Predef$.MODULE$.wrapRefArray((Object[])new BarChartRenderer.Stat[]{new BarChartRenderer.Stat(new StringBuilder().append((Object)"Top ").append((Object)BoxesRunTime.boxToInteger((int)n)).append((Object)" statements with longest avg").toString(), "avg time", InternalFieldMapper$.MODULE$.queryToIterable(StatsSchema$.MODULE$.topRankingStatements(n, Measure$.MODULE$.AvgExecTime())), (Function1<StatLine, String>)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(StatLine sl) {
                return ((Object)BoxesRunTime.boxToDouble((double)sl.avgExecTime())).toString();
            }
        }), new BarChartRenderer.Stat(new StringBuilder().append((Object)"Top ").append((Object)BoxesRunTime.boxToInteger((int)n)).append((Object)" most called statements").toString(), "invocation count", InternalFieldMapper$.MODULE$.queryToIterable(StatsSchema$.MODULE$.topRankingStatements(n, Measure$.MODULE$.InvocationCount())), (Function1<StatLine, String>)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(StatLine sl) {
                return ((Object)BoxesRunTime.boxToLong((long)sl.invocationCount())).toString();
            }
        }), new BarChartRenderer.Stat(new StringBuilder().append((Object)"Top ").append((Object)BoxesRunTime.boxToInteger((int)n)).append((Object)" statements incurring most cumulative execution time").toString(), "cumulative execution time", InternalFieldMapper$.MODULE$.queryToIterable(StatsSchema$.MODULE$.topRankingStatements(n, Measure$.MODULE$.CumulativeExecutionTime())), (Function1<StatLine, String>)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(StatLine sl) {
                return ((Object)BoxesRunTime.boxToLong((long)sl.cumulativeExecutionTime())).toString();
            }
        }), new BarChartRenderer.Stat(new StringBuilder().append((Object)"Top ").append((Object)BoxesRunTime.boxToInteger((int)n)).append((Object)" statements with highest avg row count").toString(), "avg row count", InternalFieldMapper$.MODULE$.queryToIterable(StatsSchema$.MODULE$.topRankingStatements(n, Measure$.MODULE$.AvgResultSetSize())), (Function1<StatLine, String>)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(StatLine sl) {
                return ((Object)BoxesRunTime.boxToFloat((float)sl.avgRowCount())).toString();
            }
        })}));
        PrintStream ps = new PrintStream(new FileOutputStream(staticHtmlFile));
        ps.print(page);
        ps.close();
    }

    public String drawFunc() {
        return this.drawFunc;
    }

    public String funcCalls(Seq<BarChartRenderer.Stat> stats) {
        java.lang.StringBuilder sb = new java.lang.StringBuilder();
        IntRef i = new IntRef(0);
        stats.foreach((Function1)new Serializable(sb, i){
            public static final long serialVersionUID = 0L;
            private final java.lang.StringBuilder sb$1;
            private final IntRef i$1;

            public final java.lang.StringBuilder apply(BarChartRenderer.Stat s) {
                ++this.i$1.elem;
                this.sb$1.append("drawBarGraph('chart");
                this.sb$1.append(this.i$1.elem);
                this.sb$1.append("','");
                this.sb$1.append(s.title());
                this.sb$1.append("','");
                this.sb$1.append(s.xAxisLabel());
                this.sb$1.append("',");
                this.sb$1.append(s.queryLabelsJSArray());
                this.sb$1.append(",");
                this.sb$1.append(s.measuresJSArray());
                return this.sb$1.append(");\n");
            }
            {
                this.sb$1 = sb$1;
                this.i$1 = i$1;
            }
        });
        return sb.toString();
    }

    public String page(Seq<BarChartRenderer.Stat> stats) {
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n    <html xmlns=\"http://www.w3.org/1999/xhtml\">\n      <head>\n        <meta http-equiv=\"content-type\" content=\"text/html; charset=utf-8\"/>\n        <title>Performance profile of Squeryl queries</title>\n        <script type=\"text/javascript\" src=\"http://www.google.com/jsapi\"></script>\n        <script type=\"text/javascript\">\n          google.load('visualization', '1', {{packages: ['corechart']}});\n        </script>\n        <script type=\"text/javascript\">\n\n          ", "\n\n          function drawVisualization() {{\n            ", "\n          }}\n\n          google.setOnLoadCallback(drawVisualization);\n        </script>\n      </head>\n      <body style=\"font-family: Arial;border: 0 none;\">\n        <div id=\"chart1\" style=\"width: 1000px; height: 400px;\"></div>\n        <div id=\"chart2\" style=\"width: 1000px; height: 400px;\"></div>\n        <div id=\"chart3\" style=\"width: 1000px; height: 400px;\"></div>\n        <div id=\"chart4\" style=\"width: 1000px; height: 400px;\"></div>\n      </body>\n    </html>\n    "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Unparsed$.MODULE$.apply(this.drawFunc()), Unparsed$.MODULE$.apply(this.funcCalls(stats))}));
    }

    private BarChartRenderer$() {
        MODULE$ = this;
        this.drawFunc = "\n    function drawBarGraph(divId, chartTitle, statType, queryClasses, measure) {\n              var data = new google.visualization.DataTable();\n\n              data.addColumn('string', 'Z');\n              data.addColumn('number', statType);\n\n              data.addRows(queryClasses.length);\n\n              for (var j = 0; j < queryClasses.length; ++j) {\n                data.setValue(j, 0, queryClasses[j].toString());\n                data.setValue(j, 1, measure[j]);\n              }\n\n              var v = new google.visualization.BarChart(document.getElementById(divId))\n\n              v.draw(data,\n                       {title: chartTitle,\n                        width:600, height:400,\n                        vAxis: {title: \"Queries\"},\n                        hAxis: {title: statType}\n                       }\n                  );\n    }\n  ";
    }
}

