
package org.squeryl.dsl.boilerplate

import org.squeryl.dsl.{QueryYield}
import org.squeryl.dsl.internal.{JoinedQueryable, InnerJoinedQueryable, OuterJoinedQueryable}
import org.squeryl.{Queryable, Query}

trait JoinSignatures {
  self: FromSignatures =>

  class JoinPrecursor[A](q: Queryable[A]) {
    def leftOuter = new OuterJoinedQueryable[A](q, "left")
    def rightOuter = new OuterJoinedQueryable[A](q, "right")
    def fullOuter = new OuterJoinedQueryable[A](q, "full")
  }

  implicit def queryable2JoinPrecursor[A](q: Queryable[A]): JoinPrecursor[A] = new JoinPrecursor[A](q)

  implicit def queryable2RightInnerJoinedQueryable[A](q: Queryable[A]): InnerJoinedQueryable[A] =
    new InnerJoinedQueryable[A](q, "")


  def join[A, B1, C](
    q: Queryable[A], q1: JoinedQueryable[B1]
  )(
    f: Function2[A, B1, JoinQueryYield1[C]]
  ): Query[C] =
    from(q, q1)(
     (a: A, b1: B1) => f(a, b1).queryYield
    )

  def join[A, B1, B2, C](
    q: Queryable[A], q1: JoinedQueryable[B1], q2: JoinedQueryable[B2]
  )(
    f: Function3[A, B1, B2, JoinQueryYield2[C]]
  ): Query[C] =
    from(q, q1, q2)(
     (a: A, b1: B1, b2: B2) => f(a, b1, b2).queryYield
    )

  def join[A, B1, B2, B3, C](
    q: Queryable[A], q1: JoinedQueryable[B1], q2: JoinedQueryable[B2], q3: JoinedQueryable[B3]
  )(
    f: Function4[A, B1, B2, B3, JoinQueryYield3[C]]
  ): Query[C] =
    from(q, q1, q2, q3)(
     (a: A, b1: B1, b2: B2, b3: B3) => f(a, b1, b2, b3).queryYield
    )

  def join[A, B1, B2, B3, B4, C](
    q: Queryable[A], q1: JoinedQueryable[B1], q2: JoinedQueryable[B2], q3: JoinedQueryable[B3], q4: JoinedQueryable[B4]
  )(
    f: Function5[A, B1, B2, B3, B4, JoinQueryYield4[C]]
  ): Query[C] =
    from(q, q1, q2, q3, q4)(
     (a: A, b1: B1, b2: B2, b3: B3, b4: B4) => f(a, b1, b2, b3, b4).queryYield
    )

  def join[A, B1, B2, B3, B4, B5, C](
    q: Queryable[A], q1: JoinedQueryable[B1], q2: JoinedQueryable[B2], q3: JoinedQueryable[B3], q4: JoinedQueryable[B4], q5: JoinedQueryable[B5]
  )(
    f: Function6[A, B1, B2, B3, B4, B5, JoinQueryYield5[C]]
  ): Query[C] =
    from(q, q1, q2, q3, q4, q5)(
     (a: A, b1: B1, b2: B2, b3: B3, b4: B4, b5: B5) => f(a, b1, b2, b3, b4, b5).queryYield
    )

  def join[A, B1, B2, B3, B4, B5, B6, C](
    q: Queryable[A], q1: JoinedQueryable[B1], q2: JoinedQueryable[B2], q3: JoinedQueryable[B3], q4: JoinedQueryable[B4], q5: JoinedQueryable[B5], q6: JoinedQueryable[B6]
  )(
    f: Function7[A, B1, B2, B3, B4, B5, B6, JoinQueryYield6[C]]
  ): Query[C] =
    from(q, q1, q2, q3, q4, q5, q6)(
     (a: A, b1: B1, b2: B2, b3: B3, b4: B4, b5: B5, b6: B6) => f(a, b1, b2, b3, b4, b5, b6).queryYield
    )

  def join[A, B1, B2, B3, B4, B5, B6, B7, C](
    q: Queryable[A], q1: JoinedQueryable[B1], q2: JoinedQueryable[B2], q3: JoinedQueryable[B3], q4: JoinedQueryable[B4], q5: JoinedQueryable[B5], q6: JoinedQueryable[B6], q7: JoinedQueryable[B7]
  )(
    f: Function8[A, B1, B2, B3, B4, B5, B6, B7, JoinQueryYield7[C]]
  ): Query[C] =
    from(q, q1, q2, q3, q4, q5, q6, q7)(
     (a: A, b1: B1, b2: B2, b3: B3, b4: B4, b5: B5, b6: B6, b7: B7) => f(a, b1, b2, b3, b4, b5, b6, b7).queryYield
    )

  def join[A, B1, B2, B3, B4, B5, B6, B7, B8, C](
    q: Queryable[A], q1: JoinedQueryable[B1], q2: JoinedQueryable[B2], q3: JoinedQueryable[B3], q4: JoinedQueryable[B4], q5: JoinedQueryable[B5], q6: JoinedQueryable[B6], q7: JoinedQueryable[B7], q8: JoinedQueryable[B8]
  )(
    f: Function9[A, B1, B2, B3, B4, B5, B6, B7, B8, JoinQueryYield8[C]]
  ): Query[C] =
    from(q, q1, q2, q3, q4, q5, q6, q7, q8)(
     (a: A, b1: B1, b2: B2, b3: B3, b4: B4, b5: B5, b6: B6, b7: B7, b8: B8) => f(a, b1, b2, b3, b4, b5, b6, b7, b8).queryYield
    )

  def join[A, B1, B2, B3, B4, B5, B6, B7, B8, B9, C](
    q: Queryable[A], q1: JoinedQueryable[B1], q2: JoinedQueryable[B2], q3: JoinedQueryable[B3], q4: JoinedQueryable[B4], q5: JoinedQueryable[B5], q6: JoinedQueryable[B6], q7: JoinedQueryable[B7], q8: JoinedQueryable[B8], q9: JoinedQueryable[B9]
  )(
    f: Function10[A, B1, B2, B3, B4, B5, B6, B7, B8, B9, JoinQueryYield9[C]]
  ): Query[C] =
    from(q, q1, q2, q3, q4, q5, q6, q7, q8, q9)(
     (a: A, b1: B1, b2: B2, b3: B3, b4: B4, b5: B5, b6: B6, b7: B7, b8: B8, b9: B9) => f(a, b1, b2, b3, b4, b5, b6, b7, b8, b9).queryYield
    )

  def join[A, B1, B2, B3, B4, B5, B6, B7, B8, B9, B10, C](
    q: Queryable[A], q1: JoinedQueryable[B1], q2: JoinedQueryable[B2], q3: JoinedQueryable[B3], q4: JoinedQueryable[B4], q5: JoinedQueryable[B5], q6: JoinedQueryable[B6], q7: JoinedQueryable[B7], q8: JoinedQueryable[B8], q9: JoinedQueryable[B9], q10: JoinedQueryable[B10]
  )(
    f: Function11[A, B1, B2, B3, B4, B5, B6, B7, B8, B9, B10, JoinQueryYield10[C]]
  ): Query[C] =
    from(q, q1, q2, q3, q4, q5, q6, q7, q8, q9, q10)(
     (a: A, b1: B1, b2: B2, b3: B3, b4: B4, b5: B5, b6: B6, b7: B7, b8: B8, b9: B9, b10: B10) => f(a, b1, b2, b3, b4, b5, b6, b7, b8, b9, b10).queryYield
    )

  def join[A, B1, B2, B3, B4, B5, B6, B7, B8, B9, B10, B11, C](
    q: Queryable[A], q1: JoinedQueryable[B1], q2: JoinedQueryable[B2], q3: JoinedQueryable[B3], q4: JoinedQueryable[B4], q5: JoinedQueryable[B5], q6: JoinedQueryable[B6], q7: JoinedQueryable[B7], q8: JoinedQueryable[B8], q9: JoinedQueryable[B9], q10: JoinedQueryable[B10], q11: JoinedQueryable[B11]
  )(
    f: Function12[A, B1, B2, B3, B4, B5, B6, B7, B8, B9, B10, B11, JoinQueryYield11[C]]
  ): Query[C] =
    from(q, q1, q2, q3, q4, q5, q6, q7, q8, q9, q10, q11)(
     (a: A, b1: B1, b2: B2, b3: B3, b4: B4, b5: B5, b6: B6, b7: B7, b8: B8, b9: B9, b10: B10, b11: B11) => f(a, b1, b2, b3, b4, b5, b6, b7, b8, b9, b10, b11).queryYield
    )

  def join[A, B1, B2, B3, B4, B5, B6, B7, B8, B9, B10, B11, B12, C](
    q: Queryable[A], q1: JoinedQueryable[B1], q2: JoinedQueryable[B2], q3: JoinedQueryable[B3], q4: JoinedQueryable[B4], q5: JoinedQueryable[B5], q6: JoinedQueryable[B6], q7: JoinedQueryable[B7], q8: JoinedQueryable[B8], q9: JoinedQueryable[B9], q10: JoinedQueryable[B10], q11: JoinedQueryable[B11], q12: JoinedQueryable[B12]
  )(
    f: Function13[A, B1, B2, B3, B4, B5, B6, B7, B8, B9, B10, B11, B12, JoinQueryYield12[C]]
  ): Query[C] =
    from(q, q1, q2, q3, q4, q5, q6, q7, q8, q9, q10, q11, q12)(
     (a: A, b1: B1, b2: B2, b3: B3, b4: B4, b5: B5, b6: B6, b7: B7, b8: B8, b9: B9, b10: B10, b11: B11, b12: B12) => f(a, b1, b2, b3, b4, b5, b6, b7, b8, b9, b10, b11, b12).queryYield
    )

  def join[A, B1, B2, B3, B4, B5, B6, B7, B8, B9, B10, B11, B12, B13, C](
    q: Queryable[A], q1: JoinedQueryable[B1], q2: JoinedQueryable[B2], q3: JoinedQueryable[B3], q4: JoinedQueryable[B4], q5: JoinedQueryable[B5], q6: JoinedQueryable[B6], q7: JoinedQueryable[B7], q8: JoinedQueryable[B8], q9: JoinedQueryable[B9], q10: JoinedQueryable[B10], q11: JoinedQueryable[B11], q12: JoinedQueryable[B12], q13: JoinedQueryable[B13]
  )(
    f: Function14[A, B1, B2, B3, B4, B5, B6, B7, B8, B9, B10, B11, B12, B13, JoinQueryYield13[C]]
  ): Query[C] =
    from(q, q1, q2, q3, q4, q5, q6, q7, q8, q9, q10, q11, q12, q13)(
     (a: A, b1: B1, b2: B2, b3: B3, b4: B4, b5: B5, b6: B6, b7: B7, b8: B8, b9: B9, b10: B10, b11: B11, b12: B12, b13: B13) => f(a, b1, b2, b3, b4, b5, b6, b7, b8, b9, b10, b11, b12, b13).queryYield
    )

  def join[A, B1, B2, B3, B4, B5, B6, B7, B8, B9, B10, B11, B12, B13, B14, C](
    q: Queryable[A], q1: JoinedQueryable[B1], q2: JoinedQueryable[B2], q3: JoinedQueryable[B3], q4: JoinedQueryable[B4], q5: JoinedQueryable[B5], q6: JoinedQueryable[B6], q7: JoinedQueryable[B7], q8: JoinedQueryable[B8], q9: JoinedQueryable[B9], q10: JoinedQueryable[B10], q11: JoinedQueryable[B11], q12: JoinedQueryable[B12], q13: JoinedQueryable[B13], q14: JoinedQueryable[B14]
  )(
    f: Function15[A, B1, B2, B3, B4, B5, B6, B7, B8, B9, B10, B11, B12, B13, B14, JoinQueryYield14[C]]
  ): Query[C] =
    from(q, q1, q2, q3, q4, q5, q6, q7, q8, q9, q10, q11, q12, q13, q14)(
     (a: A, b1: B1, b2: B2, b3: B3, b4: B4, b5: B5, b6: B6, b7: B7, b8: B8, b9: B9, b10: B10, b11: B11, b12: B12, b13: B13, b14: B14) => f(a, b1, b2, b3, b4, b5, b6, b7, b8, b9, b10, b11, b12, b13, b14).queryYield
    )

  def join[A, B1, B2, B3, B4, B5, B6, B7, B8, B9, B10, B11, B12, B13, B14, B15, C](
    q: Queryable[A], q1: JoinedQueryable[B1], q2: JoinedQueryable[B2], q3: JoinedQueryable[B3], q4: JoinedQueryable[B4], q5: JoinedQueryable[B5], q6: JoinedQueryable[B6], q7: JoinedQueryable[B7], q8: JoinedQueryable[B8], q9: JoinedQueryable[B9], q10: JoinedQueryable[B10], q11: JoinedQueryable[B11], q12: JoinedQueryable[B12], q13: JoinedQueryable[B13], q14: JoinedQueryable[B14], q15: JoinedQueryable[B15]
  )(
    f: Function16[A, B1, B2, B3, B4, B5, B6, B7, B8, B9, B10, B11, B12, B13, B14, B15, JoinQueryYield15[C]]
  ): Query[C] =
    from(q, q1, q2, q3, q4, q5, q6, q7, q8, q9, q10, q11, q12, q13, q14, q15)(
     (a: A, b1: B1, b2: B2, b3: B3, b4: B4, b5: B5, b6: B6, b7: B7, b8: B8, b9: B9, b10: B10, b11: B11, b12: B12, b13: B13, b14: B14, b15: B15) => f(a, b1, b2, b3, b4, b5, b6, b7, b8, b9, b10, b11, b12, b13, b14, b15).queryYield
    )

  def join[A, B1, B2, B3, B4, B5, B6, B7, B8, B9, B10, B11, B12, B13, B14, B15, B16, C](
    q: Queryable[A], q1: JoinedQueryable[B1], q2: JoinedQueryable[B2], q3: JoinedQueryable[B3], q4: JoinedQueryable[B4], q5: JoinedQueryable[B5], q6: JoinedQueryable[B6], q7: JoinedQueryable[B7], q8: JoinedQueryable[B8], q9: JoinedQueryable[B9], q10: JoinedQueryable[B10], q11: JoinedQueryable[B11], q12: JoinedQueryable[B12], q13: JoinedQueryable[B13], q14: JoinedQueryable[B14], q15: JoinedQueryable[B15], q16: JoinedQueryable[B16]
  )(
    f: Function17[A, B1, B2, B3, B4, B5, B6, B7, B8, B9, B10, B11, B12, B13, B14, B15, B16, JoinQueryYield16[C]]
  ): Query[C] =
    from(q, q1, q2, q3, q4, q5, q6, q7, q8, q9, q10, q11, q12, q13, q14, q15, q16)(
     (a: A, b1: B1, b2: B2, b3: B3, b4: B4, b5: B5, b6: B6, b7: B7, b8: B8, b9: B9, b10: B10, b11: B11, b12: B12, b13: B13, b14: B14, b15: B15, b16: B16) => f(a, b1, b2, b3, b4, b5, b6, b7, b8, b9, b10, b11, b12, b13, b14, b15, b16).queryYield
    )

  def join[A, B1, B2, B3, B4, B5, B6, B7, B8, B9, B10, B11, B12, B13, B14, B15, B16, B17, C](
    q: Queryable[A], q1: JoinedQueryable[B1], q2: JoinedQueryable[B2], q3: JoinedQueryable[B3], q4: JoinedQueryable[B4], q5: JoinedQueryable[B5], q6: JoinedQueryable[B6], q7: JoinedQueryable[B7], q8: JoinedQueryable[B8], q9: JoinedQueryable[B9], q10: JoinedQueryable[B10], q11: JoinedQueryable[B11], q12: JoinedQueryable[B12], q13: JoinedQueryable[B13], q14: JoinedQueryable[B14], q15: JoinedQueryable[B15], q16: JoinedQueryable[B16], q17: JoinedQueryable[B17]
  )(
    f: Function18[A, B1, B2, B3, B4, B5, B6, B7, B8, B9, B10, B11, B12, B13, B14, B15, B16, B17, JoinQueryYield17[C]]
  ): Query[C] =
    from(q, q1, q2, q3, q4, q5, q6, q7, q8, q9, q10, q11, q12, q13, q14, q15, q16, q17)(
     (a: A, b1: B1, b2: B2, b3: B3, b4: B4, b5: B5, b6: B6, b7: B7, b8: B8, b9: B9, b10: B10, b11: B11, b12: B12, b13: B13, b14: B14, b15: B15, b16: B16, b17: B17) => f(a, b1, b2, b3, b4, b5, b6, b7, b8, b9, b10, b11, b12, b13, b14, b15, b16, b17).queryYield
    )

  def join[A, B1, B2, B3, B4, B5, B6, B7, B8, B9, B10, B11, B12, B13, B14, B15, B16, B17, B18, C](
    q: Queryable[A], q1: JoinedQueryable[B1], q2: JoinedQueryable[B2], q3: JoinedQueryable[B3], q4: JoinedQueryable[B4], q5: JoinedQueryable[B5], q6: JoinedQueryable[B6], q7: JoinedQueryable[B7], q8: JoinedQueryable[B8], q9: JoinedQueryable[B9], q10: JoinedQueryable[B10], q11: JoinedQueryable[B11], q12: JoinedQueryable[B12], q13: JoinedQueryable[B13], q14: JoinedQueryable[B14], q15: JoinedQueryable[B15], q16: JoinedQueryable[B16], q17: JoinedQueryable[B17], q18: JoinedQueryable[B18]
  )(
    f: Function19[A, B1, B2, B3, B4, B5, B6, B7, B8, B9, B10, B11, B12, B13, B14, B15, B16, B17, B18, JoinQueryYield18[C]]
  ): Query[C] =
    from(q, q1, q2, q3, q4, q5, q6, q7, q8, q9, q10, q11, q12, q13, q14, q15, q16, q17, q18)(
     (a: A, b1: B1, b2: B2, b3: B3, b4: B4, b5: B5, b6: B6, b7: B7, b8: B8, b9: B9, b10: B10, b11: B11, b12: B12, b13: B13, b14: B14, b15: B15, b16: B16, b17: B17, b18: B18) => f(a, b1, b2, b3, b4, b5, b6, b7, b8, b9, b10, b11, b12, b13, b14, b15, b16, b17, b18).queryYield
    )

  def join[A, B1, B2, B3, B4, B5, B6, B7, B8, B9, B10, B11, B12, B13, B14, B15, B16, B17, B18, B19, C](
    q: Queryable[A], q1: JoinedQueryable[B1], q2: JoinedQueryable[B2], q3: JoinedQueryable[B3], q4: JoinedQueryable[B4], q5: JoinedQueryable[B5], q6: JoinedQueryable[B6], q7: JoinedQueryable[B7], q8: JoinedQueryable[B8], q9: JoinedQueryable[B9], q10: JoinedQueryable[B10], q11: JoinedQueryable[B11], q12: JoinedQueryable[B12], q13: JoinedQueryable[B13], q14: JoinedQueryable[B14], q15: JoinedQueryable[B15], q16: JoinedQueryable[B16], q17: JoinedQueryable[B17], q18: JoinedQueryable[B18], q19: JoinedQueryable[B19]
  )(
    f: Function20[A, B1, B2, B3, B4, B5, B6, B7, B8, B9, B10, B11, B12, B13, B14, B15, B16, B17, B18, B19, JoinQueryYield19[C]]
  ): Query[C] =
    from(q, q1, q2, q3, q4, q5, q6, q7, q8, q9, q10, q11, q12, q13, q14, q15, q16, q17, q18, q19)(
     (a: A, b1: B1, b2: B2, b3: B3, b4: B4, b5: B5, b6: B6, b7: B7, b8: B8, b9: B9, b10: B10, b11: B11, b12: B12, b13: B13, b14: B14, b15: B15, b16: B16, b17: B17, b18: B18, b19: B19) => f(a, b1, b2, b3, b4, b5, b6, b7, b8, b9, b10, b11, b12, b13, b14, b15, b16, b17, b18, b19).queryYield
    )

  def join[A, B1, B2, B3, B4, B5, B6, B7, B8, B9, B10, B11, B12, B13, B14, B15, B16, B17, B18, B19, B20, C](
    q: Queryable[A], q1: JoinedQueryable[B1], q2: JoinedQueryable[B2], q3: JoinedQueryable[B3], q4: JoinedQueryable[B4], q5: JoinedQueryable[B5], q6: JoinedQueryable[B6], q7: JoinedQueryable[B7], q8: JoinedQueryable[B8], q9: JoinedQueryable[B9], q10: JoinedQueryable[B10], q11: JoinedQueryable[B11], q12: JoinedQueryable[B12], q13: JoinedQueryable[B13], q14: JoinedQueryable[B14], q15: JoinedQueryable[B15], q16: JoinedQueryable[B16], q17: JoinedQueryable[B17], q18: JoinedQueryable[B18], q19: JoinedQueryable[B19], q20: JoinedQueryable[B20]
  )(
    f: Function21[A, B1, B2, B3, B4, B5, B6, B7, B8, B9, B10, B11, B12, B13, B14, B15, B16, B17, B18, B19, B20, JoinQueryYield20[C]]
  ): Query[C] =
    from(q, q1, q2, q3, q4, q5, q6, q7, q8, q9, q10, q11, q12, q13, q14, q15, q16, q17, q18, q19, q20)(
     (a: A, b1: B1, b2: B2, b3: B3, b4: B4, b5: B5, b6: B6, b7: B7, b8: B8, b9: B9, b10: B10, b11: B11, b12: B12, b13: B13, b14: B14, b15: B15, b16: B16, b17: B17, b18: B18, b19: B19, b20: B20) => f(a, b1, b2, b3, b4, b5, b6, b7, b8, b9, b10, b11, b12, b13, b14, b15, b16, b17, b18, b19, b20).queryYield
    )

}

class JoinQueryYield1[R](val queryYield: QueryYield[R])
class JoinQueryYield2[R](val queryYield: QueryYield[R])
class JoinQueryYield3[R](val queryYield: QueryYield[R])
class JoinQueryYield4[R](val queryYield: QueryYield[R])
class JoinQueryYield5[R](val queryYield: QueryYield[R])
class JoinQueryYield6[R](val queryYield: QueryYield[R])
class JoinQueryYield7[R](val queryYield: QueryYield[R])
class JoinQueryYield8[R](val queryYield: QueryYield[R])
class JoinQueryYield9[R](val queryYield: QueryYield[R])
class JoinQueryYield10[R](val queryYield: QueryYield[R])
class JoinQueryYield11[R](val queryYield: QueryYield[R])
class JoinQueryYield12[R](val queryYield: QueryYield[R])
class JoinQueryYield13[R](val queryYield: QueryYield[R])
class JoinQueryYield14[R](val queryYield: QueryYield[R])
class JoinQueryYield15[R](val queryYield: QueryYield[R])
class JoinQueryYield16[R](val queryYield: QueryYield[R])
class JoinQueryYield17[R](val queryYield: QueryYield[R])
class JoinQueryYield18[R](val queryYield: QueryYield[R])
class JoinQueryYield19[R](val queryYield: QueryYield[R])
class JoinQueryYield20[R](val queryYield: QueryYield[R])
class JoinQueryYield21[R](val queryYield: QueryYield[R])
class JoinQueryYield22[R](val queryYield: QueryYield[R])
