package org.squeryl.dsl


case class CompositeKey2[A1, A2](a1: A1, a2: A2)(implicit
  ev1: A1 => TypedExpression[A1, _], ev2: A2 => TypedExpression[A2, _]
) extends CompositeKey {

  def ===(ck: CompositeKey2[A1, A2]) =
    buildEquality(ck)

  def ===(ck: (A1, A2)) =
    buildEquality(CompositeKey2(ck._1, ck._2))

  def in(cks: CompositeKey2[A1, A2]*) = inExpr(cks)
  def inTuples(cks: (A1, A2)*) = inExpr(cks.map(ck => CompositeKey2(ck._1, ck._2)))

  def notIn(cks: CompositeKey2[A1, A2]*) = notInExpr(cks)
  def notInTuples(cks: (A1, A2)*) = notInExpr(cks.map(ck => CompositeKey2(ck._1, ck._2)))

  protected def constantMembers: Iterable[TypedExpression[_, _]] = List(ev1(a1), ev2(a2))
}


case class CompositeKey3[A1, A2, A3](a1: A1, a2: A2, a3: A3)(implicit
  ev1: A1 => TypedExpression[A1, _], ev2: A2 => TypedExpression[A2, _], ev3: A3 => TypedExpression[A3, _]
) extends CompositeKey {

  def ===(ck: CompositeKey3[A1, A2, A3]) =
    buildEquality(ck)

  def ===(ck: (A1, A2, A3)) =
    buildEquality(CompositeKey3(ck._1, ck._2, ck._3))

  def in(cks: CompositeKey3[A1, A2, A3]*) = inExpr(cks)
  def inTuples(cks: (A1, A2, A3)*) = inExpr(cks.map(ck => CompositeKey3(ck._1, ck._2, ck._3)))

  def notIn(cks: CompositeKey3[A1, A2, A3]*) = notInExpr(cks)
  def notInTuples(cks: (A1, A2, A3)*) = notInExpr(cks.map(ck => CompositeKey3(ck._1, ck._2, ck._3)))

  protected def constantMembers: Iterable[TypedExpression[_, _]] = List(ev1(a1), ev2(a2), ev3(a3))
}


case class CompositeKey4[A1, A2, A3, A4](a1: A1, a2: A2, a3: A3, a4: A4)(implicit
  ev1: A1 => TypedExpression[A1, _], ev2: A2 => TypedExpression[A2, _], ev3: A3 => TypedExpression[A3, _], ev4: A4 => TypedExpression[A4, _]
) extends CompositeKey {

  def ===(ck: CompositeKey4[A1, A2, A3, A4]) =
    buildEquality(ck)

  def ===(ck: (A1, A2, A3, A4)) =
    buildEquality(CompositeKey4(ck._1, ck._2, ck._3, ck._4))

  def in(cks: CompositeKey4[A1, A2, A3, A4]*) = inExpr(cks)
  def inTuples(cks: (A1, A2, A3, A4)*) = inExpr(cks.map(ck => CompositeKey4(ck._1, ck._2, ck._3, ck._4)))

  def notIn(cks: CompositeKey4[A1, A2, A3, A4]*) = notInExpr(cks)
  def notInTuples(cks: (A1, A2, A3, A4)*) = notInExpr(cks.map(ck => CompositeKey4(ck._1, ck._2, ck._3, ck._4)))

  protected def constantMembers: Iterable[TypedExpression[_, _]] = List(ev1(a1), ev2(a2), ev3(a3), ev4(a4))
}


case class CompositeKey5[A1, A2, A3, A4, A5](a1: A1, a2: A2, a3: A3, a4: A4, a5: A5)(implicit
  ev1: A1 => TypedExpression[A1, _], ev2: A2 => TypedExpression[A2, _], ev3: A3 => TypedExpression[A3, _], ev4: A4 => TypedExpression[A4, _], ev5: A5 => TypedExpression[A5, _]
) extends CompositeKey {

  def ===(ck: CompositeKey5[A1, A2, A3, A4, A5]) =
    buildEquality(ck)

  def ===(ck: (A1, A2, A3, A4, A5)) =
    buildEquality(CompositeKey5(ck._1, ck._2, ck._3, ck._4, ck._5))

  def in(cks: CompositeKey5[A1, A2, A3, A4, A5]*) = inExpr(cks)
  def inTuples(cks: (A1, A2, A3, A4, A5)*) = inExpr(cks.map(ck => CompositeKey5(ck._1, ck._2, ck._3, ck._4, ck._5)))

  def notIn(cks: CompositeKey5[A1, A2, A3, A4, A5]*) = notInExpr(cks)
  def notInTuples(cks: (A1, A2, A3, A4, A5)*) = notInExpr(cks.map(ck => CompositeKey5(ck._1, ck._2, ck._3, ck._4, ck._5)))

  protected def constantMembers: Iterable[TypedExpression[_, _]] = List(ev1(a1), ev2(a2), ev3(a3), ev4(a4), ev5(a5))
}


case class CompositeKey6[A1, A2, A3, A4, A5, A6](a1: A1, a2: A2, a3: A3, a4: A4, a5: A5, a6: A6)(implicit
  ev1: A1 => TypedExpression[A1, _], ev2: A2 => TypedExpression[A2, _], ev3: A3 => TypedExpression[A3, _], ev4: A4 => TypedExpression[A4, _], ev5: A5 => TypedExpression[A5, _], ev6: A6 => TypedExpression[A6, _]
) extends CompositeKey {

  def ===(ck: CompositeKey6[A1, A2, A3, A4, A5, A6]) =
    buildEquality(ck)

  def ===(ck: (A1, A2, A3, A4, A5, A6)) =
    buildEquality(CompositeKey6(ck._1, ck._2, ck._3, ck._4, ck._5, ck._6))

  def in(cks: CompositeKey6[A1, A2, A3, A4, A5, A6]*) = inExpr(cks)
  def inTuples(cks: (A1, A2, A3, A4, A5, A6)*) = inExpr(cks.map(ck => CompositeKey6(ck._1, ck._2, ck._3, ck._4, ck._5, ck._6)))

  def notIn(cks: CompositeKey6[A1, A2, A3, A4, A5, A6]*) = notInExpr(cks)
  def notInTuples(cks: (A1, A2, A3, A4, A5, A6)*) = notInExpr(cks.map(ck => CompositeKey6(ck._1, ck._2, ck._3, ck._4, ck._5, ck._6)))

  protected def constantMembers: Iterable[TypedExpression[_, _]] = List(ev1(a1), ev2(a2), ev3(a3), ev4(a4), ev5(a5), ev6(a6))
}


case class CompositeKey7[A1, A2, A3, A4, A5, A6, A7](a1: A1, a2: A2, a3: A3, a4: A4, a5: A5, a6: A6, a7: A7)(implicit
  ev1: A1 => TypedExpression[A1, _], ev2: A2 => TypedExpression[A2, _], ev3: A3 => TypedExpression[A3, _], ev4: A4 => TypedExpression[A4, _], ev5: A5 => TypedExpression[A5, _], ev6: A6 => TypedExpression[A6, _], ev7: A7 => TypedExpression[A7, _]
) extends CompositeKey {

  def ===(ck: CompositeKey7[A1, A2, A3, A4, A5, A6, A7]) =
    buildEquality(ck)

  def ===(ck: (A1, A2, A3, A4, A5, A6, A7)) =
    buildEquality(CompositeKey7(ck._1, ck._2, ck._3, ck._4, ck._5, ck._6, ck._7))

  def in(cks: CompositeKey7[A1, A2, A3, A4, A5, A6, A7]*) = inExpr(cks)
  def inTuples(cks: (A1, A2, A3, A4, A5, A6, A7)*) = inExpr(cks.map(ck => CompositeKey7(ck._1, ck._2, ck._3, ck._4, ck._5, ck._6, ck._7)))

  def notIn(cks: CompositeKey7[A1, A2, A3, A4, A5, A6, A7]*) = notInExpr(cks)
  def notInTuples(cks: (A1, A2, A3, A4, A5, A6, A7)*) = notInExpr(cks.map(ck => CompositeKey7(ck._1, ck._2, ck._3, ck._4, ck._5, ck._6, ck._7)))

  protected def constantMembers: Iterable[TypedExpression[_, _]] = List(ev1(a1), ev2(a2), ev3(a3), ev4(a4), ev5(a5), ev6(a6), ev7(a7))
}


case class CompositeKey8[A1, A2, A3, A4, A5, A6, A7, A8](a1: A1, a2: A2, a3: A3, a4: A4, a5: A5, a6: A6, a7: A7, a8: A8)(implicit
  ev1: A1 => TypedExpression[A1, _], ev2: A2 => TypedExpression[A2, _], ev3: A3 => TypedExpression[A3, _], ev4: A4 => TypedExpression[A4, _], ev5: A5 => TypedExpression[A5, _], ev6: A6 => TypedExpression[A6, _], ev7: A7 => TypedExpression[A7, _], ev8: A8 => TypedExpression[A8, _]
) extends CompositeKey {

  def ===(ck: CompositeKey8[A1, A2, A3, A4, A5, A6, A7, A8]) =
    buildEquality(ck)

  def ===(ck: (A1, A2, A3, A4, A5, A6, A7, A8)) =
    buildEquality(CompositeKey8(ck._1, ck._2, ck._3, ck._4, ck._5, ck._6, ck._7, ck._8))

  def in(cks: CompositeKey8[A1, A2, A3, A4, A5, A6, A7, A8]*) = inExpr(cks)
  def inTuples(cks: (A1, A2, A3, A4, A5, A6, A7, A8)*) = inExpr(cks.map(ck => CompositeKey8(ck._1, ck._2, ck._3, ck._4, ck._5, ck._6, ck._7, ck._8)))

  def notIn(cks: CompositeKey8[A1, A2, A3, A4, A5, A6, A7, A8]*) = notInExpr(cks)
  def notInTuples(cks: (A1, A2, A3, A4, A5, A6, A7, A8)*) = notInExpr(cks.map(ck => CompositeKey8(ck._1, ck._2, ck._3, ck._4, ck._5, ck._6, ck._7, ck._8)))

  protected def constantMembers: Iterable[TypedExpression[_, _]] = List(ev1(a1), ev2(a2), ev3(a3), ev4(a4), ev5(a5), ev6(a6), ev7(a7), ev8(a8))
}


case class CompositeKey9[A1, A2, A3, A4, A5, A6, A7, A8, A9](a1: A1, a2: A2, a3: A3, a4: A4, a5: A5, a6: A6, a7: A7, a8: A8, a9: A9)(implicit
  ev1: A1 => TypedExpression[A1, _], ev2: A2 => TypedExpression[A2, _], ev3: A3 => TypedExpression[A3, _], ev4: A4 => TypedExpression[A4, _], ev5: A5 => TypedExpression[A5, _], ev6: A6 => TypedExpression[A6, _], ev7: A7 => TypedExpression[A7, _], ev8: A8 => TypedExpression[A8, _], ev9: A9 => TypedExpression[A9, _]
) extends CompositeKey {

  def ===(ck: CompositeKey9[A1, A2, A3, A4, A5, A6, A7, A8, A9]) =
    buildEquality(ck)

  def ===(ck: (A1, A2, A3, A4, A5, A6, A7, A8, A9)) =
    buildEquality(CompositeKey9(ck._1, ck._2, ck._3, ck._4, ck._5, ck._6, ck._7, ck._8, ck._9))

  def in(cks: CompositeKey9[A1, A2, A3, A4, A5, A6, A7, A8, A9]*) = inExpr(cks)
  def inTuples(cks: (A1, A2, A3, A4, A5, A6, A7, A8, A9)*) = inExpr(cks.map(ck => CompositeKey9(ck._1, ck._2, ck._3, ck._4, ck._5, ck._6, ck._7, ck._8, ck._9)))

  def notIn(cks: CompositeKey9[A1, A2, A3, A4, A5, A6, A7, A8, A9]*) = notInExpr(cks)
  def notInTuples(cks: (A1, A2, A3, A4, A5, A6, A7, A8, A9)*) = notInExpr(cks.map(ck => CompositeKey9(ck._1, ck._2, ck._3, ck._4, ck._5, ck._6, ck._7, ck._8, ck._9)))

  protected def constantMembers: Iterable[TypedExpression[_, _]] = List(ev1(a1), ev2(a2), ev3(a3), ev4(a4), ev5(a5), ev6(a6), ev7(a7), ev8(a8), ev9(a9))
}


case class CompositeKey10[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10](a1: A1, a2: A2, a3: A3, a4: A4, a5: A5, a6: A6, a7: A7, a8: A8, a9: A9, a10: A10)(implicit
  ev1: A1 => TypedExpression[A1, _], ev2: A2 => TypedExpression[A2, _], ev3: A3 => TypedExpression[A3, _], ev4: A4 => TypedExpression[A4, _], ev5: A5 => TypedExpression[A5, _], ev6: A6 => TypedExpression[A6, _], ev7: A7 => TypedExpression[A7, _], ev8: A8 => TypedExpression[A8, _], ev9: A9 => TypedExpression[A9, _], ev10: A10 => TypedExpression[A10, _]
) extends CompositeKey {

  def ===(ck: CompositeKey10[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10]) =
    buildEquality(ck)

  def ===(ck: (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10)) =
    buildEquality(CompositeKey10(ck._1, ck._2, ck._3, ck._4, ck._5, ck._6, ck._7, ck._8, ck._9, ck._10))

  def in(cks: CompositeKey10[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10]*) = inExpr(cks)
  def inTuples(cks: (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10)*) = inExpr(cks.map(ck => CompositeKey10(ck._1, ck._2, ck._3, ck._4, ck._5, ck._6, ck._7, ck._8, ck._9, ck._10)))

  def notIn(cks: CompositeKey10[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10]*) = notInExpr(cks)
  def notInTuples(cks: (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10)*) = notInExpr(cks.map(ck => CompositeKey10(ck._1, ck._2, ck._3, ck._4, ck._5, ck._6, ck._7, ck._8, ck._9, ck._10)))

  protected def constantMembers: Iterable[TypedExpression[_, _]] = List(ev1(a1), ev2(a2), ev3(a3), ev4(a4), ev5(a5), ev6(a6), ev7(a7), ev8(a8), ev9(a9), ev10(a10))
}


case class CompositeKey11[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11](a1: A1, a2: A2, a3: A3, a4: A4, a5: A5, a6: A6, a7: A7, a8: A8, a9: A9, a10: A10, a11: A11)(implicit
  ev1: A1 => TypedExpression[A1, _], ev2: A2 => TypedExpression[A2, _], ev3: A3 => TypedExpression[A3, _], ev4: A4 => TypedExpression[A4, _], ev5: A5 => TypedExpression[A5, _], ev6: A6 => TypedExpression[A6, _], ev7: A7 => TypedExpression[A7, _], ev8: A8 => TypedExpression[A8, _], ev9: A9 => TypedExpression[A9, _], ev10: A10 => TypedExpression[A10, _], ev11: A11 => TypedExpression[A11, _]
) extends CompositeKey {

  def ===(ck: CompositeKey11[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11]) =
    buildEquality(ck)

  def ===(ck: (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11)) =
    buildEquality(CompositeKey11(ck._1, ck._2, ck._3, ck._4, ck._5, ck._6, ck._7, ck._8, ck._9, ck._10, ck._11))

  def in(cks: CompositeKey11[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11]*) = inExpr(cks)
  def inTuples(cks: (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11)*) = inExpr(cks.map(ck => CompositeKey11(ck._1, ck._2, ck._3, ck._4, ck._5, ck._6, ck._7, ck._8, ck._9, ck._10, ck._11)))

  def notIn(cks: CompositeKey11[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11]*) = notInExpr(cks)
  def notInTuples(cks: (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11)*) = notInExpr(cks.map(ck => CompositeKey11(ck._1, ck._2, ck._3, ck._4, ck._5, ck._6, ck._7, ck._8, ck._9, ck._10, ck._11)))

  protected def constantMembers: Iterable[TypedExpression[_, _]] = List(ev1(a1), ev2(a2), ev3(a3), ev4(a4), ev5(a5), ev6(a6), ev7(a7), ev8(a8), ev9(a9), ev10(a10), ev11(a11))
}


case class CompositeKey12[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12](a1: A1, a2: A2, a3: A3, a4: A4, a5: A5, a6: A6, a7: A7, a8: A8, a9: A9, a10: A10, a11: A11, a12: A12)(implicit
  ev1: A1 => TypedExpression[A1, _], ev2: A2 => TypedExpression[A2, _], ev3: A3 => TypedExpression[A3, _], ev4: A4 => TypedExpression[A4, _], ev5: A5 => TypedExpression[A5, _], ev6: A6 => TypedExpression[A6, _], ev7: A7 => TypedExpression[A7, _], ev8: A8 => TypedExpression[A8, _], ev9: A9 => TypedExpression[A9, _], ev10: A10 => TypedExpression[A10, _], ev11: A11 => TypedExpression[A11, _], ev12: A12 => TypedExpression[A12, _]
) extends CompositeKey {

  def ===(ck: CompositeKey12[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12]) =
    buildEquality(ck)

  def ===(ck: (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12)) =
    buildEquality(CompositeKey12(ck._1, ck._2, ck._3, ck._4, ck._5, ck._6, ck._7, ck._8, ck._9, ck._10, ck._11, ck._12))

  def in(cks: CompositeKey12[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12]*) = inExpr(cks)
  def inTuples(cks: (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12)*) = inExpr(cks.map(ck => CompositeKey12(ck._1, ck._2, ck._3, ck._4, ck._5, ck._6, ck._7, ck._8, ck._9, ck._10, ck._11, ck._12)))

  def notIn(cks: CompositeKey12[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12]*) = notInExpr(cks)
  def notInTuples(cks: (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12)*) = notInExpr(cks.map(ck => CompositeKey12(ck._1, ck._2, ck._3, ck._4, ck._5, ck._6, ck._7, ck._8, ck._9, ck._10, ck._11, ck._12)))

  protected def constantMembers: Iterable[TypedExpression[_, _]] = List(ev1(a1), ev2(a2), ev3(a3), ev4(a4), ev5(a5), ev6(a6), ev7(a7), ev8(a8), ev9(a9), ev10(a10), ev11(a11), ev12(a12))
}


case class CompositeKey13[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13](a1: A1, a2: A2, a3: A3, a4: A4, a5: A5, a6: A6, a7: A7, a8: A8, a9: A9, a10: A10, a11: A11, a12: A12, a13: A13)(implicit
  ev1: A1 => TypedExpression[A1, _], ev2: A2 => TypedExpression[A2, _], ev3: A3 => TypedExpression[A3, _], ev4: A4 => TypedExpression[A4, _], ev5: A5 => TypedExpression[A5, _], ev6: A6 => TypedExpression[A6, _], ev7: A7 => TypedExpression[A7, _], ev8: A8 => TypedExpression[A8, _], ev9: A9 => TypedExpression[A9, _], ev10: A10 => TypedExpression[A10, _], ev11: A11 => TypedExpression[A11, _], ev12: A12 => TypedExpression[A12, _], ev13: A13 => TypedExpression[A13, _]
) extends CompositeKey {

  def ===(ck: CompositeKey13[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13]) =
    buildEquality(ck)

  def ===(ck: (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13)) =
    buildEquality(CompositeKey13(ck._1, ck._2, ck._3, ck._4, ck._5, ck._6, ck._7, ck._8, ck._9, ck._10, ck._11, ck._12, ck._13))

  def in(cks: CompositeKey13[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13]*) = inExpr(cks)
  def inTuples(cks: (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13)*) = inExpr(cks.map(ck => CompositeKey13(ck._1, ck._2, ck._3, ck._4, ck._5, ck._6, ck._7, ck._8, ck._9, ck._10, ck._11, ck._12, ck._13)))

  def notIn(cks: CompositeKey13[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13]*) = notInExpr(cks)
  def notInTuples(cks: (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13)*) = notInExpr(cks.map(ck => CompositeKey13(ck._1, ck._2, ck._3, ck._4, ck._5, ck._6, ck._7, ck._8, ck._9, ck._10, ck._11, ck._12, ck._13)))

  protected def constantMembers: Iterable[TypedExpression[_, _]] = List(ev1(a1), ev2(a2), ev3(a3), ev4(a4), ev5(a5), ev6(a6), ev7(a7), ev8(a8), ev9(a9), ev10(a10), ev11(a11), ev12(a12), ev13(a13))
}


case class CompositeKey14[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14](a1: A1, a2: A2, a3: A3, a4: A4, a5: A5, a6: A6, a7: A7, a8: A8, a9: A9, a10: A10, a11: A11, a12: A12, a13: A13, a14: A14)(implicit
  ev1: A1 => TypedExpression[A1, _], ev2: A2 => TypedExpression[A2, _], ev3: A3 => TypedExpression[A3, _], ev4: A4 => TypedExpression[A4, _], ev5: A5 => TypedExpression[A5, _], ev6: A6 => TypedExpression[A6, _], ev7: A7 => TypedExpression[A7, _], ev8: A8 => TypedExpression[A8, _], ev9: A9 => TypedExpression[A9, _], ev10: A10 => TypedExpression[A10, _], ev11: A11 => TypedExpression[A11, _], ev12: A12 => TypedExpression[A12, _], ev13: A13 => TypedExpression[A13, _], ev14: A14 => TypedExpression[A14, _]
) extends CompositeKey {

  def ===(ck: CompositeKey14[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14]) =
    buildEquality(ck)

  def ===(ck: (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14)) =
    buildEquality(CompositeKey14(ck._1, ck._2, ck._3, ck._4, ck._5, ck._6, ck._7, ck._8, ck._9, ck._10, ck._11, ck._12, ck._13, ck._14))

  def in(cks: CompositeKey14[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14]*) = inExpr(cks)
  def inTuples(cks: (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14)*) = inExpr(cks.map(ck => CompositeKey14(ck._1, ck._2, ck._3, ck._4, ck._5, ck._6, ck._7, ck._8, ck._9, ck._10, ck._11, ck._12, ck._13, ck._14)))

  def notIn(cks: CompositeKey14[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14]*) = notInExpr(cks)
  def notInTuples(cks: (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14)*) = notInExpr(cks.map(ck => CompositeKey14(ck._1, ck._2, ck._3, ck._4, ck._5, ck._6, ck._7, ck._8, ck._9, ck._10, ck._11, ck._12, ck._13, ck._14)))

  protected def constantMembers: Iterable[TypedExpression[_, _]] = List(ev1(a1), ev2(a2), ev3(a3), ev4(a4), ev5(a5), ev6(a6), ev7(a7), ev8(a8), ev9(a9), ev10(a10), ev11(a11), ev12(a12), ev13(a13), ev14(a14))
}


case class CompositeKey15[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15](a1: A1, a2: A2, a3: A3, a4: A4, a5: A5, a6: A6, a7: A7, a8: A8, a9: A9, a10: A10, a11: A11, a12: A12, a13: A13, a14: A14, a15: A15)(implicit
  ev1: A1 => TypedExpression[A1, _], ev2: A2 => TypedExpression[A2, _], ev3: A3 => TypedExpression[A3, _], ev4: A4 => TypedExpression[A4, _], ev5: A5 => TypedExpression[A5, _], ev6: A6 => TypedExpression[A6, _], ev7: A7 => TypedExpression[A7, _], ev8: A8 => TypedExpression[A8, _], ev9: A9 => TypedExpression[A9, _], ev10: A10 => TypedExpression[A10, _], ev11: A11 => TypedExpression[A11, _], ev12: A12 => TypedExpression[A12, _], ev13: A13 => TypedExpression[A13, _], ev14: A14 => TypedExpression[A14, _], ev15: A15 => TypedExpression[A15, _]
) extends CompositeKey {

  def ===(ck: CompositeKey15[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15]) =
    buildEquality(ck)

  def ===(ck: (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15)) =
    buildEquality(CompositeKey15(ck._1, ck._2, ck._3, ck._4, ck._5, ck._6, ck._7, ck._8, ck._9, ck._10, ck._11, ck._12, ck._13, ck._14, ck._15))

  def in(cks: CompositeKey15[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15]*) = inExpr(cks)
  def inTuples(cks: (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15)*) = inExpr(cks.map(ck => CompositeKey15(ck._1, ck._2, ck._3, ck._4, ck._5, ck._6, ck._7, ck._8, ck._9, ck._10, ck._11, ck._12, ck._13, ck._14, ck._15)))

  def notIn(cks: CompositeKey15[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15]*) = notInExpr(cks)
  def notInTuples(cks: (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15)*) = notInExpr(cks.map(ck => CompositeKey15(ck._1, ck._2, ck._3, ck._4, ck._5, ck._6, ck._7, ck._8, ck._9, ck._10, ck._11, ck._12, ck._13, ck._14, ck._15)))

  protected def constantMembers: Iterable[TypedExpression[_, _]] = List(ev1(a1), ev2(a2), ev3(a3), ev4(a4), ev5(a5), ev6(a6), ev7(a7), ev8(a8), ev9(a9), ev10(a10), ev11(a11), ev12(a12), ev13(a13), ev14(a14), ev15(a15))
}


case class CompositeKey16[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16](a1: A1, a2: A2, a3: A3, a4: A4, a5: A5, a6: A6, a7: A7, a8: A8, a9: A9, a10: A10, a11: A11, a12: A12, a13: A13, a14: A14, a15: A15, a16: A16)(implicit
  ev1: A1 => TypedExpression[A1, _], ev2: A2 => TypedExpression[A2, _], ev3: A3 => TypedExpression[A3, _], ev4: A4 => TypedExpression[A4, _], ev5: A5 => TypedExpression[A5, _], ev6: A6 => TypedExpression[A6, _], ev7: A7 => TypedExpression[A7, _], ev8: A8 => TypedExpression[A8, _], ev9: A9 => TypedExpression[A9, _], ev10: A10 => TypedExpression[A10, _], ev11: A11 => TypedExpression[A11, _], ev12: A12 => TypedExpression[A12, _], ev13: A13 => TypedExpression[A13, _], ev14: A14 => TypedExpression[A14, _], ev15: A15 => TypedExpression[A15, _], ev16: A16 => TypedExpression[A16, _]
) extends CompositeKey {

  def ===(ck: CompositeKey16[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16]) =
    buildEquality(ck)

  def ===(ck: (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16)) =
    buildEquality(CompositeKey16(ck._1, ck._2, ck._3, ck._4, ck._5, ck._6, ck._7, ck._8, ck._9, ck._10, ck._11, ck._12, ck._13, ck._14, ck._15, ck._16))

  def in(cks: CompositeKey16[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16]*) = inExpr(cks)
  def inTuples(cks: (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16)*) = inExpr(cks.map(ck => CompositeKey16(ck._1, ck._2, ck._3, ck._4, ck._5, ck._6, ck._7, ck._8, ck._9, ck._10, ck._11, ck._12, ck._13, ck._14, ck._15, ck._16)))

  def notIn(cks: CompositeKey16[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16]*) = notInExpr(cks)
  def notInTuples(cks: (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16)*) = notInExpr(cks.map(ck => CompositeKey16(ck._1, ck._2, ck._3, ck._4, ck._5, ck._6, ck._7, ck._8, ck._9, ck._10, ck._11, ck._12, ck._13, ck._14, ck._15, ck._16)))

  protected def constantMembers: Iterable[TypedExpression[_, _]] = List(ev1(a1), ev2(a2), ev3(a3), ev4(a4), ev5(a5), ev6(a6), ev7(a7), ev8(a8), ev9(a9), ev10(a10), ev11(a11), ev12(a12), ev13(a13), ev14(a14), ev15(a15), ev16(a16))
}


case class CompositeKey17[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17](a1: A1, a2: A2, a3: A3, a4: A4, a5: A5, a6: A6, a7: A7, a8: A8, a9: A9, a10: A10, a11: A11, a12: A12, a13: A13, a14: A14, a15: A15, a16: A16, a17: A17)(implicit
  ev1: A1 => TypedExpression[A1, _], ev2: A2 => TypedExpression[A2, _], ev3: A3 => TypedExpression[A3, _], ev4: A4 => TypedExpression[A4, _], ev5: A5 => TypedExpression[A5, _], ev6: A6 => TypedExpression[A6, _], ev7: A7 => TypedExpression[A7, _], ev8: A8 => TypedExpression[A8, _], ev9: A9 => TypedExpression[A9, _], ev10: A10 => TypedExpression[A10, _], ev11: A11 => TypedExpression[A11, _], ev12: A12 => TypedExpression[A12, _], ev13: A13 => TypedExpression[A13, _], ev14: A14 => TypedExpression[A14, _], ev15: A15 => TypedExpression[A15, _], ev16: A16 => TypedExpression[A16, _], ev17: A17 => TypedExpression[A17, _]
) extends CompositeKey {

  def ===(ck: CompositeKey17[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17]) =
    buildEquality(ck)

  def ===(ck: (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17)) =
    buildEquality(CompositeKey17(ck._1, ck._2, ck._3, ck._4, ck._5, ck._6, ck._7, ck._8, ck._9, ck._10, ck._11, ck._12, ck._13, ck._14, ck._15, ck._16, ck._17))

  def in(cks: CompositeKey17[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17]*) = inExpr(cks)
  def inTuples(cks: (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17)*) = inExpr(cks.map(ck => CompositeKey17(ck._1, ck._2, ck._3, ck._4, ck._5, ck._6, ck._7, ck._8, ck._9, ck._10, ck._11, ck._12, ck._13, ck._14, ck._15, ck._16, ck._17)))

  def notIn(cks: CompositeKey17[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17]*) = notInExpr(cks)
  def notInTuples(cks: (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17)*) = notInExpr(cks.map(ck => CompositeKey17(ck._1, ck._2, ck._3, ck._4, ck._5, ck._6, ck._7, ck._8, ck._9, ck._10, ck._11, ck._12, ck._13, ck._14, ck._15, ck._16, ck._17)))

  protected def constantMembers: Iterable[TypedExpression[_, _]] = List(ev1(a1), ev2(a2), ev3(a3), ev4(a4), ev5(a5), ev6(a6), ev7(a7), ev8(a8), ev9(a9), ev10(a10), ev11(a11), ev12(a12), ev13(a13), ev14(a14), ev15(a15), ev16(a16), ev17(a17))
}


case class CompositeKey18[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18](a1: A1, a2: A2, a3: A3, a4: A4, a5: A5, a6: A6, a7: A7, a8: A8, a9: A9, a10: A10, a11: A11, a12: A12, a13: A13, a14: A14, a15: A15, a16: A16, a17: A17, a18: A18)(implicit
  ev1: A1 => TypedExpression[A1, _], ev2: A2 => TypedExpression[A2, _], ev3: A3 => TypedExpression[A3, _], ev4: A4 => TypedExpression[A4, _], ev5: A5 => TypedExpression[A5, _], ev6: A6 => TypedExpression[A6, _], ev7: A7 => TypedExpression[A7, _], ev8: A8 => TypedExpression[A8, _], ev9: A9 => TypedExpression[A9, _], ev10: A10 => TypedExpression[A10, _], ev11: A11 => TypedExpression[A11, _], ev12: A12 => TypedExpression[A12, _], ev13: A13 => TypedExpression[A13, _], ev14: A14 => TypedExpression[A14, _], ev15: A15 => TypedExpression[A15, _], ev16: A16 => TypedExpression[A16, _], ev17: A17 => TypedExpression[A17, _], ev18: A18 => TypedExpression[A18, _]
) extends CompositeKey {

  def ===(ck: CompositeKey18[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18]) =
    buildEquality(ck)

  def ===(ck: (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18)) =
    buildEquality(CompositeKey18(ck._1, ck._2, ck._3, ck._4, ck._5, ck._6, ck._7, ck._8, ck._9, ck._10, ck._11, ck._12, ck._13, ck._14, ck._15, ck._16, ck._17, ck._18))

  def in(cks: CompositeKey18[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18]*) = inExpr(cks)
  def inTuples(cks: (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18)*) = inExpr(cks.map(ck => CompositeKey18(ck._1, ck._2, ck._3, ck._4, ck._5, ck._6, ck._7, ck._8, ck._9, ck._10, ck._11, ck._12, ck._13, ck._14, ck._15, ck._16, ck._17, ck._18)))

  def notIn(cks: CompositeKey18[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18]*) = notInExpr(cks)
  def notInTuples(cks: (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18)*) = notInExpr(cks.map(ck => CompositeKey18(ck._1, ck._2, ck._3, ck._4, ck._5, ck._6, ck._7, ck._8, ck._9, ck._10, ck._11, ck._12, ck._13, ck._14, ck._15, ck._16, ck._17, ck._18)))

  protected def constantMembers: Iterable[TypedExpression[_, _]] = List(ev1(a1), ev2(a2), ev3(a3), ev4(a4), ev5(a5), ev6(a6), ev7(a7), ev8(a8), ev9(a9), ev10(a10), ev11(a11), ev12(a12), ev13(a13), ev14(a14), ev15(a15), ev16(a16), ev17(a17), ev18(a18))
}


case class CompositeKey19[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19](a1: A1, a2: A2, a3: A3, a4: A4, a5: A5, a6: A6, a7: A7, a8: A8, a9: A9, a10: A10, a11: A11, a12: A12, a13: A13, a14: A14, a15: A15, a16: A16, a17: A17, a18: A18, a19: A19)(implicit
  ev1: A1 => TypedExpression[A1, _], ev2: A2 => TypedExpression[A2, _], ev3: A3 => TypedExpression[A3, _], ev4: A4 => TypedExpression[A4, _], ev5: A5 => TypedExpression[A5, _], ev6: A6 => TypedExpression[A6, _], ev7: A7 => TypedExpression[A7, _], ev8: A8 => TypedExpression[A8, _], ev9: A9 => TypedExpression[A9, _], ev10: A10 => TypedExpression[A10, _], ev11: A11 => TypedExpression[A11, _], ev12: A12 => TypedExpression[A12, _], ev13: A13 => TypedExpression[A13, _], ev14: A14 => TypedExpression[A14, _], ev15: A15 => TypedExpression[A15, _], ev16: A16 => TypedExpression[A16, _], ev17: A17 => TypedExpression[A17, _], ev18: A18 => TypedExpression[A18, _], ev19: A19 => TypedExpression[A19, _]
) extends CompositeKey {

  def ===(ck: CompositeKey19[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19]) =
    buildEquality(ck)

  def ===(ck: (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19)) =
    buildEquality(CompositeKey19(ck._1, ck._2, ck._3, ck._4, ck._5, ck._6, ck._7, ck._8, ck._9, ck._10, ck._11, ck._12, ck._13, ck._14, ck._15, ck._16, ck._17, ck._18, ck._19))

  def in(cks: CompositeKey19[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19]*) = inExpr(cks)
  def inTuples(cks: (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19)*) = inExpr(cks.map(ck => CompositeKey19(ck._1, ck._2, ck._3, ck._4, ck._5, ck._6, ck._7, ck._8, ck._9, ck._10, ck._11, ck._12, ck._13, ck._14, ck._15, ck._16, ck._17, ck._18, ck._19)))

  def notIn(cks: CompositeKey19[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19]*) = notInExpr(cks)
  def notInTuples(cks: (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19)*) = notInExpr(cks.map(ck => CompositeKey19(ck._1, ck._2, ck._3, ck._4, ck._5, ck._6, ck._7, ck._8, ck._9, ck._10, ck._11, ck._12, ck._13, ck._14, ck._15, ck._16, ck._17, ck._18, ck._19)))

  protected def constantMembers: Iterable[TypedExpression[_, _]] = List(ev1(a1), ev2(a2), ev3(a3), ev4(a4), ev5(a5), ev6(a6), ev7(a7), ev8(a8), ev9(a9), ev10(a10), ev11(a11), ev12(a12), ev13(a13), ev14(a14), ev15(a15), ev16(a16), ev17(a17), ev18(a18), ev19(a19))
}


case class CompositeKey20[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20](a1: A1, a2: A2, a3: A3, a4: A4, a5: A5, a6: A6, a7: A7, a8: A8, a9: A9, a10: A10, a11: A11, a12: A12, a13: A13, a14: A14, a15: A15, a16: A16, a17: A17, a18: A18, a19: A19, a20: A20)(implicit
  ev1: A1 => TypedExpression[A1, _], ev2: A2 => TypedExpression[A2, _], ev3: A3 => TypedExpression[A3, _], ev4: A4 => TypedExpression[A4, _], ev5: A5 => TypedExpression[A5, _], ev6: A6 => TypedExpression[A6, _], ev7: A7 => TypedExpression[A7, _], ev8: A8 => TypedExpression[A8, _], ev9: A9 => TypedExpression[A9, _], ev10: A10 => TypedExpression[A10, _], ev11: A11 => TypedExpression[A11, _], ev12: A12 => TypedExpression[A12, _], ev13: A13 => TypedExpression[A13, _], ev14: A14 => TypedExpression[A14, _], ev15: A15 => TypedExpression[A15, _], ev16: A16 => TypedExpression[A16, _], ev17: A17 => TypedExpression[A17, _], ev18: A18 => TypedExpression[A18, _], ev19: A19 => TypedExpression[A19, _], ev20: A20 => TypedExpression[A20, _]
) extends CompositeKey {

  def ===(ck: CompositeKey20[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20]) =
    buildEquality(ck)

  def ===(ck: (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20)) =
    buildEquality(CompositeKey20(ck._1, ck._2, ck._3, ck._4, ck._5, ck._6, ck._7, ck._8, ck._9, ck._10, ck._11, ck._12, ck._13, ck._14, ck._15, ck._16, ck._17, ck._18, ck._19, ck._20))

  def in(cks: CompositeKey20[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20]*) = inExpr(cks)
  def inTuples(cks: (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20)*) = inExpr(cks.map(ck => CompositeKey20(ck._1, ck._2, ck._3, ck._4, ck._5, ck._6, ck._7, ck._8, ck._9, ck._10, ck._11, ck._12, ck._13, ck._14, ck._15, ck._16, ck._17, ck._18, ck._19, ck._20)))

  def notIn(cks: CompositeKey20[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20]*) = notInExpr(cks)
  def notInTuples(cks: (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20)*) = notInExpr(cks.map(ck => CompositeKey20(ck._1, ck._2, ck._3, ck._4, ck._5, ck._6, ck._7, ck._8, ck._9, ck._10, ck._11, ck._12, ck._13, ck._14, ck._15, ck._16, ck._17, ck._18, ck._19, ck._20)))

  protected def constantMembers: Iterable[TypedExpression[_, _]] = List(ev1(a1), ev2(a2), ev3(a3), ev4(a4), ev5(a5), ev6(a6), ev7(a7), ev8(a8), ev9(a9), ev10(a10), ev11(a11), ev12(a12), ev13(a13), ev14(a14), ev15(a15), ev16(a16), ev17(a17), ev18(a18), ev19(a19), ev20(a20))
}


case class CompositeKey21[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21](a1: A1, a2: A2, a3: A3, a4: A4, a5: A5, a6: A6, a7: A7, a8: A8, a9: A9, a10: A10, a11: A11, a12: A12, a13: A13, a14: A14, a15: A15, a16: A16, a17: A17, a18: A18, a19: A19, a20: A20, a21: A21)(implicit
  ev1: A1 => TypedExpression[A1, _], ev2: A2 => TypedExpression[A2, _], ev3: A3 => TypedExpression[A3, _], ev4: A4 => TypedExpression[A4, _], ev5: A5 => TypedExpression[A5, _], ev6: A6 => TypedExpression[A6, _], ev7: A7 => TypedExpression[A7, _], ev8: A8 => TypedExpression[A8, _], ev9: A9 => TypedExpression[A9, _], ev10: A10 => TypedExpression[A10, _], ev11: A11 => TypedExpression[A11, _], ev12: A12 => TypedExpression[A12, _], ev13: A13 => TypedExpression[A13, _], ev14: A14 => TypedExpression[A14, _], ev15: A15 => TypedExpression[A15, _], ev16: A16 => TypedExpression[A16, _], ev17: A17 => TypedExpression[A17, _], ev18: A18 => TypedExpression[A18, _], ev19: A19 => TypedExpression[A19, _], ev20: A20 => TypedExpression[A20, _], ev21: A21 => TypedExpression[A21, _]
) extends CompositeKey {

  def ===(ck: CompositeKey21[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21]) =
    buildEquality(ck)

  def ===(ck: (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21)) =
    buildEquality(CompositeKey21(ck._1, ck._2, ck._3, ck._4, ck._5, ck._6, ck._7, ck._8, ck._9, ck._10, ck._11, ck._12, ck._13, ck._14, ck._15, ck._16, ck._17, ck._18, ck._19, ck._20, ck._21))

  def in(cks: CompositeKey21[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21]*) = inExpr(cks)
  def inTuples(cks: (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21)*) = inExpr(cks.map(ck => CompositeKey21(ck._1, ck._2, ck._3, ck._4, ck._5, ck._6, ck._7, ck._8, ck._9, ck._10, ck._11, ck._12, ck._13, ck._14, ck._15, ck._16, ck._17, ck._18, ck._19, ck._20, ck._21)))

  def notIn(cks: CompositeKey21[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21]*) = notInExpr(cks)
  def notInTuples(cks: (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21)*) = notInExpr(cks.map(ck => CompositeKey21(ck._1, ck._2, ck._3, ck._4, ck._5, ck._6, ck._7, ck._8, ck._9, ck._10, ck._11, ck._12, ck._13, ck._14, ck._15, ck._16, ck._17, ck._18, ck._19, ck._20, ck._21)))

  protected def constantMembers: Iterable[TypedExpression[_, _]] = List(ev1(a1), ev2(a2), ev3(a3), ev4(a4), ev5(a5), ev6(a6), ev7(a7), ev8(a8), ev9(a9), ev10(a10), ev11(a11), ev12(a12), ev13(a13), ev14(a14), ev15(a15), ev16(a16), ev17(a17), ev18(a18), ev19(a19), ev20(a20), ev21(a21))
}


case class CompositeKey22[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22](a1: A1, a2: A2, a3: A3, a4: A4, a5: A5, a6: A6, a7: A7, a8: A8, a9: A9, a10: A10, a11: A11, a12: A12, a13: A13, a14: A14, a15: A15, a16: A16, a17: A17, a18: A18, a19: A19, a20: A20, a21: A21, a22: A22)(implicit
  ev1: A1 => TypedExpression[A1, _], ev2: A2 => TypedExpression[A2, _], ev3: A3 => TypedExpression[A3, _], ev4: A4 => TypedExpression[A4, _], ev5: A5 => TypedExpression[A5, _], ev6: A6 => TypedExpression[A6, _], ev7: A7 => TypedExpression[A7, _], ev8: A8 => TypedExpression[A8, _], ev9: A9 => TypedExpression[A9, _], ev10: A10 => TypedExpression[A10, _], ev11: A11 => TypedExpression[A11, _], ev12: A12 => TypedExpression[A12, _], ev13: A13 => TypedExpression[A13, _], ev14: A14 => TypedExpression[A14, _], ev15: A15 => TypedExpression[A15, _], ev16: A16 => TypedExpression[A16, _], ev17: A17 => TypedExpression[A17, _], ev18: A18 => TypedExpression[A18, _], ev19: A19 => TypedExpression[A19, _], ev20: A20 => TypedExpression[A20, _], ev21: A21 => TypedExpression[A21, _], ev22: A22 => TypedExpression[A22, _]
) extends CompositeKey {

  def ===(ck: CompositeKey22[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22]) =
    buildEquality(ck)

  def ===(ck: (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22)) =
    buildEquality(CompositeKey22(ck._1, ck._2, ck._3, ck._4, ck._5, ck._6, ck._7, ck._8, ck._9, ck._10, ck._11, ck._12, ck._13, ck._14, ck._15, ck._16, ck._17, ck._18, ck._19, ck._20, ck._21, ck._22))

  def in(cks: CompositeKey22[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22]*) = inExpr(cks)
  def inTuples(cks: (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22)*) = inExpr(cks.map(ck => CompositeKey22(ck._1, ck._2, ck._3, ck._4, ck._5, ck._6, ck._7, ck._8, ck._9, ck._10, ck._11, ck._12, ck._13, ck._14, ck._15, ck._16, ck._17, ck._18, ck._19, ck._20, ck._21, ck._22)))

  def notIn(cks: CompositeKey22[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22]*) = notInExpr(cks)
  def notInTuples(cks: (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22)*) = notInExpr(cks.map(ck => CompositeKey22(ck._1, ck._2, ck._3, ck._4, ck._5, ck._6, ck._7, ck._8, ck._9, ck._10, ck._11, ck._12, ck._13, ck._14, ck._15, ck._16, ck._17, ck._18, ck._19, ck._20, ck._21, ck._22)))

  protected def constantMembers: Iterable[TypedExpression[_, _]] = List(ev1(a1), ev2(a2), ev3(a3), ev4(a4), ev5(a5), ev6(a6), ev7(a7), ev8(a8), ev9(a9), ev10(a10), ev11(a11), ev12(a12), ev13(a13), ev14(a14), ev15(a15), ev16(a16), ev17(a17), ev18(a18), ev19(a19), ev20(a20), ev21(a21), ev22(a22))
}

