/*
 * Decompiled with CFR 0.152.
 */
package org.squeryl.logging;

import java.io.Serializable;
import org.squeryl.Query;
import org.squeryl.Schema;
import org.squeryl.Table;
import org.squeryl.dsl.CompositeKey2;
import org.squeryl.dsl.DeOptionizer;
import org.squeryl.dsl.GroupWithMeasures;
import org.squeryl.dsl.ast.BaseColumnAttributeAssignment;
import org.squeryl.dsl.ast.ExpressionNode;
import org.squeryl.dsl.ast.LogicalBoolean;
import org.squeryl.dsl.ast.OrderByArg;
import org.squeryl.dsl.ast.UpdateAssignment;
import org.squeryl.dsl.fsm.Conditioned;
import org.squeryl.internals.AttributeValidOnNumericalColumn;
import org.squeryl.logging.Measure$;
import org.squeryl.logging.StatLine;
import org.squeryl.logging.Statement;
import org.squeryl.logging.StatementInvocation;
import org.squeryl.logging.StatementInvocationEvent;
import org.squeryl.logging.StatsSchemaTypeMode$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product2;
import scala.Product4;
import scala.Some;
import scala.collection.Seq;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;

public final class StatsSchema$
extends Schema {
    public static StatsSchema$ MODULE$;
    private final Table<Statement> statements;
    private final Table<StatementInvocation> statementInvocations;

    static {
        new StatsSchema$();
    }

    @Override
    public void drop() {
        super.drop();
    }

    public Table<Statement> statements() {
        return this.statements;
    }

    public Table<StatementInvocation> statementInvocations() {
        return this.statementInvocations;
    }

    public Query<GroupWithMeasures<Product2<Object, Object>, Product4<Option<Object>, Object, Option<Object>, Object>>> invocationStats() {
        return StatsSchemaTypeMode$.MODULE$.from(this.statementInvocations(), (Function1 & Serializable & scala.Serializable)si -> StatsSchemaTypeMode$.MODULE$.groupBy((Function0 & Serializable & scala.Serializable)() -> StatsSchemaTypeMode$.MODULE$.intToTE(si.statementHash()), (Function0 & Serializable & scala.Serializable)() -> StatsSchemaTypeMode$.MODULE$.intToTE(si.statementHashCollisionNumber())).compute((Function0 & Serializable & scala.Serializable)() -> StatsSchemaTypeMode$.MODULE$.avg(si.executeTime(), StatsSchemaTypeMode$.MODULE$.optionDoubleTEF()), (Function0 & Serializable & scala.Serializable)() -> StatsSchemaTypeMode$.MODULE$.count(), (Function0 & Serializable & scala.Serializable)() -> StatsSchemaTypeMode$.MODULE$.sum(si.executeTime(), StatsSchemaTypeMode$.MODULE$.optionLongTEF()), (Function0 & Serializable & scala.Serializable)() -> StatsSchemaTypeMode$.MODULE$.nvl(StatsSchemaTypeMode$.MODULE$.avg(StatsSchemaTypeMode$.MODULE$.optionIntToTE(si.rowCount()), StatsSchemaTypeMode$.MODULE$.optionFloatTEF()), StatsSchemaTypeMode$.MODULE$.intToTE(0), (DeOptionizer)((Object)StatsSchemaTypeMode$.MODULE$.optionFloatTEF()))));
    }

    public Query<StatLine> topRankingStatements(int topN, Enumeration.Value measure) {
        return StatsSchemaTypeMode$.MODULE$.from(this.invocationStats(), this.statements(), (Function2 & Serializable & scala.Serializable)(si, s) -> StatsSchemaTypeMode$.MODULE$.where((Function0<LogicalBoolean>)(Function0 & Serializable & scala.Serializable)() -> StatsSchemaTypeMode$.MODULE$.intToTE(((Product2)si.key())._1$mcI$sp()).$eq$eq$eq(StatsSchemaTypeMode$.MODULE$.intToTE(s.hash()), StatsSchemaTypeMode$.MODULE$.numericComparisonEvidence()).and(StatsSchemaTypeMode$.MODULE$.intToTE(((Product2)si.key())._2$mcI$sp()).$eq$eq$eq(StatsSchemaTypeMode$.MODULE$.intToTE(s.statementHashCollisionNumber()), StatsSchemaTypeMode$.MODULE$.numericComparisonEvidence()))).select((Function0 & Serializable & scala.Serializable)() -> new StatLine((Statement)s, BoxesRunTime.unboxToDouble((Object)((Option)((Product4)si.measures())._1()).get()), BoxesRunTime.unboxToLong((Object)((Product4)si.measures())._2()), BoxesRunTime.unboxToLong((Object)((Option)((Product4)si.measures())._3()).get()), BoxesRunTime.unboxToFloat((Object)((Product4)si.measures())._4()))).orderBy((Function0<ExpressionNode>)(Function0 & Serializable & scala.Serializable)() -> {
            OrderByArg orderByArg;
            Enumeration.Value value = measure;
            Enumeration.Value value2 = Measure$.MODULE$.AvgExecTime();
            Enumeration.Value value3 = value;
            if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
                orderByArg = StatsSchemaTypeMode$.MODULE$.typedExpression2OrderByArg(((Product4)si.measures())._1(), (Function1 & Serializable & scala.Serializable)f -> StatsSchemaTypeMode$.MODULE$.optionDoubleToTE((Option<Object>)f)).desc();
            } else {
                Enumeration.Value value4 = Measure$.MODULE$.InvocationCount();
                Enumeration.Value value5 = value;
                if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
                    orderByArg = StatsSchemaTypeMode$.MODULE$.typedExpression2OrderByArg(((Product4)si.measures())._2(), (Function1 & Serializable & scala.Serializable)f -> StatsSchemaTypeMode$.MODULE$.longToTE(BoxesRunTime.unboxToLong((Object)f))).desc();
                } else {
                    Enumeration.Value value6 = Measure$.MODULE$.CumulativeExecutionTime();
                    Enumeration.Value value7 = value;
                    if (!(value6 != null ? !value6.equals(value7) : value7 != null)) {
                        orderByArg = StatsSchemaTypeMode$.MODULE$.typedExpression2OrderByArg(((Product4)si.measures())._3(), (Function1 & Serializable & scala.Serializable)f -> StatsSchemaTypeMode$.MODULE$.optionLongToTE((Option<Object>)f)).desc();
                    } else {
                        Enumeration.Value value8 = Measure$.MODULE$.AvgResultSetSize();
                        Enumeration.Value value9 = value;
                        if (!(value8 != null ? !value8.equals(value9) : value9 != null)) {
                            orderByArg = StatsSchemaTypeMode$.MODULE$.typedExpression2OrderByArg(((Product4)si.measures())._4(), (Function1 & Serializable & scala.Serializable)f -> StatsSchemaTypeMode$.MODULE$.floatToTE(BoxesRunTime.unboxToFloat((Object)f))).desc();
                        } else {
                            throw new MatchError((Object)value);
                        }
                    }
                }
            }
            return StatsSchemaTypeMode$.MODULE$.orderByArg2OrderByExpression(orderByArg);
        })).page(0, topN);
    }

    public String recordStatementInvocation(StatementInvocationEvent sie) {
        CompositeKey2<Object, Object> statementK = this._lookupOrCreateStatementAndReturnKey(sie);
        StatementInvocation si = new StatementInvocation(sie, BoxesRunTime.unboxToInt((Object)statementK.a1()), BoxesRunTime.unboxToInt((Object)statementK.a2()));
        this.statementInvocations().insert(si);
        return si.id();
    }

    public int recordEndOfIteration(String statementInvocationId, long iterationEndTime, int rowCount, boolean iterationCompleted) {
        return StatsSchemaTypeMode$.MODULE$.update(this.statementInvocations(), (Function1 & Serializable & scala.Serializable)si -> StatsSchemaTypeMode$.MODULE$.where((Function0<LogicalBoolean>)(Function0 & Serializable & scala.Serializable)() -> StatsSchemaTypeMode$.MODULE$.stringToTE(si.id()).$eq$eq$eq(StatsSchemaTypeMode$.MODULE$.stringToTE(statementInvocationId), StatsSchemaTypeMode$.MODULE$.stringComparisonEvidence())).set((Seq<UpdateAssignment>)Predef$.MODULE$.wrapRefArray((Object[])new UpdateAssignment[]{StatsSchemaTypeMode$.MODULE$.optionLongToTE(si.iterationEndTime()).$colon$eq(new Some((Object)BoxesRunTime.boxToLong((long)iterationEndTime)), (Function1 & Serializable & scala.Serializable)f -> StatsSchemaTypeMode$.MODULE$.optionLongToTE((Option<Object>)f)), StatsSchemaTypeMode$.MODULE$.optionIntToTE(si.rowCount()).$colon$eq(new Some((Object)BoxesRunTime.boxToInteger((int)rowCount)), (Function1 & Serializable & scala.Serializable)f -> StatsSchemaTypeMode$.MODULE$.optionIntToTE((Option<Object>)f))}), (Predef$.eq.colon.eq<Object, Conditioned>)Predef.$eq$colon$eq$.MODULE$.tpEquals()));
    }

    private CompositeKey2<Object, Object> _lookupOrCreateStatementAndReturnKey(StatementInvocationEvent se) {
        Statement statement;
        Option storedStatement;
        Statement s = new Statement(se.jdbcStatement(), se.definitionOrCallSite());
        Option option = storedStatement = this.statements().lookup(s.id(), StatsSchemaTypeMode$.MODULE$.kedForKeyedEntities(Predef$.MODULE$.$conforms(), ClassTag$.MODULE$.apply(Statement.class)), StatsSchemaTypeMode$.MODULE$.__thisDsl(), (Function1 & Serializable & scala.Serializable)t -> StatsSchemaTypeMode$.MODULE$.compositeKey2CanLookup(t));
        None$ none$ = None$.MODULE$;
        if (!(option != null ? !option.equals(none$) : none$ != null)) {
            this.statements().insert(s);
            statement = s;
        } else {
            Option mathingStatement;
            Query q = StatsSchemaTypeMode$.MODULE$.from(this.statements(), (Function1 & Serializable & scala.Serializable)st -> StatsSchemaTypeMode$.MODULE$.where((Function0<LogicalBoolean>)(Function0 & Serializable & scala.Serializable)() -> StatsSchemaTypeMode$.MODULE$.intToTE(st.hash()).$eq$eq$eq(StatsSchemaTypeMode$.MODULE$.intToTE(s.hash()), StatsSchemaTypeMode$.MODULE$.numericComparisonEvidence())).select((Function0 & Serializable & scala.Serializable)() -> st).orderBy((Function0<ExpressionNode>)(Function0 & Serializable & scala.Serializable)() -> StatsSchemaTypeMode$.MODULE$.intToTE(st.statementHashCollisionNumber())));
            IntRef lastCollisionNum = IntRef.create((int)-1);
            Option option2 = mathingStatement = StatsSchemaTypeMode$.MODULE$.queryToIterable(q).find((Function1 & Serializable & scala.Serializable)st -> BoxesRunTime.boxToBoolean((boolean)StatsSchema$.$anonfun$_lookupOrCreateStatementAndReturnKey$6(lastCollisionNum, s, st)));
            None$ none$2 = None$.MODULE$;
            if (option2 == null ? none$2 != null : !option2.equals(none$2)) {
                statement = (Statement)mathingStatement.get();
            } else {
                s.statementHashCollisionNumber_$eq(lastCollisionNum.elem + 1);
                this.statements().insert(s);
                statement = s;
            }
        }
        Statement result = statement;
        return result.id();
    }

    public static final /* synthetic */ boolean $anonfun$_lookupOrCreateStatementAndReturnKey$6(IntRef lastCollisionNum$1, Statement s$2, Statement st) {
        lastCollisionNum$1.elem = st.statementHashCollisionNumber();
        Statement statement = st;
        Statement statement2 = s$2;
        return !(statement != null ? !((Object)statement).equals(statement2) : statement2 != null);
    }

    private StatsSchema$() {
        super(StatsSchemaTypeMode$.MODULE$.thisFieldMapper());
        MODULE$ = this;
        this.statements = this.table("Statementz", ClassTag$.MODULE$.apply(Statement.class), StatsSchemaTypeMode$.MODULE$.kedForKeyedEntities(Predef$.MODULE$.$conforms(), ClassTag$.MODULE$.apply(Statement.class)));
        this.statementInvocations = this.table(ClassTag$.MODULE$.apply(StatementInvocation.class), StatsSchemaTypeMode$.MODULE$.kedForKeyedEntities(Predef$.MODULE$.$conforms(), ClassTag$.MODULE$.apply(StatementInvocation.class)));
        this.on(this.statements(), (Function1 & Serializable & scala.Serializable)s -> MODULE$.declare((Seq<BaseColumnAttributeAssignment>)Predef$.MODULE$.wrapRefArray((Object[])new BaseColumnAttributeAssignment[]{StatsSchemaTypeMode$.MODULE$.stringToTE(s.sql()).is((Seq<AttributeValidOnNumericalColumn>)Predef$.MODULE$.wrapRefArray((Object[])new AttributeValidOnNumericalColumn[]{MODULE$.dbType("clob")}), MODULE$.thisSchema()), StatsSchemaTypeMode$.MODULE$.stringToTE(s.definitionOrCallSite()).is((Seq<AttributeValidOnNumericalColumn>)Predef$.MODULE$.wrapRefArray((Object[])new AttributeValidOnNumericalColumn[]{MODULE$.dbType("varchar(512)")}), MODULE$.thisSchema())})));
    }
}

