/*
 * Decompiled with CFR 0.152.
 */
package org.squeryl.logging;

import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintStream;
import org.squeryl.InternalFieldMapper$;
import org.squeryl.logging.BarChartRenderer;
import org.squeryl.logging.Measure$;
import org.squeryl.logging.StatLine;
import org.squeryl.logging.StatsSchema$;
import scala.Function1;
import scala.Serializable;
import scala.collection.Seq;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ScalaRunTime$;
import scala.xml.Unparsed$;

public final class BarChartRenderer$ {
    public static BarChartRenderer$ MODULE$;
    private final String drawFunc;

    static {
        new BarChartRenderer$();
    }

    public void generateStatSummary(File staticHtmlFile, int n) {
        String page = this.page((scala.collection.immutable.Seq<BarChartRenderer.Stat>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new BarChartRenderer.Stat[]{new BarChartRenderer.Stat(new StringBuilder(32).append("Top ").append(n).append(" statements with longest avg").toString(), "avg time", InternalFieldMapper$.MODULE$.queryToIterable(StatsSchema$.MODULE$.topRankingStatements(n, Measure$.MODULE$.AvgExecTime())), (Function1<StatLine, String>)(Function1 & java.io.Serializable & Serializable)sl -> ((Object)BoxesRunTime.boxToDouble((double)sl.avgExecTime())).toString()), new BarChartRenderer.Stat(new StringBuilder(27).append("Top ").append(n).append(" most called statements").toString(), "invocation count", InternalFieldMapper$.MODULE$.queryToIterable(StatsSchema$.MODULE$.topRankingStatements(n, Measure$.MODULE$.InvocationCount())), (Function1<StatLine, String>)(Function1 & java.io.Serializable & Serializable)sl -> ((Object)BoxesRunTime.boxToLong((long)sl.invocationCount())).toString()), new BarChartRenderer.Stat(new StringBuilder(56).append("Top ").append(n).append(" statements incurring most cumulative execution time").toString(), "cumulative execution time", InternalFieldMapper$.MODULE$.queryToIterable(StatsSchema$.MODULE$.topRankingStatements(n, Measure$.MODULE$.CumulativeExecutionTime())), (Function1<StatLine, String>)(Function1 & java.io.Serializable & Serializable)sl -> ((Object)BoxesRunTime.boxToLong((long)sl.cumulativeExecutionTime())).toString()), new BarChartRenderer.Stat(new StringBuilder(42).append("Top ").append(n).append(" statements with highest avg row count").toString(), "avg row count", InternalFieldMapper$.MODULE$.queryToIterable(StatsSchema$.MODULE$.topRankingStatements(n, Measure$.MODULE$.AvgResultSetSize())), (Function1<StatLine, String>)(Function1 & java.io.Serializable & Serializable)sl -> ((Object)BoxesRunTime.boxToFloat((float)sl.avgRowCount())).toString())}));
        PrintStream ps = new PrintStream(new FileOutputStream(staticHtmlFile));
        ps.print(page);
        ps.close();
    }

    public String drawFunc() {
        return this.drawFunc;
    }

    public String funcCalls(Seq<BarChartRenderer.Stat> stats) {
        StringBuilder sb = new StringBuilder();
        IntRef i = IntRef.create((int)0);
        stats.foreach((Function1 & java.io.Serializable & Serializable)s -> {
            ++i$1.elem;
            sb.append("drawBarGraph('chart");
            sb.append(i$1.elem);
            sb.append("','");
            sb.append(s.title());
            sb.append("','");
            sb.append(s.xAxisLabel());
            sb.append("',");
            sb.append(s.queryLabelsJSArray());
            sb.append(",");
            sb.append(s.measuresJSArray());
            return sb.append(");\n");
        });
        return sb.toString();
    }

    public String page(scala.collection.immutable.Seq<BarChartRenderer.Stat> stats) {
        return new StringBuilder(1018).append("\r\n    <html xmlns=\"http://www.w3.org/1999/xhtml\">\r\n      <head>\r\n        <meta http-equiv=\"content-type\" content=\"text/html; charset=utf-8\"/>\r\n        <title>Performance profile of Squeryl queries</title>\r\n        <script type=\"text/javascript\" src=\"http://www.google.com/jsapi\"></script>\r\n        <script type=\"text/javascript\">\r\n          google.load('visualization', '1', {{packages: ['corechart']}});\r\n        </script>\r\n        <script type=\"text/javascript\">\r\n\r\n          ").append(Unparsed$.MODULE$.apply(this.drawFunc())).append("\r\n\r\n          function drawVisualization() {{\r\n            ").append(Unparsed$.MODULE$.apply(this.funcCalls((Seq<BarChartRenderer.Stat>)stats))).append("\r\n          }}\r\n\r\n          google.setOnLoadCallback(drawVisualization);\r\n        </script>\r\n      </head>\r\n      <body style=\"font-family: Arial;border: 0 none;\">\r\n        <div id=\"chart1\" style=\"width: 1000px; height: 400px;\"></div>\r\n        <div id=\"chart2\" style=\"width: 1000px; height: 400px;\"></div>\r\n        <div id=\"chart3\" style=\"width: 1000px; height: 400px;\"></div>\r\n        <div id=\"chart4\" style=\"width: 1000px; height: 400px;\"></div>\r\n      </body>\r\n    </html>\r\n    ").toString();
    }

    private BarChartRenderer$() {
        MODULE$ = this;
        this.drawFunc = "\r\n    function drawBarGraph(divId, chartTitle, statType, queryClasses, measure) {\r\n              var data = new google.visualization.DataTable();\r\n\r\n              data.addColumn('string', 'Z');\r\n              data.addColumn('number', statType);\r\n\r\n              data.addRows(queryClasses.length);\r\n\r\n              for (var j = 0; j < queryClasses.length; ++j) {\r\n                data.setValue(j, 0, queryClasses[j].toString());\r\n                data.setValue(j, 1, measure[j]);\r\n              }\r\n\r\n              var v = new google.visualization.BarChart(document.getElementById(divId))\r\n\r\n              v.draw(data,\r\n                       {title: chartTitle,\r\n                        width:600, height:400,\r\n                        vAxis: {title: \"Queries\"},\r\n                        hAxis: {title: statType}\r\n                       }\r\n                  );\r\n    }\r\n  ";
    }
}

