/*
 * Decompiled with CFR 0.152.
 */
package org.squeryl.logging;

import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import org.squeryl.InternalFieldMapper$;
import org.squeryl.logging.BarChartRenderer;
import org.squeryl.logging.Measure$;
import org.squeryl.logging.StatLine;
import org.squeryl.logging.StatsSchema$;
import scala.Function1;
import scala.collection.Seq;
import scala.runtime.IntRef;
import scala.runtime.ScalaRunTime$;
import scala.xml.Unparsed$;

public final class BarChartRenderer$ {
    public static final BarChartRenderer$ MODULE$ = new BarChartRenderer$();
    private static final String drawFunc = "\n    function drawBarGraph(divId, chartTitle, statType, queryClasses, measure) {\n              var data = new google.visualization.DataTable();\n\n              data.addColumn('string', 'Z');\n              data.addColumn('number', statType);\n\n              data.addRows(queryClasses.length);\n\n              for (var j = 0; j < queryClasses.length; ++j) {\n                data.setValue(j, 0, queryClasses[j].toString());\n                data.setValue(j, 1, measure[j]);\n              }\n\n              var v = new google.visualization.BarChart(document.getElementById(divId))\n\n              v.draw(data,\n                       {title: chartTitle,\n                        width:600, height:400,\n                        vAxis: {title: \"Queries\"},\n                        hAxis: {title: statType}\n                       }\n                  );\n    }\n  ";

    public void generateStatSummary(File staticHtmlFile, int n) {
        String page = this.page((scala.collection.immutable.Seq<BarChartRenderer.Stat>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new BarChartRenderer.Stat[]{new BarChartRenderer.Stat(new StringBuilder(32).append("Top ").append(n).append(" statements with longest avg").toString(), "avg time", InternalFieldMapper$.MODULE$.queryToIterable(StatsSchema$.MODULE$.topRankingStatements(n, Measure$.MODULE$.AvgExecTime())), (Function1<StatLine, String>)(Function1 & Serializable)sl -> Double.toString(sl.avgExecTime())), new BarChartRenderer.Stat(new StringBuilder(27).append("Top ").append(n).append(" most called statements").toString(), "invocation count", InternalFieldMapper$.MODULE$.queryToIterable(StatsSchema$.MODULE$.topRankingStatements(n, Measure$.MODULE$.InvocationCount())), (Function1<StatLine, String>)(Function1 & Serializable)sl -> Long.toString(sl.invocationCount())), new BarChartRenderer.Stat(new StringBuilder(56).append("Top ").append(n).append(" statements incurring most cumulative execution time").toString(), "cumulative execution time", InternalFieldMapper$.MODULE$.queryToIterable(StatsSchema$.MODULE$.topRankingStatements(n, Measure$.MODULE$.CumulativeExecutionTime())), (Function1<StatLine, String>)(Function1 & Serializable)sl -> Long.toString(sl.cumulativeExecutionTime())), new BarChartRenderer.Stat(new StringBuilder(42).append("Top ").append(n).append(" statements with highest avg row count").toString(), "avg row count", InternalFieldMapper$.MODULE$.queryToIterable(StatsSchema$.MODULE$.topRankingStatements(n, Measure$.MODULE$.AvgResultSetSize())), (Function1<StatLine, String>)(Function1 & Serializable)sl -> Float.toString(sl.avgRowCount()))}));
        PrintStream ps = new PrintStream(new FileOutputStream(staticHtmlFile));
        ps.print(page);
        ps.close();
    }

    public String drawFunc() {
        return drawFunc;
    }

    public String funcCalls(Seq<BarChartRenderer.Stat> stats) {
        StringBuilder sb = new StringBuilder();
        IntRef i = IntRef.create((int)0);
        stats.foreach((Function1 & Serializable)s -> {
            ++i$1.elem;
            sb.append("drawBarGraph('chart");
            sb.append(i$1.elem);
            sb.append("','");
            sb.append(s.title());
            sb.append("','");
            sb.append(s.xAxisLabel());
            sb.append("',");
            sb.append(s.queryLabelsJSArray());
            sb.append(",");
            sb.append(s.measuresJSArray());
            return sb.append(");\n");
        });
        return sb.toString();
    }

    public String page(scala.collection.immutable.Seq<BarChartRenderer.Stat> stats) {
        return new StringBuilder(991).append("\n    <html xmlns=\"http://www.w3.org/1999/xhtml\">\n      <head>\n        <meta http-equiv=\"content-type\" content=\"text/html; charset=utf-8\"/>\n        <title>Performance profile of Squeryl queries</title>\n        <script type=\"text/javascript\" src=\"http://www.google.com/jsapi\"></script>\n        <script type=\"text/javascript\">\n          google.load('visualization', '1', {{packages: ['corechart']}});\n        </script>\n        <script type=\"text/javascript\">\n\n          ").append(Unparsed$.MODULE$.apply(this.drawFunc())).append("\n\n          function drawVisualization() {{\n            ").append(Unparsed$.MODULE$.apply(this.funcCalls((Seq<BarChartRenderer.Stat>)stats))).append("\n          }}\n\n          google.setOnLoadCallback(drawVisualization);\n        </script>\n      </head>\n      <body style=\"font-family: Arial;border: 0 none;\">\n        <div id=\"chart1\" style=\"width: 1000px; height: 400px;\"></div>\n        <div id=\"chart2\" style=\"width: 1000px; height: 400px;\"></div>\n        <div id=\"chart3\" style=\"width: 1000px; height: 400px;\"></div>\n        <div id=\"chart4\" style=\"width: 1000px; height: 400px;\"></div>\n      </body>\n    </html>\n    ").toString();
    }

    private BarChartRenderer$() {
    }
}

