/*
 * Decompiled with CFR 0.152.
 */
package org.squeryl.logging;

import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintStream;
import org.squeryl.logging.BarChartRenderer;
import org.squeryl.logging.Measure$;
import org.squeryl.logging.StatLine;
import org.squeryl.logging.StatsSchema$;
import scala.Function1;
import scala.Predef$;
import scala.ScalaObject;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class BarChartRenderer$
implements ScalaObject {
    public static final BarChartRenderer$ MODULE$;
    private final String drawFunc;

    static {
        new BarChartRenderer$();
    }

    public void generateStatSummary(File staticHtmlFile, int n) {
        String page = this.page((Seq<BarChartRenderer.Stat>)Predef$.MODULE$.wrapRefArray((Object[])new BarChartRenderer.Stat[]{new BarChartRenderer.Stat(new StringBuilder().append((Object)"Top ").append((Object)BoxesRunTime.boxToInteger((int)n)).append((Object)" statements with longest avg").toString(), "avg time", StatsSchema$.MODULE$.topRankingStatements(n, Measure$.MODULE$.AvgExecTime()), (Function1<StatLine, String>)new Serializable(){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final String apply(StatLine sl) {
                return ((Object)BoxesRunTime.boxToDouble((double)sl.avgExecTime())).toString();
            }
        }), new BarChartRenderer.Stat(new StringBuilder().append((Object)"Top ").append((Object)BoxesRunTime.boxToInteger((int)n)).append((Object)" most called statements").toString(), "invocation count", StatsSchema$.MODULE$.topRankingStatements(n, Measure$.MODULE$.InvocationCount()), (Function1<StatLine, String>)new Serializable(){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final String apply(StatLine sl) {
                return ((Object)BoxesRunTime.boxToLong((long)sl.invocationCount())).toString();
            }
        }), new BarChartRenderer.Stat(new StringBuilder().append((Object)"Top ").append((Object)BoxesRunTime.boxToInteger((int)n)).append((Object)" statements incurring most cummulative execution time").toString(), "cummulative execution time", StatsSchema$.MODULE$.topRankingStatements(n, Measure$.MODULE$.CumulativeExecutionTime()), (Function1<StatLine, String>)new Serializable(){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final String apply(StatLine sl) {
                return ((Object)BoxesRunTime.boxToLong((long)sl.cumulativeExecutionTime())).toString();
            }
        }), new BarChartRenderer.Stat(new StringBuilder().append((Object)"Top ").append((Object)BoxesRunTime.boxToInteger((int)n)).append((Object)" statements with highest avg row count").toString(), "avg row count", StatsSchema$.MODULE$.topRankingStatements(n, Measure$.MODULE$.AvgResultSetSize()), (Function1<StatLine, String>)new Serializable(){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final String apply(StatLine sl) {
                return ((Object)BoxesRunTime.boxToFloat((float)sl.avgRowCount())).toString();
            }
        })}));
        PrintStream ps = new PrintStream(new FileOutputStream(staticHtmlFile));
        ps.print(page);
        ps.close();
    }

    public String drawFunc() {
        return this.drawFunc;
    }

    public String funcCalls(Seq<BarChartRenderer.Stat> stats) {
        StringBuffer sb$1 = new StringBuffer();
        IntRef i$1 = new IntRef(0);
        stats.foreach((Function1)new Serializable(sb$1, i$1){
            public static final long serialVersionUID;
            private final StringBuffer sb$1;
            private final IntRef i$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final StringBuffer apply(BarChartRenderer.Stat s) {
                ++this.i$1.elem;
                this.sb$1.append("drawBarGraph('chart");
                this.sb$1.append(this.i$1.elem);
                this.sb$1.append("','");
                this.sb$1.append(s.title());
                this.sb$1.append("','");
                this.sb$1.append(s.xAxisLabel());
                this.sb$1.append("',");
                this.sb$1.append(s.queryLabelsJSArray());
                this.sb$1.append(",");
                this.sb$1.append(s.measuresJSArray());
                return this.sb$1.append(");\n");
            }
            {
                this.sb$1 = stringBuffer;
                this.i$1 = intRef;
            }
        });
        return sb$1.toString();
    }

    public String page(Seq<BarChartRenderer.Stat> stats) {
        return "\r\n    <html xmlns=\"http://www.w3.org/1999/xhtml\">\r\n      <head>\r\n        <meta http-equiv=\"content-type\" content=\"text/html; charset=utf-8\"/>\r\n        <title>Performance profile of Squeryl queries</title>\r\n        <script type=\"text/javascript\" src=\"http://www.google.com/jsapi\"></script>\r\n        <script type=\"text/javascript\">\r\n          google.load('visualization', '1', {{packages: ['corechart']}});\r\n        </script>\r\n        <script type=\"text/javascript\">\r\n\r\n          {Unparsed(drawFunc)}\r\n\r\n          function drawVisualization() {{\r\n            {Unparsed(funcCalls(stats))}\r\n          }}\r\n\r\n          google.setOnLoadCallback(drawVisualization);\r\n        </script>\r\n      </head>\r\n      <body style=\"font-family: Arial;border: 0 none;\">\r\n        <div id=\"chart1\" style=\"width: 1000px; height: 400px;\"></div>\r\n        <div id=\"chart2\" style=\"width: 1000px; height: 400px;\"></div>\r\n        <div id=\"chart3\" style=\"width: 1000px; height: 400px;\"></div>\r\n        <div id=\"chart4\" style=\"width: 1000px; height: 400px;\"></div>\r\n      </body>\r\n    </html>\r\n    ";
    }

    private BarChartRenderer$() {
        MODULE$ = this;
        this.drawFunc = "\r\n    function drawBarGraph(divId, chartTitle, statType, queryClasses, measure) {\r\n              var data = new google.visualization.DataTable();\r\n\r\n              data.addColumn('string', 'Z');\r\n              data.addColumn('number', statType);\r\n\r\n              data.addRows(queryClasses.length);\r\n\r\n              for (var j = 0; j < queryClasses.length; ++j) {\r\n                data.setValue(j, 0, queryClasses[j].toString());\r\n                data.setValue(j, 1, measure[j]);\r\n              }\r\n\r\n              var v = new google.visualization.BarChart(document.getElementById(divId))\r\n\r\n              v.draw(data,\r\n                       {title: chartTitle,\r\n                        width:600, height:400,\r\n                        vAxis: {title: \"Queries\"},\r\n                        hAxis: {title: statType}\r\n                       }\r\n                  );\r\n    }\r\n  ";
    }
}

