/*
 * Decompiled with CFR 0.152.
 */
package org.standardout.gradle.plugin.platform.internal.util.bnd;

import aQute.bnd.osgi.Analyzer;
import aQute.bnd.osgi.Builder;
import aQute.bnd.osgi.Jar;
import java.io.File;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.jar.Manifest;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;

public class BndHelper {
    public static Builder createBuilder() {
        Builder b = new Builder();
        b.setTrace(false);
        b.setPedantic(true);
        b.setFailOk(false);
        return b;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void buildAndClose(Builder b, File target) throws Exception {
        block5: {
            try {
                b.build();
                if (b.isOk()) {
                    b.save(target, true);
                    if (!b.isOk()) {
                        target.delete();
                        throw new IllegalStateException("Failed to save bundled jar");
                    }
                    break block5;
                }
                throw new IllegalStateException("Failed to build bnd configuration");
            }
            finally {
                b.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean wrap(File source, Collection<File> classpath, File target, Map<String, String> properties, boolean removeSignature) throws Exception {
        File file = source;
        try (ZipFile zip = new ZipFile(file);){
            if (!zip.entries().hasMoreElements()) {
                boolean bl = false;
                return bl;
            }
        }
        catch (ZipException e) {
            return false;
        }
        try (Analyzer wrapper = new Analyzer();){
            if (classpath != null) {
                for (File f : classpath) {
                    wrapper.addClasspath(f);
                }
            }
            wrapper.setJar(file);
            if (removeSignature) {
                BndHelper.doRemoveSignature(wrapper.getJar());
            }
            File outputFile = target;
            outputFile.delete();
            wrapper.setImportPackage("*;resolution:=optional");
            wrapper.setExportPackage("*");
            wrapper.addProperties(properties);
            Manifest m = wrapper.calcManifest();
            if (!wrapper.isOk()) throw new IllegalStateException("Failed calculating the manifest for a wrapped bundle");
            wrapper.getJar().setManifest(m);
            wrapper.save(outputFile, true);
            if (wrapper.isOk()) return true;
            throw new IllegalStateException("Failed creating a wrapped bundle");
        }
    }

    private static void doRemoveSignature(Jar jar) {
        Map metaInf = (Map)jar.getDirectories().get("META-INF");
        HashSet<String> toRemove = new HashSet<String>();
        if (metaInf != null) {
            for (String resource : metaInf.keySet()) {
                String upper = resource.toUpperCase();
                if (!upper.endsWith(".SF") && !upper.endsWith(".RSA") && !upper.endsWith(".DSA")) continue;
                toRemove.add(resource);
            }
        }
        for (String resource : toRemove) {
            jar.remove(resource);
        }
    }
}

