/*
 * Decompiled with CFR 0.152.
 */
package org.standardout.gradle.plugin.platform.internal.util.bnd;

import aQute.bnd.osgi.Analyzer;
import aQute.bnd.osgi.Builder;
import aQute.bnd.osgi.Instruction;
import aQute.bnd.osgi.Instructions;
import aQute.bnd.osgi.Jar;
import aQute.libg.tuple.Pair;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.Manifest;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;

public class BndHelper {
    public static Builder createBuilder() {
        Builder b = new Builder();
        b.setTrace(false);
        b.setPedantic(true);
        b.setFailOk(false);
        return b;
    }

    public static void buildAndClose(Builder b, File target) throws Exception {
        block5: {
            try {
                b.build();
                if (b.isOk()) {
                    b.save(target, true);
                    if (!b.isOk()) {
                        target.delete();
                        throw new IllegalStateException("Failed to save bundled jar");
                    }
                    break block5;
                }
                throw new IllegalStateException("Failed to build bnd configuration");
            }
            finally {
                b.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean wrap(File source, Collection<File> classpath, File target, Map<String, String> properties, boolean removeSignature) throws Exception {
        File file = source;
        try (ZipFile zip = new ZipFile(file);){
            if (!zip.entries().hasMoreElements()) {
                boolean bl = false;
                return bl;
            }
        }
        catch (ZipException e) {
            return false;
        }
        Analyzer wrapper = new Analyzer();
        wrapper.setProperty("-noextraheaders", "true");
        wrapper.setProperty("-failok", "true");
        try {
            if (classpath != null) {
                for (File f : classpath) {
                    wrapper.addClasspath(f);
                }
            }
            wrapper.setJar(file);
            if (removeSignature) {
                BndHelper.doRemoveSignature(wrapper.getJar());
            }
            File outputFile = target;
            outputFile.delete();
            wrapper.setImportPackage("*;resolution:=optional");
            wrapper.setExportPackage("*");
            wrapper.addProperties(properties);
            Manifest m = wrapper.calcManifest();
            if (!wrapper.isOk()) throw new IllegalStateException("Failed calculating the manifest for a wrapped bundle: " + wrapper.getErrors());
            if (wrapper.getErrors() != null && !wrapper.getErrors().isEmpty()) {
                String name = (String)wrapper.getBundleSymbolicName().getKey();
                for (String error : wrapper.getErrors()) {
                    System.out.println("Error reported by bundle wrapper for bundle " + name + " is ignored:\n" + error);
                }
            }
            wrapper.getJar().setManifest(m);
            wrapper.save(outputFile, true);
            if (!wrapper.isOk()) throw new IllegalStateException("Failed creating a wrapped bundle");
            if (outputFile.exists()) return true;
            throw new IllegalStateException("Failed creating a wrapped bundle");
        }
        finally {
            wrapper.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Pair<String, List<String>> getSymbolicNameAndPackageImports(File bundle) throws Exception {
        try (Jar jar = null;){
            jar = new Jar(bundle);
            Manifest manifest = jar.getManifest();
            String bundleSymbolicname = manifest.getMainAttributes().getValue("Bundle-SymbolicName");
            String importPackages = manifest.getMainAttributes().getValue("Import-Package");
            if (null == importPackages) {
                List emptyList = Collections.emptyList();
                Pair pair = Pair.newInstance((Object)bundleSymbolicname, emptyList);
                return pair;
            }
            Instructions instructions = new Instructions(importPackages);
            ArrayList<String> imports = new ArrayList<String>(instructions.size());
            Set instructionsKeySet = instructions.keySet();
            for (Instruction instruction : instructionsKeySet) {
                String input = instruction.getInput();
                imports.add(input);
            }
            Pair pair = Pair.newInstance((Object)bundleSymbolicname, imports);
            return pair;
        }
    }

    private static void doRemoveSignature(Jar jar) {
        Map metaInf = (Map)jar.getDirectories().get("META-INF");
        HashSet<String> toRemove = new HashSet<String>();
        if (metaInf != null) {
            for (String resource : metaInf.keySet()) {
                String upper = resource.toUpperCase();
                if (!upper.endsWith(".SF") && !upper.endsWith(".RSA") && !upper.endsWith(".DSA")) continue;
                toRemove.add(resource);
            }
        }
        for (String resource : toRemove) {
            jar.remove(resource);
        }
    }
}

