/*
 * Decompiled with CFR 0.152.
 */
package org.starchartlabs.alloy.core;

import java.util.Comparator;
import java.util.Iterator;
import java.util.Objects;
import java.util.Optional;

public final class Comparators {
    private Comparators() throws InstantiationException {
        throw new InstantiationException("Cannot instantiate instance of utility class '" + this.getClass().getName() + "'");
    }

    public static <T> boolean isInOrder(Iterable<? extends T> iterable, Comparator<T> comparator) {
        Objects.requireNonNull(iterable);
        Objects.requireNonNull(comparator);
        Iterator<T> it = iterable.iterator();
        if (it.hasNext()) {
            T prev = it.next();
            while (it.hasNext()) {
                T next = it.next();
                if (comparator.compare(prev, next) > 0) {
                    return false;
                }
                prev = next;
            }
        }
        return true;
    }

    public static <T> boolean isInStrictOrder(Iterable<? extends T> iterable, Comparator<T> comparator) {
        Objects.requireNonNull(iterable);
        Objects.requireNonNull(comparator);
        Iterator<T> it = iterable.iterator();
        if (it.hasNext()) {
            T prev = it.next();
            while (it.hasNext()) {
                T next = it.next();
                if (comparator.compare(prev, next) >= 0) {
                    return false;
                }
                prev = next;
            }
        }
        return true;
    }

    public static <T> Comparator<Optional<T>> emptiesFirst(Comparator<? super T> valueComparator) {
        Objects.requireNonNull(valueComparator);
        return new EmptyOptionalComparator<T>(true, valueComparator);
    }

    public static <T> Comparator<Optional<T>> emptiesLast(Comparator<? super T> valueComparator) {
        Objects.requireNonNull(valueComparator);
        return new EmptyOptionalComparator<T>(false, valueComparator);
    }

    private static final class EmptyOptionalComparator<T>
    implements Comparator<Optional<T>> {
        private final boolean emptiesFirst;
        private final Comparator<T> valueComparator;

        public EmptyOptionalComparator(boolean emptiesFirst, Comparator<? super T> valueComparator) {
            this.emptiesFirst = emptiesFirst;
            this.valueComparator = Objects.requireNonNull(valueComparator);
        }

        @Override
        public int compare(Optional<T> a, Optional<T> b) {
            boolean bEmpty;
            boolean aEmpty = a != null && !a.isPresent();
            boolean bl = bEmpty = b != null && !b.isPresent();
            if (aEmpty) {
                return bEmpty ? 0 : (this.emptiesFirst ? -1 : 1);
            }
            if (bEmpty) {
                return this.emptiesFirst ? 1 : -1;
            }
            return this.valueComparator.compare(a.get(), b.get());
        }

        @Override
        public Comparator<Optional<T>> reversed() {
            return new EmptyOptionalComparator<T>(!this.emptiesFirst, this.valueComparator.reversed());
        }
    }
}

