/*
 * Decompiled with CFR 0.152.
 */
package org.starchartlabs.alloy.core;

import java.util.Objects;
import java.util.function.Supplier;
import javax.annotation.Nullable;

public final class Preconditions {
    private Preconditions() throws InstantiationException {
        throw new InstantiationException("Cannot instantiate instance of utility class '" + this.getClass().getName() + "'");
    }

    public static void checkArgument(boolean expression) {
        if (!expression) {
            throw new IllegalArgumentException();
        }
    }

    public static void checkArgument(boolean expression, @Nullable Object errorMessage) {
        if (!expression) {
            throw new IllegalArgumentException(String.valueOf(errorMessage));
        }
    }

    public static void checkArgument(boolean expression, Supplier<String> errorMessageSupplier) {
        Objects.requireNonNull(errorMessageSupplier);
        if (!expression) {
            throw new IllegalArgumentException(String.valueOf(errorMessageSupplier.get()));
        }
    }

    public static void checkState(boolean expression) {
        if (!expression) {
            throw new IllegalStateException();
        }
    }

    public static void checkState(boolean expression, @Nullable Object errorMessage) {
        if (!expression) {
            throw new IllegalStateException(String.valueOf(errorMessage));
        }
    }

    public static void checkState(boolean expression, @Nullable Supplier<String> errorMessageSupplier) {
        Objects.requireNonNull(errorMessageSupplier);
        if (!expression) {
            throw new IllegalStateException(String.valueOf(errorMessageSupplier.get()));
        }
    }
}

