/*
 * Decompiled with CFR 0.152.
 */
package org.starchartlabs.alloy.core;

import java.io.Serializable;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.starchartlabs.alloy.core.Preconditions;

public final class Suppliers {
    private Suppliers() throws InstantiationException {
        throw new InstantiationException("Cannot instantiate instance of utility class '" + this.getClass().getName() + "'");
    }

    public static <S, T> Supplier<T> map(Supplier<S> supplier, Function<S, T> function) {
        return new MappingSupplier<S, T>(supplier, function);
    }

    public static <T> Supplier<T> memoize(Supplier<T> delegate) {
        return new MemoizingSupplier<T>(delegate);
    }

    public static <T> Supplier<T> memoizeWithExpiration(Supplier<T> delegate, long duration, TimeUnit unit) {
        return new MemoizingWithExpirationSupplier(delegate, duration, unit);
    }

    public static <T> Supplier<T> synchronizedSupplier(Supplier<T> delegate) {
        return new SynchronizedSupplier(delegate);
    }

    private static class SynchronizedSupplier<T>
    implements Supplier<T>,
    Serializable {
        private static final long serialVersionUID = 0L;
        private final Supplier<T> delegate;

        private SynchronizedSupplier(Supplier<T> delegate) {
            this.delegate = Objects.requireNonNull(delegate);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public T get() {
            Supplier<T> supplier = this.delegate;
            synchronized (supplier) {
                return this.delegate.get();
            }
        }

        public int hashCode() {
            return Objects.hash(this.delegate);
        }

        public boolean equals(@Nullable Object obj) {
            boolean result = false;
            if (obj instanceof SynchronizedSupplier) {
                SynchronizedSupplier compare = (SynchronizedSupplier)obj;
                result = Objects.equals(compare.delegate, this.delegate);
            }
            return result;
        }

        public String toString() {
            return "Suppliers.synchronizedSupplier(" + this.delegate + ")";
        }
    }

    private static class MemoizingWithExpirationSupplier<T>
    implements Supplier<T>,
    Serializable {
        private static final long serialVersionUID = 0L;
        private final Supplier<T> delegate;
        private final long durationNanos;
        private volatile transient boolean initialized;
        private volatile transient long expirationNanos;
        private transient T value;

        private MemoizingWithExpirationSupplier(Supplier<T> delegate, long duration, TimeUnit unit) {
            Objects.requireNonNull(unit);
            this.delegate = Objects.requireNonNull(delegate);
            this.durationNanos = unit.toNanos(duration);
            this.initialized = false;
            Preconditions.checkArgument(duration > 0L, "Expiration duration must be greater than 0");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public T get() {
            long now = System.nanoTime();
            if (!this.initialized || now - this.expirationNanos >= 0L) {
                MemoizingWithExpirationSupplier memoizingWithExpirationSupplier = this;
                synchronized (memoizingWithExpirationSupplier) {
                    this.value = this.delegate.get();
                    this.initialized = true;
                    this.expirationNanos = now + this.durationNanos;
                }
            }
            return this.value;
        }

        public int hashCode() {
            return Objects.hash(this.delegate, this.durationNanos);
        }

        public boolean equals(@Nullable Object obj) {
            boolean result = false;
            if (obj instanceof MemoizingWithExpirationSupplier) {
                MemoizingWithExpirationSupplier compare = (MemoizingWithExpirationSupplier)obj;
                result = Objects.equals(compare.delegate, this.delegate) && Objects.equals(compare.durationNanos, this.durationNanos);
            }
            return result;
        }

        public String toString() {
            return "Suppliers.memoizeWithExpiration(" + this.delegate + ", " + this.durationNanos + ", NANOS)";
        }
    }

    private static final class MemoizingSupplier<T>
    implements Supplier<T>,
    Serializable {
        private static final long serialVersionUID = 0L;
        private final Supplier<T> delegate;
        private volatile transient boolean initialized;
        private transient T cached;

        public MemoizingSupplier(Supplier<T> delegate) {
            this.delegate = Objects.requireNonNull(delegate);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public T get() {
            if (!this.initialized) {
                MemoizingSupplier memoizingSupplier = this;
                synchronized (memoizingSupplier) {
                    if (!this.initialized) {
                        this.cached = this.delegate.get();
                        this.initialized = true;
                    }
                }
            }
            return this.cached;
        }

        public int hashCode() {
            return Objects.hash(this.delegate);
        }

        public boolean equals(@Nullable Object obj) {
            boolean result = false;
            if (obj instanceof MemoizingSupplier) {
                MemoizingSupplier compare = (MemoizingSupplier)obj;
                result = Objects.equals(compare.delegate, this.delegate);
            }
            return result;
        }

        public String toString() {
            return "Suppliers.memoize(" + this.delegate + ")";
        }
    }

    private static final class MappingSupplier<S, T>
    implements Supplier<T>,
    Serializable {
        private static final long serialVersionUID = 0L;
        private final Supplier<S> supplier;
        private final Function<S, T> function;

        public MappingSupplier(Supplier<S> supplier, Function<S, T> function) {
            this.supplier = Objects.requireNonNull(supplier);
            this.function = Objects.requireNonNull(function);
        }

        @Override
        public T get() {
            return this.function.apply(this.supplier.get());
        }

        public int hashCode() {
            return Objects.hash(this.supplier, this.function);
        }

        public boolean equals(@Nullable Object obj) {
            boolean result = false;
            if (obj instanceof MappingSupplier) {
                MappingSupplier compare = (MappingSupplier)obj;
                result = Objects.equals(compare.supplier, this.supplier) && Objects.equals(compare.function, this.function);
            }
            return result;
        }

        public String toString() {
            return "Suppliers.map(" + this.supplier + ", " + this.function + ")";
        }
    }
}

