/*
 * Decompiled with CFR 0.152.
 */
package org.starchartlabs.alloy.core.collections;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;

public final class MoreCollections {
    public static <K, V> MapBuilder<K, V> mapBuilder() {
        return new MapBuilder();
    }

    public static final class MapBuilder<K, V> {
        private List<Map.Entry<K, V>> values = new ArrayList<Map.Entry<K, V>>();
        private boolean unmodifiable = true;

        private MapBuilder() {
        }

        public MapBuilder<K, V> put(K key, V value) {
            this.values.add(new AbstractMap.SimpleEntry<K, V>(key, value));
            return this;
        }

        public MapBuilder<K, V> putAll(Map<? extends K, ? extends V> m) {
            Objects.requireNonNull(m);
            for (Map.Entry<K, V> entry : m.entrySet()) {
                this.put(entry.getKey(), entry.getValue());
            }
            return this;
        }

        public MapBuilder<K, V> mutable() {
            this.unmodifiable = false;
            return this;
        }

        public Map<K, V> build() {
            return this.build(HashMap::new);
        }

        public Map<K, V> build(Supplier<Map<K, V>> mapSupplier) {
            Objects.requireNonNull(mapSupplier);
            Map<K, V> result = mapSupplier.get();
            for (Map.Entry<K, V> entry : this.values) {
                result.put(entry.getKey(), entry.getValue());
            }
            if (this.unmodifiable) {
                result = Collections.unmodifiableMap(result);
            }
            return result;
        }
    }
}

