/*
 * Decompiled with CFR 0.152.
 */
package org.starchartlabs.alloy.core.collections;

import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.Objects;
import java.util.Optional;
import java.util.Spliterator;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.starchartlabs.alloy.core.collections.PageIterator;

public final class MoreSpliterators {
    public static <T, A> Spliterator<T> shortCircuit(Spliterator<T> spliterator, BiFunction<Optional<A>, ? super T, A> accumulator, Predicate<A> completedPredicate) {
        return new ShortCircuitSpliterator<T, A>(spliterator, accumulator, completedPredicate);
    }

    public static <T> Spliterator<T> ofPaged(PageIterator<T> pageIterator) {
        return new PageSpliterator<T>(pageIterator);
    }

    private static class PageSpliterator<T>
    implements Spliterator<T> {
        private final PageIterator<T> pageIterator;
        private LinkedList<T> elements;

        public PageSpliterator(PageIterator<T> pageIterator) {
            this.pageIterator = Objects.requireNonNull(pageIterator);
            this.elements = new LinkedList();
        }

        @Override
        public boolean tryAdvance(Consumer<? super T> action) {
            T element;
            if (this.elements.isEmpty() && this.pageIterator.hasNext()) {
                this.elements.addAll((Collection)this.pageIterator.next());
            }
            if ((element = this.elements.poll()) != null) {
                action.accept(element);
            }
            return element != null;
        }

        @Override
        public Spliterator<T> trySplit() {
            return Optional.ofNullable(this.pageIterator.trySplit()).map(a -> new PageSpliterator(a)).orElse(null);
        }

        @Override
        public long estimateSize() {
            long estimate = this.pageIterator.estimateSize();
            if (Long.MAX_VALUE - (long)this.elements.size() >= estimate) {
                estimate += (long)this.elements.size();
            }
            return estimate;
        }

        @Override
        public int characteristics() {
            return 1040;
        }
    }

    private static class ShortCircuitSpliterator<T, A>
    implements Spliterator<T> {
        private static final int SUPPORTED_CHARACTERISTICS = 1301;
        private final Spliterator<T> spliterator;
        private final Predicate<A> completedPredicate;
        private final AccumulatingConsumer<T, A> consumer;

        public ShortCircuitSpliterator(Spliterator<T> spliterator, BiFunction<Optional<A>, ? super T, A> accumulator, Predicate<A> completedPredicate) {
            this.spliterator = Objects.requireNonNull(spliterator);
            this.completedPredicate = Objects.requireNonNull(completedPredicate);
            this.consumer = new AccumulatingConsumer<T, A>(accumulator);
        }

        @Override
        public boolean tryAdvance(Consumer<? super T> action) {
            boolean complete = this.consumer.getAccumulated().map(this.completedPredicate::test).orElse(false);
            if (!complete) {
                complete = !this.spliterator.tryAdvance(input -> this.consumer.accept(action, input));
            }
            return !complete;
        }

        @Override
        public Spliterator<T> trySplit() {
            return null;
        }

        @Override
        public long estimateSize() {
            return this.spliterator.estimateSize();
        }

        @Override
        public int characteristics() {
            return 0x515 & this.spliterator.characteristics();
        }

        @Override
        public Comparator<? super T> getComparator() {
            return this.spliterator.getComparator();
        }

        private static class AccumulatingConsumer<T, A> {
            private final BiFunction<Optional<A>, ? super T, A> accumulator;
            private Optional<A> accumulated;

            public AccumulatingConsumer(BiFunction<Optional<A>, ? super T, A> accumulator) {
                this.accumulator = Objects.requireNonNull(accumulator);
                this.accumulated = Optional.empty();
            }

            public void accept(Consumer<? super T> action, T input) {
                action.accept(input);
                this.accumulated = Optional.of(this.accumulator.apply(this.accumulated, (Optional<A>)input));
            }

            public Optional<A> getAccumulated() {
                return this.accumulated;
            }
        }
    }
}

