/*
 * Decompiled with CFR 0.152.
 */
package org.starchartlabs.alloy.core;

import java.util.Objects;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.starchartlabs.alloy.core.Strings;

public final class Preconditions {
    private Preconditions() throws InstantiationException {
        throw new InstantiationException("Cannot instantiate instance of utility class '" + this.getClass().getName() + "'");
    }

    public static void checkArgument(boolean expression) {
        if (!expression) {
            throw new IllegalArgumentException();
        }
    }

    public static <T> T checkArgument(@Nullable T value, Predicate<T> predicate) {
        Objects.requireNonNull(predicate);
        if (!predicate.test(value)) {
            throw new IllegalArgumentException();
        }
        return value;
    }

    public static void checkArgument(boolean expression, @Nullable Object errorMessage) {
        if (!expression) {
            throw new IllegalArgumentException(String.valueOf(errorMessage));
        }
    }

    public static <T> T checkArgument(@Nullable T value, Predicate<T> predicate, @Nullable Object errorMessage) {
        Objects.requireNonNull(predicate);
        if (!predicate.test(value)) {
            throw new IllegalArgumentException(String.valueOf(errorMessage));
        }
        return value;
    }

    public static void checkArgument(boolean expression, Supplier<String> errorMessageSupplier) {
        Objects.requireNonNull(errorMessageSupplier);
        if (!expression) {
            throw new IllegalArgumentException(String.valueOf(errorMessageSupplier.get()));
        }
    }

    public static <T> T checkArgument(@Nullable T value, Predicate<T> predicate, Supplier<String> errorMessageSupplier) {
        Objects.requireNonNull(predicate);
        Objects.requireNonNull(errorMessageSupplier);
        if (!predicate.test(value)) {
            throw new IllegalArgumentException(String.valueOf(errorMessageSupplier.get()));
        }
        return value;
    }

    public static void checkArgument(boolean expression, @Nullable String template, Object ... args) {
        if (!expression) {
            throw new IllegalArgumentException(String.valueOf(Strings.format(template, args)));
        }
    }

    public static <T> T checkArgument(@Nullable T value, Predicate<T> predicate, @Nullable String template, Object ... args) {
        Objects.requireNonNull(predicate);
        if (!predicate.test(value)) {
            throw new IllegalArgumentException(Strings.format(template, args));
        }
        return value;
    }

    public static void checkState(boolean expression) {
        if (!expression) {
            throw new IllegalStateException();
        }
    }

    public static <T> T checkState(@Nullable T value, Predicate<T> predicate) {
        Objects.requireNonNull(predicate);
        if (!predicate.test(value)) {
            throw new IllegalStateException();
        }
        return value;
    }

    public static void checkState(boolean expression, @Nullable Object errorMessage) {
        if (!expression) {
            throw new IllegalStateException(String.valueOf(errorMessage));
        }
    }

    public static <T> T checkState(@Nullable T value, Predicate<T> predicate, @Nullable Object errorMessage) {
        Objects.requireNonNull(predicate);
        if (!predicate.test(value)) {
            throw new IllegalStateException(String.valueOf(errorMessage));
        }
        return value;
    }

    public static void checkState(boolean expression, Supplier<String> errorMessageSupplier) {
        Objects.requireNonNull(errorMessageSupplier);
        if (!expression) {
            throw new IllegalStateException(String.valueOf(errorMessageSupplier.get()));
        }
    }

    public static <T> T checkState(@Nullable T value, Predicate<T> predicate, Supplier<String> errorMessageSupplier) {
        Objects.requireNonNull(predicate);
        Objects.requireNonNull(errorMessageSupplier);
        if (!predicate.test(value)) {
            throw new IllegalStateException(String.valueOf(errorMessageSupplier.get()));
        }
        return value;
    }

    public static void checkState(boolean expression, @Nullable String template, Object ... args) {
        if (!expression) {
            throw new IllegalStateException(Strings.format(template, args));
        }
    }

    public static <T> T checkState(@Nullable T value, Predicate<T> predicate, @Nullable String template, Object ... args) {
        Objects.requireNonNull(predicate);
        if (!predicate.test(value)) {
            throw new IllegalStateException(Strings.format(template, args));
        }
        return value;
    }
}

